/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.builder.config.spi;

import io.helidon.common.Weight;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigValue;
import io.helidon.pico.builder.config.spi.ConfigResolver;
import io.helidon.pico.builder.config.spi.ConfigResolverMapRequest;
import io.helidon.pico.builder.config.spi.ConfigResolverProvider;
import io.helidon.pico.builder.config.spi.ConfigResolverRequest;
import io.helidon.pico.builder.config.spi.ResolutionContext;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

@Singleton
@Weight(value=99.0)
public class DefaultConfigResolver
implements ConfigResolver,
ConfigResolverProvider {
    public static final String TAG_META = "__meta";

    @Deprecated
    public DefaultConfigResolver() {
    }

    @Override
    public ConfigResolver configResolver() {
        return this;
    }

    @Override
    public <T> Optional<T> of(ResolutionContext ctx, Map<String, Map<String, Object>> meta, ConfigResolverRequest<T> request) {
        Config attrCfg = ctx.config().get(request.configKey());
        return attrCfg.exists() ? this.optionalWrappedConfig(attrCfg, meta, request) : Optional.empty();
    }

    @Override
    public <T> Optional<Collection<T>> ofCollection(ResolutionContext ctx, Map<String, Map<String, Object>> meta, ConfigResolverRequest<T> request) {
        Config attrCfg = ctx.config().get(request.configKey());
        return attrCfg.exists() ? this.optionalWrappedConfig(attrCfg, meta, request) : Optional.empty();
    }

    @Override
    public <K, V> Optional<Map<K, V>> ofMap(ResolutionContext ctx, Map<String, Map<String, Object>> meta, ConfigResolverMapRequest<K, V> request) {
        Config attrCfg = ctx.config().get(request.configKey());
        return attrCfg.exists() ? this.optionalWrappedConfig(attrCfg, meta, request) : Optional.empty();
    }

    private <T> Optional<T> optionalWrappedConfig(Config attrCfg, Map<String, Map<String, Object>> meta, ConfigResolverRequest<T> request) {
        boolean isCharArray;
        Class componentType = request.valueComponentType().orElse(null);
        Class<Object> type = request.valueType();
        boolean isOptional = Optional.class.equals(type);
        if (isOptional) {
            type = request.valueComponentType().orElseThrow();
        }
        boolean bl = isCharArray = type.isArray() && Character.TYPE == type.getComponentType();
        if (isCharArray) {
            type = String.class;
        }
        try {
            ConfigValue attrVal = attrCfg.as(type);
            Object val = attrVal.get();
            if (isCharArray) {
                val = ((String)val).toCharArray();
            }
            return Optional.of(isOptional ? Optional.of(val) : val);
        }
        catch (Exception e) {
            String typeName = DefaultConfigResolver.toTypeNameDescription(request.valueType(), componentType);
            String configKey = attrCfg.key().toString();
            throw new IllegalStateException("Failed to convert " + typeName + " for attribute: " + request.attributeName() + " and config key: " + configKey, e);
        }
    }

    private static String toTypeNameDescription(Class<?> type, Class<?> componentType) {
        return type.getTypeName() + "<" + componentType.getTypeName() + ">";
    }
}

