/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.builder.config.spi;

import io.helidon.common.config.Config;
import io.helidon.pico.builder.config.spi.ConfigBeanBuilderValidator;
import io.helidon.pico.builder.config.spi.ConfigResolver;
import java.util.Objects;
import java.util.Optional;

public class ResolutionContext {
    private final Class<?> configBeanType;
    private final Config cfg;
    private final ConfigResolver resolver;
    private final ConfigBeanBuilderValidator<?> validator;

    protected ResolutionContext(Builder b) {
        this.configBeanType = Objects.requireNonNull(b.configBeanType);
        this.cfg = Objects.requireNonNull(b.cfg);
        this.resolver = Objects.requireNonNull(b.resolver);
        this.validator = b.validator;
    }

    public Class<?> configBeanType() {
        return this.configBeanType;
    }

    public Config config() {
        return this.cfg;
    }

    public ConfigResolver resolver() {
        return this.resolver;
    }

    public Optional<ConfigBeanBuilderValidator<?>> validator() {
        return Optional.ofNullable(this.validator);
    }

    public String toString() {
        return this.config().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ResolutionContext create(Class<?> configBeanType, Config cfg, ConfigResolver resolver, ConfigBeanBuilderValidator<?> validator) {
        return ResolutionContext.builder().configBeanType(configBeanType).config(cfg).resolver(resolver).validator(validator).build();
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, ResolutionContext> {
        private Class<?> configBeanType;
        private Config cfg;
        private ConfigResolver resolver;
        private ConfigBeanBuilderValidator<?> validator;

        protected Builder() {
        }

        public ResolutionContext build() {
            return new ResolutionContext(this);
        }

        public Builder configBeanType(Class<?> configBeanType) {
            this.configBeanType = Objects.requireNonNull(configBeanType);
            return this;
        }

        public Builder config(Config val) {
            this.cfg = Objects.requireNonNull(val);
            return (Builder)this.identity();
        }

        public Builder resolver(ConfigResolver val) {
            this.resolver = Objects.requireNonNull(val);
            return (Builder)this.identity();
        }

        public Builder validator(ConfigBeanBuilderValidator<?> val) {
            this.validator = val;
            return (Builder)this.identity();
        }
    }
}

