/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.abac.policy;

import io.helidon.common.Errors;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.security.EndpointConfig;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityLevel;
import io.helidon.security.abac.policy.spi.PolicyExecutor;
import io.helidon.security.abac.policy.spi.PolicyExecutorService;
import io.helidon.security.providers.abac.AbacAnnotation;
import io.helidon.security.providers.abac.AbacValidatorConfig;
import io.helidon.security.providers.abac.spi.AbacValidator;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;

public final class PolicyValidator
implements AbacValidator<PolicyConfig> {
    private static final System.Logger LOGGER = System.getLogger(PolicyValidator.class.getName());
    private final List<PolicyExecutor> executors = new LinkedList<PolicyExecutor>();

    private PolicyValidator(Builder builder) {
        HelidonServiceLoader services = HelidonServiceLoader.create(ServiceLoader.load(PolicyExecutorService.class));
        for (PolicyExecutorService service : services) {
            this.executors.add(service.instantiate(builder.config.get(service.configKey())));
        }
        this.executors.addAll(builder.executors);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PolicyValidator create(Config config) {
        return PolicyValidator.builder().config(config).build();
    }

    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        return Set.of(PolicyStatement.class);
    }

    public Class<PolicyConfig> configClass() {
        return PolicyConfig.class;
    }

    public String configKey() {
        return "policy-validator";
    }

    public PolicyConfig fromConfig(Config config) {
        return PolicyConfig.builder().config(config).build();
    }

    public PolicyConfig fromAnnotations(EndpointConfig endpointConfig) {
        PolicyConfig.Builder resultBuilder = PolicyConfig.builder();
        for (SecurityLevel securityLevel : endpointConfig.securityLevels()) {
            for (EndpointConfig.AnnotationScope scope : EndpointConfig.AnnotationScope.values()) {
                ArrayList annotations = new ArrayList();
                for (Class<? extends Annotation> clazz : this.supportedAnnotations()) {
                    annotations.addAll(securityLevel.filterAnnotations(clazz, scope));
                }
                for (Annotation annotation : annotations) {
                    if (!(annotation instanceof PolicyStatement)) continue;
                    PolicyStatement statement = (PolicyStatement)annotation;
                    resultBuilder.from(PolicyConfig.builder().from(statement).build());
                }
            }
        }
        return resultBuilder.build();
    }

    public void validate(PolicyConfig config, Errors.Collector collector, ProviderRequest request) {
        LinkedList<String> unvalidatedStatements = new LinkedList<String>();
        for (String statement : config.policyStatements()) {
            boolean isValidated = false;
            for (PolicyExecutor executor : this.executors) {
                if (!executor.supports(statement, request)) continue;
                executor.executePolicy(statement, collector, request);
                isValidated = true;
                break;
            }
            if (isValidated) continue;
            unvalidatedStatements.add(statement);
        }
        if (!unvalidatedStatements.isEmpty()) {
            throw new SecurityException("Missing a policy executor for policy statement(s). Statements: " + String.valueOf(unvalidatedStatements) + ", known executors: " + String.valueOf(this.executors));
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, PolicyValidator> {
        private final List<PolicyExecutor> executors = new LinkedList<PolicyExecutor>();
        private Config config = Config.empty();

        private Builder() {
        }

        public PolicyValidator build() {
            return new PolicyValidator(this);
        }

        public Builder addExecutor(PolicyExecutor executor) {
            this.executors.add(executor);
            return this;
        }

        public Builder config(Config config) {
            this.config = config;
            config.get("validators").asList(Config.class).ifPresent(configs -> {
                for (Config validatorConfig : configs) {
                    validatorConfig.get("class").asString().ifPresentOrElse(clazz -> this.addExecutor(this.instantiate((String)clazz)), () -> {
                        throw new SecurityException("validators key may only contain an array of class to class names, at key: " + String.valueOf(validatorConfig.key()));
                    });
                }
            });
            return this;
        }

        private PolicyExecutor instantiate(String className) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (Exception e) {
                throw new SecurityException("Failed to get class " + className, e);
            }
            try {
                return (PolicyExecutor)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.log(System.Logger.Level.ERROR, "Could not instantiate: " + className + ". Class must have a default public");
                throw new SecurityException("Failed to load PolicyExecutor from class " + String.valueOf(clazz), e);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    @Inherited
    @AbacAnnotation
    public static @interface PolicyStatement {
        public String value();

        public boolean inherit() default true;
    }

    public static final class PolicyConfig
    implements AbacValidatorConfig {
        private final List<String> policyStatements;
        private final boolean inherit;

        private PolicyConfig(Builder builder) {
            this.policyStatements = builder.policyStatements;
            this.inherit = builder.inherit;
        }

        public static Builder builder() {
            return new Builder();
        }

        public List<String> policyStatements() {
            return Collections.unmodifiableList(this.policyStatements);
        }

        public boolean shouldInherit() {
            return this.inherit;
        }

        public static final class Builder
        implements io.helidon.common.Builder<Builder, PolicyConfig> {
            private final List<String> policyStatements = new LinkedList<String>();
            private boolean inherit = true;

            private Builder() {
            }

            public Builder statement(String policyStatement) {
                this.policyStatements.clear();
                this.policyStatements.add(policyStatement);
                return this;
            }

            public Builder inherit(boolean inherit) {
                this.inherit = inherit;
                return this;
            }

            public Builder config(Config config) {
                config.get("inherit").asBoolean().ifPresent(this::inherit);
                config.get("statement").asString().ifPresent(this::statement);
                return this;
            }

            Builder from(PolicyStatement annot) {
                return this.inherit(annot.inherit()).statement(annot.value());
            }

            Builder from(PolicyConfig config) {
                if (!config.inherit) {
                    this.policyStatements.clear();
                }
                this.inherit(config.inherit);
                this.policyStatements.addAll(config.policyStatements);
                return this;
            }

            public PolicyConfig build() {
                return new PolicyConfig(this);
            }
        }
    }
}

