/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.abac.role;

import io.helidon.common.Builder;
import io.helidon.common.Errors;
import io.helidon.common.config.Config;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Grant;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Role;
import io.helidon.security.SecurityLevel;
import io.helidon.security.Subject;
import io.helidon.security.SubjectType;
import io.helidon.security.providers.abac.AbacAnnotation;
import io.helidon.security.providers.abac.AbacValidatorConfig;
import io.helidon.security.providers.abac.spi.AbacValidator;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class RoleValidator
implements AbacValidator<RoleConfig> {
    private RoleValidator() {
    }

    public static RoleValidator create() {
        return new RoleValidator();
    }

    public Class<RoleConfig> configClass() {
        return RoleConfig.class;
    }

    public String configKey() {
        return "roles-allowed";
    }

    public RoleConfig fromConfig(Config config) {
        return RoleConfig.create(config);
    }

    public RoleConfig fromAnnotations(EndpointConfig endpointConfig) {
        RoleConfig.Builder builder = RoleConfig.builder();
        for (SecurityLevel securityLevel : endpointConfig.securityLevels()) {
            for (EndpointConfig.AnnotationScope scope : EndpointConfig.AnnotationScope.values()) {
                ArrayList annotations = new ArrayList();
                for (Class<? extends Annotation> annotation : this.supportedAnnotations()) {
                    annotations.addAll(securityLevel.filterAnnotations(annotation, scope));
                }
                ArrayList<String> roles = new ArrayList<String>();
                ArrayList<String> serviceRoles = new ArrayList<String>();
                for (Annotation annotation : annotations) {
                    if (annotation instanceof RolesAllowed) {
                        roles.addAll(Arrays.asList(((RolesAllowed)annotation).value()));
                        builder.permitAll(false);
                        builder.denyAll(false);
                        continue;
                    }
                    if (annotation instanceof Roles) {
                        Roles r = (Roles)annotation;
                        if (r.subjectType() == SubjectType.USER) {
                            roles.addAll(Arrays.asList(r.value()));
                        } else {
                            serviceRoles.addAll(Arrays.asList(r.value()));
                        }
                        builder.permitAll(false);
                        builder.denyAll(false);
                        continue;
                    }
                    if (annotation instanceof RolesContainer) {
                        RolesContainer container = (RolesContainer)annotation;
                        for (Roles role : container.value()) {
                            if (role.subjectType() == SubjectType.USER) {
                                roles.addAll(Arrays.asList(role.value()));
                                continue;
                            }
                            serviceRoles.addAll(Arrays.asList(role.value()));
                        }
                        if (container.value().length == 0) continue;
                        builder.permitAll(false);
                        builder.denyAll(false);
                        continue;
                    }
                    if (annotation instanceof PermitAll) {
                        builder.permitAll(true);
                        builder.denyAll(false);
                        continue;
                    }
                    if (!(annotation instanceof DenyAll)) continue;
                    builder.permitAll(false);
                    builder.denyAll(true);
                }
                if (!roles.isEmpty()) {
                    builder.clearRoles().addRoles(roles);
                }
                if (serviceRoles.isEmpty()) continue;
                builder.clearServiceRoles().addServiceRoles(serviceRoles);
            }
        }
        return builder.build();
    }

    public void validate(RoleConfig config, Errors.Collector collector, ProviderRequest request) {
        if (config.denyAll()) {
            collector.fatal((Object)this, "Access denied by DenyAll.");
            return;
        }
        if (config.permitAll()) {
            return;
        }
        this.validate(config.userRolesAllowed(), collector, request.subject(), SubjectType.USER);
        this.validate(config.serviceRolesAllowed(), collector, request.service(), SubjectType.SERVICE);
    }

    private void validate(Set<String> rolesAllowed, Errors.Collector collector, Optional<Subject> subject, SubjectType type) {
        if (rolesAllowed.isEmpty()) {
            return;
        }
        Set roleGrants = subject.map(sub -> sub.grants(Role.class)).orElse(List.of()).stream().map(Grant::getName).collect(Collectors.toSet());
        boolean notFound = true;
        for (String role : rolesAllowed) {
            if (!roleGrants.contains(role)) continue;
            notFound = false;
            break;
        }
        if (notFound) {
            collector.fatal((Object)this, String.valueOf(type) + " is not in required roles: " + String.valueOf(rolesAllowed) + ", only in: " + String.valueOf(roleGrants));
        }
    }

    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        return List.of(RolesAllowed.class, Roles.class, RolesContainer.class, PermitAll.class, DenyAll.class);
    }

    public static final class RoleConfig
    implements AbacValidatorConfig {
        private final Set<String> userRolesAllowed = new HashSet<String>();
        private final Set<String> serviceRolesAllowed = new HashSet<String>();
        private boolean permitAll;
        private boolean denyAll;

        private RoleConfig(Builder builder) {
            this.permitAll = builder.permitAll;
            this.denyAll = builder.denyAll;
            this.userRolesAllowed.addAll(builder.userRolesAllowed);
            this.serviceRolesAllowed.addAll(builder.serviceRolesAllowed);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static RoleConfig create(Collection<String> rolesAllowed) {
            return RoleConfig.builder().addRoles(rolesAllowed).build();
        }

        public static RoleConfig create(String ... rolesAllowed) {
            return RoleConfig.builder().addRoles(Arrays.asList(rolesAllowed)).build();
        }

        public static RoleConfig create(Config config) {
            return RoleConfig.builder().config(config).build();
        }

        public Set<String> serviceRolesAllowed() {
            return Collections.unmodifiableSet(this.serviceRolesAllowed);
        }

        public Set<String> userRolesAllowed() {
            return Collections.unmodifiableSet(this.userRolesAllowed);
        }

        public boolean permitAll() {
            return this.permitAll;
        }

        public boolean denyAll() {
            return this.denyAll;
        }

        public static class Builder
        implements io.helidon.common.Builder<Builder, RoleConfig> {
            private final Set<String> userRolesAllowed = new LinkedHashSet<String>();
            private final Set<String> serviceRolesAllowed = new LinkedHashSet<String>();
            private boolean permitAll = false;
            private boolean denyAll = false;

            public RoleConfig build() {
                return new RoleConfig(this);
            }

            public Builder addRoles(Collection<String> rolesAllowed) {
                this.userRolesAllowed.addAll(rolesAllowed);
                return this;
            }

            public Builder clearRoles() {
                this.userRolesAllowed.clear();
                return this;
            }

            public Builder clearServiceRoles() {
                this.serviceRolesAllowed.clear();
                return this;
            }

            public Builder addRole(String role) {
                this.userRolesAllowed.add(role);
                return this;
            }

            public Builder addServiceRoles(Collection<String> rolesAllowed) {
                this.serviceRolesAllowed.addAll(rolesAllowed);
                return this;
            }

            private Builder addServiceRole(String role) {
                this.serviceRolesAllowed.add(role);
                return this;
            }

            private Builder permitAll(boolean permitAll) {
                this.permitAll = permitAll;
                return this;
            }

            private Builder denyAll(boolean denyAll) {
                this.denyAll = denyAll;
                return this;
            }

            public Builder config(Config config) {
                config.get("user").asList(String.class).ifPresent(this::addRoles);
                config.get("service").asList(String.class).ifPresent(this::addServiceRoles);
                config.get("permit-all").asBoolean().ifPresent(this::permitAll);
                config.get("deny-all").asBoolean().ifPresent(this::denyAll);
                return this;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    @Inherited
    @Repeatable(value=RolesContainer.class)
    @AbacAnnotation
    public static @interface Roles {
        public String[] value();

        public SubjectType subjectType() default SubjectType.USER;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    @Inherited
    @AbacAnnotation
    public static @interface RolesContainer {
        public Roles[] value();
    }
}

