/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.abac.scope;

import io.helidon.common.Errors;
import io.helidon.config.Config;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Grant;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityLevel;
import io.helidon.security.providers.abac.AbacAnnotation;
import io.helidon.security.providers.abac.AbacValidatorConfig;
import io.helidon.security.providers.abac.spi.AbacValidator;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ScopeValidator
implements AbacValidator<ScopesConfig> {
    public static final String SCOPE_GRANT_TYPE = "scope";
    private final boolean useOrOperator;

    private ScopeValidator(Builder builder) {
        this.useOrOperator = builder.useOrOperator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ScopeValidator create() {
        return ScopeValidator.builder().build();
    }

    public static ScopeValidator create(Config config) {
        return ScopeValidator.builder().config(config).build();
    }

    public Class<ScopesConfig> configClass() {
        return ScopesConfig.class;
    }

    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        return Set.of(Scope.class, Scopes.class);
    }

    public String configKey() {
        return "scopes";
    }

    public ScopesConfig fromConfig(Config config) {
        return ScopesConfig.create(config);
    }

    public ScopesConfig fromAnnotations(EndpointConfig endpointConfig) {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        for (SecurityLevel securityLevel : endpointConfig.securityLevels()) {
            for (EndpointConfig.AnnotationScope scope : EndpointConfig.AnnotationScope.values()) {
                ArrayList annotations = new ArrayList();
                for (Class<? extends Annotation> annotation : this.supportedAnnotations()) {
                    annotations.addAll(securityLevel.filterAnnotations(annotation, scope));
                }
                for (Annotation annot : annotations) {
                    if (annot instanceof Scopes) {
                        scopes.addAll(Arrays.asList(((Scopes)annot).value()));
                        continue;
                    }
                    if (!(annot instanceof Scope)) continue;
                    scopes.add((Scope)annot);
                }
            }
        }
        return ScopesConfig.create(scopes);
    }

    public void validate(ScopesConfig config, Errors.Collector collector, ProviderRequest request) {
        request.subject().ifPresentOrElse(subject -> {
            LinkedHashSet<String> requiredScopes = new LinkedHashSet<String>(config.requiredScopes());
            int origRequired = requiredScopes.size();
            if (origRequired == 0) {
                collector.hint((Object)this, "There are no required scopes for current request.");
                return;
            }
            List userScopes = subject.grantsByType(SCOPE_GRANT_TYPE);
            userScopes.stream().map(Grant::getName).forEach(requiredScopes::remove);
            int remainingRequired = requiredScopes.size();
            if (remainingRequired == origRequired) {
                collector.fatal((Object)this, "Access requires scopes: " + config.requiredScopes() + ", yet the user is in neither of them: " + userScopes);
                return;
            }
            if (remainingRequired == 0) {
                return;
            }
            if (this.useOrOperator) {
                return;
            }
            collector.fatal((Object)this, "User is not in all required scopes: " + config.requiredScopes() + ", user's scopes: " + userScopes);
        }, () -> {
            List<String> requiredScopes = config.requiredScopes();
            if (!requiredScopes.isEmpty()) {
                collector.fatal((Object)this, "User not logged int. Required scopes: " + requiredScopes);
            }
        });
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, ScopeValidator> {
        private boolean useOrOperator = false;

        private Builder() {
        }

        public ScopeValidator build() {
            return new ScopeValidator(this);
        }

        public Builder useOrOperator(boolean useOrOperator) {
            this.useOrOperator = useOrOperator;
            return this;
        }

        public Builder config(Config config) {
            config.get("operator").asString().map("OR"::equals).ifPresent(this::useOrOperator);
            return this;
        }
    }

    public static final class ScopesConfig
    implements AbacValidatorConfig {
        private final List<String> requiredScopes;

        private ScopesConfig(List<String> scopes) {
            this.requiredScopes = scopes;
        }

        public static ScopesConfig create(String ... scopes) {
            return new ScopesConfig(List.of(scopes));
        }

        public static ScopesConfig create(List<Scope> scopes) {
            ArrayList<String> allScopes = new ArrayList<String>();
            for (Scope scope : scopes) {
                allScopes.add(scope.value());
            }
            return new ScopesConfig(allScopes);
        }

        public static ScopesConfig create(Config config) {
            return new ScopesConfig((List)config.asList(String.class).orElse(List.of()));
        }

        public List<String> requiredScopes() {
            return Collections.unmodifiableList(this.requiredScopes);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    @Inherited
    @AbacAnnotation
    @Repeatable(value=Scopes.class)
    public static @interface Scope {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    @Inherited
    public static @interface Scopes {
        public Scope[] value();
    }
}

