/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt.jwk;

import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.jwk.JwkPki;
import jakarta.json.JsonObject;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;

public class JwkEC
extends JwkPki {
    public static final String SECURITY_ALGORITHM = "EC";
    public static final String ALG_ES256 = "ES256";
    public static final String ALG_ES384 = "ES384";
    public static final String ALG_ES512 = "ES512";
    public static final String CURVE_P256 = "P-256";
    public static final String CURVE_P384 = "P-384";
    public static final String CURVE_P521 = "P-521";
    public static final String PARAM_CURVE = "crv";
    public static final String PARAM_X_COORDINATE = "x";
    public static final String PARAM_Y_COODRINATE = "y";
    public static final String PARAM_PRIVATE_KEY = "d";
    private static final Map<String, ECParameterSpec> CURVE_MAP = new HashMap<String, ECParameterSpec>();
    private static final Map<String, String> ALG_MAP = new HashMap<String, String>();

    private JwkEC(Builder builder) {
        super(builder, builder.privateKey, builder.publicKey, builder.defaultAlg);
    }

    public static Builder builder() {
        return (Builder)new Builder().keyType(SECURITY_ALGORITHM);
    }

    public static JwkEC create(JsonObject json) {
        return JwkEC.builder().fromJson(json).build();
    }

    @Override
    String signatureAlgorithm() {
        String jwkAlg = this.algorithm();
        String javaAlg = ALG_MAP.get(jwkAlg);
        if (null == javaAlg) {
            throw new JwtException("Unsupported algorithm for Elliptic curve: " + jwkAlg);
        }
        return javaAlg;
    }

    @Override
    public boolean doVerify(byte[] signedBytes, byte[] signatureToVerify) {
        return super.doVerify(signedBytes, signatureToVerify);
    }

    static {
        ALG_MAP.put(ALG_ES256, "SHA256withECDSAinP1363Format");
        ALG_MAP.put(ALG_ES384, "SHA384withECDSAinP1363Format");
        ALG_MAP.put(ALG_ES512, "SHA512withECDSAinP1363Format");
        ALG_MAP.put("none", "none");
        CURVE_MAP.put(CURVE_P256, new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger("115792089210356248762697446949407573530086143415290314195533631308867097853951")), new BigInteger("115792089210356248762697446949407573530086143415290314195533631308867097853948"), new BigInteger("41058363725152142129326129780047268409114441015993725554835256314039467401291")), new ECPoint(new BigInteger("48439561293906451759052585252797914202762949526041747995844080717082404635286"), new BigInteger("36134250956749795798585127919587881956611106672985015071877198253568414405109")), new BigInteger("115792089210356248762697446949407573529996955224135760342422259061068512044369"), 1));
        CURVE_MAP.put(CURVE_P384, new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319")), new BigInteger("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112316"), new BigInteger("27580193559959705877849011840389048093056905856361568521428707301988689241309860865136260764883745107765439761230575")), new ECPoint(new BigInteger("26247035095799689268623156744566981891852923491109213387815615900925518854738050089022388053975719786650872476732087"), new BigInteger("8325710961489029985546751289520108179287853048861315594709205902480503199884419224438643760392947333078086511627871")), new BigInteger("39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643"), 1));
        CURVE_MAP.put(CURVE_P521, new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151")), new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057148"), new BigInteger("1093849038073734274511112390766805569936207598951683748994586394495953116150735016013708737573759623248592132296706313309438452531591012912142327488478985984")), new ECPoint(new BigInteger("2661740802050217063228768716723360960729859168756973147706671368418802944996427808491545080627771902352094241225065558662157113545570916814161637315895999846"), new BigInteger("3757180025770020463545507224491183603594455134769762486694567779615544477440556316691234405012945539562144444537289428522585666729196580810124344277578376784")), new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449"), 1));
    }

    public static final class Builder
    extends JwkPki.Builder<Builder>
    implements io.helidon.common.Builder<Builder, JwkEC> {
        private PrivateKey privateKey;
        private PublicKey publicKey;
        private String defaultAlg = "ES256";

        private Builder() {
        }

        private static PublicKey toPublicKey(KeyFactory kf, ECPoint point, ECParameterSpec keySpec) {
            try {
                return kf.generatePublic(new ECPublicKeySpec(point, keySpec));
            }
            catch (InvalidKeySpecException e) {
                throw new JwtException("Failed to generate EC public key", e);
            }
        }

        private static PrivateKey toPrivateKey(KeyFactory kf, BigInteger privKeyValue, ECParameterSpec keySpec) {
            ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(privKeyValue, keySpec);
            try {
                return kf.generatePrivate(privateKeySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new JwtException("Failed to generate EC private key", e);
            }
        }

        public Builder privateKey(ECPrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder publicKey(ECPublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public Builder fromJson(JsonObject json) {
            super.fromJson(json);
            String curve = JwtUtil.asString(json, JwkEC.PARAM_CURVE, "EC curve");
            ECParameterSpec keySpec = CURVE_MAP.get(curve);
            if (null == keySpec) {
                throw new JwtException("Curve \"" + curve + "\" not supported for EC key type. Only one of: " + CURVE_MAP.keySet() + " is supported");
            }
            BigInteger x = JwtUtil.asBigInteger(json, JwkEC.PARAM_X_COORDINATE, "EC X Coordinate");
            BigInteger y = JwtUtil.asBigInteger(json, JwkEC.PARAM_Y_COODRINATE, "EC Y Coordinate");
            KeyFactory kf = JwtUtil.getKeyFactory(JwkEC.SECURITY_ALGORITHM);
            this.privateKey = JwtUtil.getBigInteger(json, JwkEC.PARAM_PRIVATE_KEY, "EC Private Key").map(privKeyValue -> Builder.toPrivateKey(kf, privKeyValue, keySpec)).orElse(null);
            ECPoint point = new ECPoint(x, y);
            this.publicKey = Builder.toPublicKey(kf, point, keySpec);
            switch (curve) {
                case "P-256": {
                    this.defaultAlg = JwkEC.ALG_ES256;
                    break;
                }
                case "P-384": {
                    this.defaultAlg = JwkEC.ALG_ES384;
                    break;
                }
                case "P-521": {
                    this.defaultAlg = JwkEC.ALG_ES512;
                    break;
                }
                default: {
                    this.defaultAlg = JwkEC.ALG_ES256;
                }
            }
            return this;
        }

        public JwkEC build() {
            return new JwkEC(this);
        }
    }
}

