/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.JwtScope;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

final class CriticalValidator
implements ClaimValidator {
    private static final Set<String> INVALID_CRIT_HEADERS;

    CriticalValidator() {
    }

    @Override
    public JwtScope jwtScope() {
        return JwtScope.HEADER;
    }

    @Override
    public Set<String> claims() {
        return Set.of("crit");
    }

    @Override
    public void validate(Jwt jwt, Errors.Collector collector, List<ClaimValidator> validators) {
        Optional<List<String>> maybeCritical = jwt.headers().critical();
        if (maybeCritical.isPresent()) {
            List<String> critical = maybeCritical.get();
            if (critical.isEmpty()) {
                collector.fatal((Object)jwt, "JWT critical header must not be empty");
                return;
            }
            this.checkAllCriticalAvailable(jwt, critical, collector);
            if (collector.hasFatal()) {
                return;
            }
            this.checkDuplicity(jwt, critical, collector);
            if (collector.hasFatal()) {
                return;
            }
            this.checkInvalidHeaders(jwt, critical, collector);
            if (collector.hasFatal()) {
                return;
            }
            this.checkNotSupportedHeaders(jwt, critical, collector, validators);
        }
    }

    private void checkAllCriticalAvailable(Jwt jwt, List<String> critical, Errors.Collector collector) {
        Set<String> headerClaims = jwt.headers().headerClaims().keySet();
        boolean containsAllCritical = headerClaims.containsAll(critical);
        if (!containsAllCritical) {
            collector.fatal((Object)jwt, "JWT must contain " + String.valueOf(critical) + ", yet it contains: " + String.valueOf(headerClaims));
        }
    }

    private void checkNotSupportedHeaders(Jwt jwt, List<String> critical, Errors.Collector collector, List<ClaimValidator> validators) {
        Set supportedHeaderClaims = validators.stream().filter(claimValidator -> claimValidator.jwtScope() == JwtScope.HEADER).map(ClaimValidator::claims).flatMap(Collection::stream).collect(Collectors.toSet());
        boolean containUnsupported = supportedHeaderClaims.containsAll(critical);
        if (!containUnsupported) {
            collector.fatal((Object)jwt, "JWT is required to process " + String.valueOf(critical) + ", yet it process only " + String.valueOf(supportedHeaderClaims));
        }
    }

    private void checkDuplicity(Jwt jwt, List<String> critical, Errors.Collector collector) {
        HashSet<String> copy = new HashSet<String>(critical);
        if (copy.size() != critical.size()) {
            collector.fatal((Object)jwt, "JWT critical header contains duplicated values: " + String.valueOf(critical));
        }
    }

    private void checkInvalidHeaders(Jwt jwt, List<String> critical, Errors.Collector collector) {
        for (String header : critical) {
            if (!INVALID_CRIT_HEADERS.contains(header)) continue;
            collector.fatal((Object)jwt, "Required critical header value '" + header + "' is invalid. This required header is defined among JWA, JWE or JWS headers.");
        }
    }

    static {
        HashSet<String> names = new HashSet<String>();
        names.add("alg");
        names.add("enc");
        names.add("typ");
        names.add("cty");
        names.add("kid");
        names.add("jku");
        names.add("jwk");
        names.add("x5u");
        names.add("x5c");
        names.add("x5t");
        names.add("x5t#S256");
        names.add("crit");
        names.add("zip");
        names.add("apu");
        names.add("apv");
        names.add("epk");
        INVALID_CRIT_HEADERS = Set.copyOf(names);
    }
}

