/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.JwtScope;
import io.helidon.security.jwt.OptionalValidator;
import jakarta.json.JsonString;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class FieldValidator
extends OptionalValidator {
    private final Function<Jwt, Optional<String>> fieldAccessor;
    private final String name;
    private final String expectedValue;

    private FieldValidator(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.fieldAccessor = builder.fieldAccessor;
        this.expectedValue = builder.expectedValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void validate(Jwt token, Errors.Collector collector, List<ClaimValidator> validators) {
        super.validate(this.name, this.fieldAccessor.apply(token), collector).ifPresent(it -> {
            if (!this.expectedValue.equals(it)) {
                collector.fatal((Object)token, "Expected value of field \"" + this.name + "\" was \"" + this.expectedValue + "\", but actual value is: \"" + it + "\"");
            }
        });
    }

    public static final class Builder
    extends OptionalValidator.BaseBuilder<Builder, FieldValidator> {
        private String claimKey;
        private String name;
        private String expectedValue;
        private Function<Jwt, Optional<String>> fieldAccessor;

        private Builder() {
        }

        public Builder claimKey(String claimKey) {
            this.clearClaims();
            this.addClaim(claimKey);
            this.claimKey = claimKey;
            return this;
        }

        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public Builder expectedValue(String expectedValue) {
            this.expectedValue = Objects.requireNonNull(expectedValue);
            return this;
        }

        public Builder fieldAccessor(Function<Jwt, Optional<String>> fieldAccessor) {
            this.fieldAccessor = fieldAccessor;
            return this;
        }

        @Override
        public Builder scope(JwtScope scope) {
            return (Builder)super.scope(scope);
        }

        public FieldValidator build() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Missing supported field name");
            }
            if (this.expectedValue == null) {
                collector.fatal(this.getClass(), "Field accessor or claim key name has to be set.");
            }
            if (this.fieldAccessor == null) {
                if (this.claimKey == null) {
                    collector.fatal(this.getClass(), "Field accessor or claim key name has to be set.");
                }
                this.fieldAccessor = this.scope() == JwtScope.PAYLOAD ? jwt -> jwt.payloadClaim(this.claimKey).map(it -> ((JsonString)it).getString()) : jwt -> jwt.headerClaim(this.claimKey).map(it -> ((JsonString)it).getString());
            }
            collector.collect().checkValid();
            return new FieldValidator(this);
        }
    }
}

