/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.spi.OutboundSecurityProvider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class CompositeOutboundProvider
implements OutboundSecurityProvider {
    private final List<OutboundSecurityProvider> providers = new LinkedList<OutboundSecurityProvider>();

    CompositeOutboundProvider(List<OutboundSecurityProvider> providers) {
        this.providers.addAll(providers);
    }

    @Override
    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return this.providers.stream().anyMatch(provider -> provider.isOutboundSupported(providerRequest, outboundEnv, outboundConfig));
    }

    @Override
    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        this.providers.forEach(provider -> result.addAll(provider.supportedAnnotations()));
        return result;
    }

    @Override
    public CompletionStage<OutboundSecurityResponse> outboundSecurity(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        CompletionStage<OutboundCall> previous = CompletableFuture.completedFuture(new OutboundCall(OutboundSecurityResponse.abstain(), providerRequest, outboundEnv, outboundConfig));
        for (OutboundSecurityProvider provider : this.providers) {
            previous = previous.thenCompose(call -> {
                if (((OutboundCall)call).response.status() == SecurityResponse.SecurityStatus.ABSTAIN) {
                    if (provider.isOutboundSupported(((OutboundCall)call).inboundContext, ((OutboundCall)call).outboundEnv, ((OutboundCall)call).outboundConfig)) {
                        return provider.outboundSecurity(((OutboundCall)call).inboundContext, ((OutboundCall)call).outboundEnv, ((OutboundCall)call).outboundConfig).thenApply(response -> {
                            SecurityEnvironment nextEnv = this.updateRequestHeaders(((OutboundCall)call).outboundEnv, (OutboundSecurityResponse)response);
                            return new OutboundCall((OutboundSecurityResponse)response, ((OutboundCall)call).inboundContext, nextEnv, ((OutboundCall)call).outboundConfig);
                        });
                    }
                    return CompletableFuture.completedFuture(call);
                }
                if (((OutboundCall)call).response.status().isSuccess()) {
                    return provider.outboundSecurity(((OutboundCall)call).inboundContext, ((OutboundCall)call).outboundEnv, ((OutboundCall)call).outboundConfig).thenApply(thisResponse -> {
                        OutboundSecurityResponse prevResponse = ((OutboundCall)call).response;
                        OutboundSecurityResponse.Builder builder = OutboundSecurityResponse.builder();
                        prevResponse.requestHeaders().forEach(builder::requestHeader);
                        prevResponse.responseHeaders().forEach(builder::responseHeader);
                        thisResponse.requestHeaders().forEach(builder::requestHeader);
                        thisResponse.responseHeaders().forEach(builder::responseHeader);
                        SecurityEnvironment nextEnv = this.updateRequestHeaders(((OutboundCall)call).outboundEnv, (OutboundSecurityResponse)thisResponse);
                        builder.status(thisResponse.status());
                        return new OutboundCall(builder.build(), ((OutboundCall)call).inboundContext, nextEnv, ((OutboundCall)call).outboundConfig);
                    });
                }
                return CompletableFuture.completedFuture(call);
            });
        }
        return previous.thenApply(outboundCall -> ((OutboundCall)outboundCall).response);
    }

    private SecurityEnvironment updateRequestHeaders(SecurityEnvironment env, OutboundSecurityResponse response) {
        SecurityEnvironment.Builder builder = env.derive();
        response.requestHeaders().forEach(builder::header);
        return builder.build();
    }

    private static final class OutboundCall {
        private final ProviderRequest inboundContext;
        private final SecurityEnvironment outboundEnv;
        private final EndpointConfig outboundConfig;
        private final OutboundSecurityResponse response;

        private OutboundCall(OutboundSecurityResponse response, ProviderRequest inboundContext, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
            this.response = response;
            this.inboundContext = inboundContext;
            this.outboundEnv = outboundEnv;
            this.outboundConfig = outboundConfig;
        }
    }
}

