/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.Entity;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityRequest;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class SecurityRequestBuilder<T extends SecurityRequestBuilder<T>> {
    private final T myInstance;
    private final SecurityContext context;
    private final Map<String, Supplier<Object>> resources = new HashMap<String, Supplier<Object>>();
    private String providerName;
    private boolean isOptional;
    private Entity responseEntity;
    private Entity requestEntity;
    private Span tracingSpan;
    private SpanContext tracingSpanContext;

    SecurityRequestBuilder(SecurityContext context) {
        this.myInstance = this;
        this.context = context;
    }

    public T object(Object resource) {
        this.resources.put("object", () -> resource);
        return this.myInstance;
    }

    public T object(Supplier<Object> resource) {
        this.resources.put("object", resource);
        return this.myInstance;
    }

    public T object(String key, Object object) {
        this.resources.put(key, () -> object);
        return this.myInstance;
    }

    public T object(String key, Supplier<Object> object) {
        this.resources.put(key, object);
        return this.myInstance;
    }

    @Deprecated
    public T tracingSpan(Span span) {
        this.tracingSpan = span;
        return this.myInstance;
    }

    public T tracingSpan(SpanContext spanContext) {
        this.tracingSpanContext = spanContext;
        return this.myInstance;
    }

    public T explicitProvider(String providerName) {
        this.providerName = providerName;
        return this.myInstance;
    }

    public T optional(boolean optional) {
        this.isOptional = optional;
        return this.myInstance;
    }

    public T requestMessage(Entity entity) {
        this.requestEntity = entity;
        return this.myInstance;
    }

    public T responseMessage(Entity entity) {
        this.responseEntity = entity;
        return this.myInstance;
    }

    public SecurityRequest buildRequest() {
        return new SecurityRequestImpl(this);
    }

    String providerName() {
        return this.providerName;
    }

    private final class SecurityRequestImpl
    implements SecurityRequest {
        private final String providerName;
        private final boolean isOptional;
        private final Entity responseEntity;
        private final Entity requestEntity;
        private final Span tracingSpan;
        private final Optional<SpanContext> tracingSpanContext;
        private final Map<String, Supplier<Object>> resources = new HashMap<String, Supplier<Object>>();

        private SecurityRequestImpl(SecurityRequestBuilder<?> builder) {
            this.providerName = ((SecurityRequestBuilder)builder).providerName;
            this.isOptional = ((SecurityRequestBuilder)builder).isOptional;
            this.responseEntity = ((SecurityRequestBuilder)builder).responseEntity;
            this.requestEntity = ((SecurityRequestBuilder)builder).requestEntity;
            this.tracingSpan = ((SecurityRequestBuilder)builder).tracingSpan;
            this.tracingSpanContext = Optional.ofNullable(((SecurityRequestBuilder)builder).tracingSpanContext);
            this.resources.putAll(((SecurityRequestBuilder)builder).resources);
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }

        @Override
        public Optional<Entity> requestEntity() {
            return Optional.ofNullable(this.requestEntity);
        }

        @Override
        public Optional<Entity> responseEntity() {
            return Optional.ofNullable(this.responseEntity);
        }

        @Override
        public Span tracingSpan() {
            return this.tracingSpan;
        }

        @Override
        public Optional<SpanContext> tracingSpanContext() {
            return this.tracingSpanContext;
        }

        @Override
        public Map<String, Supplier<Object>> resources() {
            return Collections.unmodifiableMap(this.resources);
        }

        public String toString() {
            return "SecurityRequestImpl{providerName='" + this.providerName + '\'' + ", isOptional=" + this.isOptional + ", responseEntity=" + this.responseEntity + ", requestEntity=" + this.requestEntity + ", tracingSpan=" + this.tracingSpan + '}';
        }
    }
}

