/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import java.util.List;
import java.util.Optional;

public interface AuditEvent {
    public static final String SECURITY_TYPE_PREFIX = "security";
    public static final String AUTHN_TYPE_PREFIX = "authn";
    public static final String AUTHZ_TYPE_PREFIX = "authz";
    public static final String OUTBOUND_TYPE_PREFIX = "outbound";
    public static final String AUDIT_TYPE_PREFIX = "audit";

    public String eventType();

    public Optional<Throwable> throwable();

    public List<AuditParam> params();

    public String messageFormat();

    public AuditSeverity severity();

    public static final class AuditParam {
        private final String name;
        private final Object parameter;
        private final boolean sensitive;

        private AuditParam(String name, Object parameter, boolean sensitive) {
            this.name = name;
            this.parameter = parameter;
            this.sensitive = sensitive;
        }

        public static AuditParam plain(String name, Object parameter) {
            return new AuditParam(name, parameter, false);
        }

        public static AuditParam sensitive(String name, Object parameter) {
            return new AuditParam(name, parameter, true);
        }

        public String name() {
            return this.name;
        }

        public Optional<Object> value() {
            return Optional.ofNullable(this.parameter);
        }

        public boolean isSensitive() {
            return this.sensitive;
        }

        public String toString() {
            return "AuditParam{name='" + this.name + "', parameter=" + String.valueOf(this.sensitive ? "<sensitive>" : this.parameter) + ", sensitive=" + this.sensitive + "}";
        }
    }

    public static enum AuditSeverity {
        INFO,
        SUCCESS,
        WARN,
        ERROR,
        FAILURE,
        AUDIT_FAILURE;

    }
}

