/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.AuditEvent;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Security;
import io.helidon.security.SecurityClient;
import io.helidon.security.SecurityContextImpl;
import io.helidon.security.SecurityException;
import io.helidon.security.SecurityRequest;
import io.helidon.security.internal.SecurityAuditEvent;
import io.helidon.security.spi.AuthorizationProvider;

final class AuthorizationClientImpl
implements SecurityClient<AuthorizationResponse> {
    private final Security security;
    private final SecurityContextImpl context;
    private final SecurityRequest request;
    private final String providerName;
    private final ProviderRequest providerRequest;

    AuthorizationClientImpl(Security security, SecurityContextImpl context, SecurityRequest request, String providerName) {
        this.security = security;
        this.context = context;
        this.request = request;
        this.providerName = providerName;
        this.providerRequest = new ProviderRequest(context, request.resources());
    }

    @Override
    public AuthorizationResponse submit() {
        return this.security.resolveAtzProvider(this.providerName).map(this::authorize).orElse(AuthorizationResponse.permit());
    }

    private AuthorizationResponse authorize(AuthorizationProvider providerInstance) {
        AuthorizationResponse response = providerInstance.authorize(this.providerRequest);
        try {
            if (response.status().isSuccess()) {
                this.context.audit(SecurityAuditEvent.success("authz.authorize", "Path %s. Provider %s. Subject %s").addParam(AuditEvent.AuditParam.plain("path", this.providerRequest.env().path())).addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("subject", this.context.user())));
            } else {
                this.context.audit(SecurityAuditEvent.failure("authz.authorize", "Path %s. Provider %s, Description %s, Request %s. Subject %s").addParam(AuditEvent.AuditParam.plain("path", this.providerRequest.env().path())).addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("request", this)).addParam(AuditEvent.AuditParam.plain("subject", this.context.user())).addParam(AuditEvent.AuditParam.plain("message", response.description().orElse(null))).addParam(AuditEvent.AuditParam.plain("exception", response.throwable().orElse(null))));
            }
            return response;
        }
        catch (Exception e) {
            this.context.audit(SecurityAuditEvent.error("authz.authorize", "Path %s. Provider %s, Description %s, Request %s. Subject %s. %s: %s").addParam(AuditEvent.AuditParam.plain("path", this.providerRequest.env().path())).addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("description", "Audit failure")).addParam(AuditEvent.AuditParam.plain("request", this)).addParam(AuditEvent.AuditParam.plain("subject", this.context.user())).addParam(AuditEvent.AuditParam.plain("message", e.getMessage())).addParam(AuditEvent.AuditParam.plain("exception", e)));
            throw new SecurityException(e);
        }
    }
}

