/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey.client;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.HashParameters;
import io.helidon.common.http.Parameters;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityClientBuilder;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.integration.common.OutboundTracing;
import io.helidon.security.integration.common.SecurityTracing;
import io.opentracing.SpanContext;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;

@ConstrainedTo(value=RuntimeType.CLIENT)
@Priority(value=1000)
public class ClientSecurityFilter
implements ClientRequestFilter {
    private static final Logger LOGGER = Logger.getLogger(ClientSecurityFilter.class.getName());
    private static final AtomicLong CONTEXT_COUNTER = new AtomicLong();

    public void filter(ClientRequestContext requestContext) {
        try {
            this.doFilter(requestContext);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to process client filter.", e);
            throw e;
        }
    }

    private void doFilter(ClientRequestContext requestContext) {
        Optional<SecurityContext> securityContext = this.findContext(requestContext);
        if (securityContext.isPresent()) {
            this.outboundSecurity(requestContext, securityContext.get());
        } else {
            LOGGER.finest("Security context not available, using empty one. You can define it using property \"io.helidon.security.jersey.SecureClient.context\" on request");
            Context context = Contexts.context().orElseGet(() -> Context.builder().id("security-" + CONTEXT_COUNTER.incrementAndGet()).build());
            Optional<SecurityContext> newSecurityContext = context.get(Security.class).map(it -> it.createContext(context.id()));
            if (newSecurityContext.isPresent()) {
                Contexts.runInContext((Context)context, () -> this.outboundSecurity(requestContext, (SecurityContext)newSecurityContext.get()));
            } else {
                LOGGER.finest("Security is not available in global or current context, cannot propagate identity.");
            }
        }
    }

    private void outboundSecurity(ClientRequestContext requestContext, SecurityContext securityContext) {
        OutboundTracing tracing = SecurityTracing.get().outboundTracing();
        Optional<String> explicityProvider = ClientSecurityFilter.property(requestContext, String.class, "io.helidon.security.jersey.SecureClient.explicitProvider");
        try {
            SecurityEnvironment.Builder outboundEnv = securityContext.env().derive().clearHeaders().clearQueryParams();
            outboundEnv.method(requestContext.getMethod()).path(requestContext.getUri().getPath()).targetUri(requestContext.getUri()).headers((Map)requestContext.getStringHeaders()).queryParams(this.queryParameters(requestContext.getUri().getRawQuery()));
            EndpointConfig.Builder outboundEp = securityContext.endpointConfig().derive();
            for (String name : requestContext.getConfiguration().getPropertyNames()) {
                outboundEp.addAtribute(name, requestContext.getConfiguration().getProperty(name));
            }
            for (String name : requestContext.getPropertyNames()) {
                outboundEp.addAtribute(name, requestContext.getProperty(name));
            }
            OutboundSecurityClientBuilder clientBuilder = ((OutboundSecurityClientBuilder)securityContext.outboundClientBuilder().outboundEnvironment((Supplier)outboundEnv).tracingSpan((SpanContext)tracing.findParent().orElse(null))).outboundEndpointConfig((Supplier)outboundEp);
            explicityProvider.ifPresent(arg_0 -> ((OutboundSecurityClientBuilder)clientBuilder).explicitProvider(arg_0));
            OutboundSecurityResponse providerResponse = clientBuilder.buildAndGet();
            SecurityResponse.SecurityStatus status = providerResponse.status();
            tracing.logStatus(status);
            switch (status) {
                case FAILURE: 
                case FAILURE_FINISH: {
                    providerResponse.throwable().ifPresentOrElse(x$0 -> tracing.error(x$0), () -> tracing.error(providerResponse.description().orElse("Failed")));
                    break;
                }
            }
            Map newHeaders = providerResponse.requestHeaders();
            LOGGER.finest(() -> "Client filter header(s). SIZE: " + newHeaders.size());
            MultivaluedMap hdrs = requestContext.getHeaders();
            for (Map.Entry entry : newHeaders.entrySet()) {
                LOGGER.finest(() -> "    + Header: " + (String)entry.getKey() + ": " + entry.getValue());
                hdrs.remove(entry.getKey());
                for (String value : (List)entry.getValue()) {
                    hdrs.add((Object)((String)entry.getKey()), (Object)value);
                }
            }
            tracing.finish();
        }
        catch (Exception e) {
            tracing.error((Throwable)e);
            throw e;
        }
    }

    private Optional<SecurityContext> findContext(ClientRequestContext requestContext) {
        return ClientSecurityFilter.property(requestContext, SecurityContext.class, "io.helidon.security.jersey.SecureClient.context").or(() -> Contexts.context().flatMap(ctx -> ctx.get(SecurityContext.class)));
    }

    private static <T> Optional<T> property(ClientRequestContext requestContext, Class<T> clazz, String propertyName) {
        return Optional.ofNullable(requestContext.getProperty(propertyName)).filter(clazz::isInstance).or(() -> Optional.ofNullable(requestContext.getConfiguration().getProperty(propertyName)).filter(clazz::isInstance)).map(clazz::cast);
    }

    private Parameters queryParameters(String query) {
        String[] pairs;
        HashParameters queryParams = HashParameters.create();
        if (query == null) {
            return queryParams;
        }
        for (String pair : pairs = query.split("&")) {
            String[] keyValues = pair.split("=");
            if (keyValues.length == 1) {
                queryParams.add(this.decode(keyValues[0]), new String[]{""});
                continue;
            }
            queryParams.add(this.decode(keyValues[0]), new String[]{this.decode(keyValues[1])});
        }
        return queryParams;
    }

    private String decode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }
}

