/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.common.OptionalHelper;
import io.helidon.common.context.Contexts;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityClientBuilder;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.integration.common.OutboundTracing;
import io.helidon.security.integration.common.SecurityTracing;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
@ConstrainedTo(value=RuntimeType.CLIENT)
@Deprecated
public class ClientSecurityFilter
implements ClientRequestFilter {
    private static final Logger LOGGER = Logger.getLogger(ClientSecurityFilter.class.getName());

    public void filter(ClientRequestContext requestContext) {
        try {
            this.doFilter(requestContext);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to process client filter.", e);
            throw e;
        }
    }

    private void doFilter(ClientRequestContext requestContext) {
        OptionalHelper.from(this.findContext(requestContext)).or(() -> Contexts.context().flatMap(ctx -> ctx.get(SecurityContext.class))).ifPresentOrElse(securityContext -> this.outboundSecurity(requestContext, (SecurityContext)securityContext), () -> LOGGER.finest("Security not propagated, as security context is not available neither in context, nor as the property \"io.helidon.security.jersey.SecureClient.context\" on request"));
    }

    private void outboundSecurity(ClientRequestContext requestContext, SecurityContext securityContext) {
        OutboundTracing tracing = SecurityTracing.get().outboundTracing();
        String explicitProvider = (String)requestContext.getProperty("io.helidon.security.jersey.SecureClient.explicitProvider");
        try {
            SecurityEnvironment.Builder outboundEnv = securityContext.env().derive();
            outboundEnv.method(requestContext.getMethod()).path(requestContext.getUri().getPath()).targetUri(requestContext.getUri()).headers((Map)requestContext.getStringHeaders());
            EndpointConfig.Builder outboundEp = securityContext.endpointConfig().derive();
            for (String name : requestContext.getConfiguration().getPropertyNames()) {
                outboundEp.addAtribute(name, requestContext.getConfiguration().getProperty(name));
            }
            for (String name : requestContext.getPropertyNames()) {
                outboundEp.addAtribute(name, requestContext.getProperty(name));
            }
            OutboundSecurityClientBuilder clientBuilder = (OutboundSecurityClientBuilder)((OutboundSecurityClientBuilder)((OutboundSecurityClientBuilder)securityContext.outboundClientBuilder().outboundEnvironment((Supplier)outboundEnv).tracingSpan((SpanContext)tracing.findParent().orElse(null))).tracingSpan((Span)tracing.findParentSpan().orElse(null))).outboundEndpointConfig((Supplier)outboundEp).explicitProvider(explicitProvider);
            OutboundSecurityResponse providerResponse = clientBuilder.buildAndGet();
            SecurityResponse.SecurityStatus status = providerResponse.status();
            tracing.logStatus(status);
            switch (status) {
                case FAILURE: 
                case FAILURE_FINISH: {
                    OptionalHelper.from((Optional)providerResponse.throwable()).ifPresentOrElse(x$0 -> tracing.error(x$0), () -> tracing.error(providerResponse.description().orElse("Failed")));
                    break;
                }
            }
            Map newHeaders = providerResponse.requestHeaders();
            LOGGER.finest(() -> "Client filter header(s). SIZE: " + newHeaders.size());
            MultivaluedMap hdrs = requestContext.getHeaders();
            for (Map.Entry entry : newHeaders.entrySet()) {
                LOGGER.finest(() -> "    + Header: " + (String)entry.getKey() + ": " + entry.getValue());
                hdrs.remove(entry.getKey());
                for (String value : (List)entry.getValue()) {
                    hdrs.add((Object)((String)entry.getKey()), (Object)value);
                }
            }
            tracing.finish();
        }
        catch (Exception e) {
            tracing.error((Throwable)e);
            throw e;
        }
    }

    private Optional<SecurityContext> findContext(ClientRequestContext requestContext) {
        Object value = requestContext.getProperty("io.helidon.security.jersey.SecureClient.context");
        if (null == value) {
            value = requestContext.getConfiguration().getProperty("io.helidon.security.jersey.SecureClient.context");
        }
        return Optional.ofNullable((SecurityContext)value);
    }
}

