/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.config.Config;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.security.integration.jersey.FeatureConfig;
import io.helidon.security.integration.jersey.QueryParamHandler;
import io.helidon.security.integration.jersey.SecurityFilter;
import io.helidon.security.integration.jersey.SecurityPreMatchingFilter;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;

@ConstrainedTo(value=RuntimeType.SERVER)
public final class SecurityFeature
implements Feature {
    private final Security security;
    private final FeatureConfig featureConfig;

    public SecurityFeature() {
        this.security = null;
        this.featureConfig = null;
    }

    public SecurityFeature(Security security) {
        this.security = security;
        this.featureConfig = new FeatureConfig(SecurityFeature.builder(security).config(security.configFor("jersey")));
    }

    private SecurityFeature(Builder builder) {
        this.security = builder.security;
        this.featureConfig = new FeatureConfig(builder);
    }

    public static Builder builder(Security security) {
        return new Builder(security);
    }

    public boolean configure(FeatureContext context) {
        RuntimeType runtimeType = context.getConfiguration().getRuntimeType();
        if (runtimeType != RuntimeType.SERVER) {
            return false;
        }
        context.register(SecurityPreMatchingFilter.class);
        context.register(SecurityFilter.class);
        context.register((Object)new AbstractBinder(){

            protected void configure() {
                ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(SecurityContextRefFactory.class).to(SecurityContext.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class);
                ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<SecurityContext>>(){})).in(RequestScoped.class);
                this.bind(SecurityFeature.this.security).to(Security.class);
                this.bind(SecurityFeature.this.featureConfig).to(FeatureConfig.class);
            }
        });
        return true;
    }

    private static class SecurityContextRefFactory
    extends ReferencingFactory<SecurityContext> {
        @Inject
        SecurityContextRefFactory(Provider<Ref<SecurityContext>> referenceFactory) {
            super(referenceFactory);
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<SecurityFeature> {
        private final Security security;
        private final List<QueryParamHandler> queryParamHandlers = new LinkedList<QueryParamHandler>();
        private boolean authorizeAnnotatedOnly = false;
        private boolean authenticateAnnotatedOnly = true;
        private boolean debug = false;
        private boolean prematchingAuthorization = false;
        private boolean prematchingAuthentication = false;

        private Builder(Security security) {
            this.security = security;
        }

        public Builder authorizeAnnotatedOnly(boolean authzOnly) {
            this.authorizeAnnotatedOnly = authzOnly;
            return this;
        }

        public Builder authenticateAnnotatedOnly(boolean authnOnly) {
            this.authenticateAnnotatedOnly = authnOnly;
            return this;
        }

        public Builder addQueryParamHandler(QueryParamHandler handler) {
            this.queryParamHandlers.add(handler);
            return this;
        }

        public Builder addQueryParamHandlers(Iterable<QueryParamHandler> handlers) {
            handlers.forEach(this::addQueryParamHandler);
            return this;
        }

        public Builder usePrematchingAuthentication(boolean usePrematching) {
            this.prematchingAuthentication = usePrematching;
            return this;
        }

        public Builder usePrematchingAuthorization(boolean usePrematching) {
            this.prematchingAuthorization = usePrematching;
            return this;
        }

        public Builder debug() {
            this.debug = true;
            return this;
        }

        public Builder config(Config config) {
            config.get("prematching-authentication").asBoolean().ifPresent(this::usePrematchingAuthentication);
            config.get("prematching-authorization").asBoolean().ifPresent(this::usePrematchingAuthorization);
            Config myConfig = config.get("defaults");
            myConfig.get("authorize-annotated-only").asBoolean().ifPresent(this::authorizeAnnotatedOnly);
            myConfig.get("authenticate-annotated-only").asBoolean().ifPresent(this::authenticateAnnotatedOnly);
            myConfig.get("query-params").asList(QueryParamHandler.class).ifPresent(this::addQueryParamHandlers);
            myConfig.get("debug").asBoolean().filter(bool -> bool).ifPresent(bool -> this.debug());
            return this;
        }

        public SecurityFeature build() {
            return new SecurityFeature(this);
        }

        Security security() {
            return this.security;
        }

        List<QueryParamHandler> queryParamHandlers() {
            return this.queryParamHandlers;
        }

        boolean isAuthorizeAnnotatedOnly() {
            return this.authorizeAnnotatedOnly;
        }

        boolean isAuthenticateAnnotatedOnly() {
            return this.authenticateAnnotatedOnly;
        }

        boolean isDebug() {
            return this.debug;
        }

        boolean isPrematchingAuthorization() {
            return this.prematchingAuthorization;
        }

        boolean isPrematchingAuthentication() {
            return this.prematchingAuthentication;
        }
    }
}

