/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.reactive.Flow;
import io.helidon.config.Config;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Entity;
import io.helidon.security.Security;
import io.helidon.security.SecurityClientBuilder;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.SecurityTime;
import io.helidon.security.integration.common.AtnTracing;
import io.helidon.security.integration.common.AtzTracing;
import io.helidon.security.integration.common.SecurityTracing;
import io.helidon.security.integration.jersey.FeatureConfig;
import io.helidon.security.integration.jersey.InputStreamPublisher;
import io.helidon.security.integration.jersey.JerseySecurityContext;
import io.helidon.security.integration.jersey.SecurityDefinition;
import io.helidon.security.integration.jersey.SubscriberInputStream;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.server.ContainerRequest;

abstract class SecurityFilterCommon {
    static final String PROP_FILTER_CONTEXT = "io.helidon.security.jersey.FilterContext";
    @Context
    private Security security;
    @Context
    private FeatureConfig featureConfig;

    SecurityFilterCommon() {
    }

    SecurityFilterCommon(Security security, FeatureConfig featureConfig) {
        this.security = security;
        this.featureConfig = featureConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(ContainerRequestContext request, SecurityContext securityContext) {
        SecurityTracing tracing = SecurityTracing.get();
        tracing.securityContext(securityContext);
        FilterContext filterContext = this.initRequestFiltering(request);
        if (filterContext.isShouldFinish()) {
            tracing.finish();
            return;
        }
        URI requestUri = request.getUriInfo().getRequestUri();
        String query = requestUri.getQuery();
        String origRequest = null == query || query.isEmpty() ? requestUri.getPath() : requestUri.getPath() + "?" + query;
        HashMap<String, List<String>> allHeaders = new HashMap<String, List<String>>(filterContext.getHeaders());
        allHeaders.put("X_ORIG_URI_HEADER", CollectionsHelper.listOf((Object[])new String[]{origRequest}));
        SecurityEnvironment env = SecurityEnvironment.builder((SecurityTime)this.security.serverTime()).path(filterContext.getResourcePath()).targetUri(filterContext.getTargetUri()).method(filterContext.getMethod()).headers(allHeaders).addAttribute("resourceType", (Object)filterContext.getResourceName()).build();
        EndpointConfig ec = EndpointConfig.builder().securityLevels(filterContext.getMethodSecurity().getSecurityLevels()).build();
        try {
            securityContext.env(env);
            securityContext.endpointConfig(ec);
            request.setProperty(PROP_FILTER_CONTEXT, (Object)filterContext);
            request.setSecurityContext((javax.ws.rs.core.SecurityContext)new JerseySecurityContext(securityContext, filterContext.getMethodSecurity(), "https".equals(filterContext.getTargetUri().getScheme())));
            this.processSecurity(request, filterContext, tracing, securityContext);
        }
        finally {
            if (filterContext.isTraceSuccess()) {
                tracing.logProceed();
                tracing.finish();
            } else {
                tracing.logDeny();
                tracing.error("aborted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticate(FilterContext context, SecurityContext securityContext, AtnTracing atnTracing) {
        try {
            SecurityDefinition methodSecurity = context.getMethodSecurity();
            if (methodSecurity.requiresAuthentication()) {
                SecurityClientBuilder clientBuilder = (SecurityClientBuilder)((SecurityClientBuilder)((SecurityClientBuilder)((SecurityClientBuilder)((SecurityClientBuilder)securityContext.atnClientBuilder().optional(methodSecurity.authenticationOptional())).requestMessage(this.toRequestMessage(context))).responseMessage((Entity)context.getResponseMessage())).tracingSpan((SpanContext)atnTracing.findParent().orElse(null))).tracingSpan((Span)atnTracing.findParentSpan().orElse(null));
                clientBuilder.explicitProvider(methodSecurity.getAuthenticator());
                this.processAuthentication(context, (SecurityClientBuilder<AuthenticationResponse>)clientBuilder, methodSecurity, atnTracing);
            }
        }
        finally {
            if (context.isTraceSuccess()) {
                securityContext.user().ifPresent(arg_0 -> ((AtnTracing)atnTracing).logUser(arg_0));
                securityContext.service().ifPresent(arg_0 -> ((AtnTracing)atnTracing).logService(arg_0));
                atnTracing.finish();
            } else {
                Throwable ctxThrowable = context.getTraceThrowable();
                if (null == ctxThrowable) {
                    atnTracing.error(context.getTraceDescription());
                } else {
                    atnTracing.error(ctxThrowable);
                }
            }
        }
    }

    protected Entity toRequestMessage(FilterContext context) {
        switch (context.getMethod().toLowerCase()) {
            case "get": 
            case "options": 
            case "head": 
            case "delete": {
                return null;
            }
        }
        return filterFunction -> {
            InputStreamPublisher publisherFromJersey = new InputStreamPublisher(context.getJerseyRequest().getEntityStream(), 1024);
            SubscriberInputStream subscriberInputStream = new SubscriberInputStream();
            context.getJerseyRequest().setEntityStream((InputStream)subscriberInputStream);
            Flow.Publisher publisherToJersey = (Flow.Publisher)filterFunction.apply(publisherFromJersey);
            publisherToJersey.subscribe((Flow.Subscriber)subscriberInputStream);
        };
    }

    protected void processAuthentication(FilterContext context, SecurityClientBuilder<AuthenticationResponse> clientBuilder, SecurityDefinition methodSecurity, AtnTracing atnTracing) {
        AuthenticationResponse response = (AuthenticationResponse)clientBuilder.buildAndGet();
        SecurityResponse.SecurityStatus responseStatus = response.status();
        atnTracing.logStatus(responseStatus);
        switch (responseStatus) {
            case SUCCESS: {
                return;
            }
            case FAILURE_FINISH: {
                if (methodSecurity.authenticationOptional()) {
                    this.logger().finest("Authentication failed, but was optional, so assuming anonymous");
                } else {
                    context.setTraceSuccess(false);
                    context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                    context.setTraceThrowable(response.throwable().orElse(null));
                    context.setShouldFinish(true);
                    int status = response.statusCode().orElse(Response.Status.UNAUTHORIZED.getStatusCode());
                    this.abortRequest(context, (SecurityResponse)response, status, CollectionsHelper.mapOf());
                }
                return;
            }
            case SUCCESS_FINISH: {
                context.setShouldFinish(true);
                int status = response.statusCode().orElse(Response.Status.OK.getStatusCode());
                this.abortRequest(context, (SecurityResponse)response, status, CollectionsHelper.mapOf());
                return;
            }
            case ABSTAIN: {
                if (methodSecurity.authenticationOptional()) {
                    this.logger().finest("Authentication failed, but was optional, so assuming anonymous");
                } else {
                    context.setTraceSuccess(false);
                    context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                    context.setShouldFinish(true);
                    this.abortRequest(context, (SecurityResponse)response, Response.Status.UNAUTHORIZED.getStatusCode(), CollectionsHelper.mapOf());
                }
                return;
            }
            case FAILURE: {
                if (methodSecurity.authenticationOptional()) {
                    this.logger().finest("Authentication failed, but was optional, so assuming anonymous");
                } else {
                    context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                    context.setTraceThrowable(response.throwable().orElse(null));
                    context.setTraceSuccess(false);
                    this.abortRequest(context, (SecurityResponse)response, Response.Status.UNAUTHORIZED.getStatusCode(), CollectionsHelper.mapOf());
                    context.setShouldFinish(true);
                }
                return;
            }
        }
        context.setTraceSuccess(false);
        context.setTraceDescription(response.description().orElse("UNKNOWN_RESPONSE: " + responseStatus));
        context.setShouldFinish(true);
        SecurityException throwable = new SecurityException("Invalid SecurityStatus returned: " + responseStatus);
        context.setTraceThrowable(throwable);
        throw throwable;
    }

    protected abstract Logger logger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authorize(FilterContext context, SecurityContext securityContext, AtzTracing atzTracing) {
        if (context.getMethodSecurity().isAtzExplicit()) {
            context.setExplicitAtz(true);
            return;
        }
        try {
            if (context.getMethodSecurity().requiresAuthorization()) {
                SecurityClientBuilder clientBuilder = (SecurityClientBuilder)((SecurityClientBuilder)((SecurityClientBuilder)securityContext.atzClientBuilder().tracingSpan((Span)atzTracing.findParentSpan().orElse(null))).tracingSpan((SpanContext)atzTracing.findParent().orElse(null))).explicitProvider(context.getMethodSecurity().getAuthorizer());
                this.processAuthorization(context, (SecurityClientBuilder<AuthorizationResponse>)clientBuilder);
            }
        }
        finally {
            if (context.isTraceSuccess()) {
                atzTracing.finish();
            } else {
                Throwable throwable = context.getTraceThrowable();
                if (null == throwable) {
                    atzTracing.error(context.getTraceDescription());
                } else {
                    atzTracing.error(throwable);
                }
            }
        }
    }

    protected void processAuthorization(FilterContext context, SecurityClientBuilder<AuthorizationResponse> clientBuilder) {
        AuthorizationResponse response = (AuthorizationResponse)clientBuilder.buildAndGet();
        SecurityResponse.SecurityStatus responseStatus = response.status();
        switch (responseStatus) {
            case SUCCESS: {
                return;
            }
            case FAILURE_FINISH: {
                context.setTraceSuccess(false);
                context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                context.setTraceThrowable(response.throwable().orElse(null));
                context.setShouldFinish(true);
                int status = response.statusCode().orElse(Response.Status.FORBIDDEN.getStatusCode());
                this.abortRequest(context, (SecurityResponse)response, status, CollectionsHelper.mapOf());
                return;
            }
            case SUCCESS_FINISH: {
                context.setShouldFinish(true);
                int status = response.statusCode().orElse(Response.Status.OK.getStatusCode());
                this.abortRequest(context, (SecurityResponse)response, status, CollectionsHelper.mapOf());
                return;
            }
            case FAILURE: {
                context.setTraceSuccess(false);
                context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                context.setTraceThrowable(response.throwable().orElse(null));
                context.setShouldFinish(true);
                this.abortRequest(context, (SecurityResponse)response, response.statusCode().orElse(Response.Status.FORBIDDEN.getStatusCode()), CollectionsHelper.mapOf());
                return;
            }
            case ABSTAIN: {
                context.setTraceSuccess(false);
                context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                context.setShouldFinish(true);
                this.abortRequest(context, (SecurityResponse)response, response.statusCode().orElse(Response.Status.FORBIDDEN.getStatusCode()), CollectionsHelper.mapOf());
                return;
            }
        }
        context.setTraceSuccess(false);
        context.setTraceDescription(response.description().orElse("UNKNOWN_RESPONSE: " + responseStatus));
        context.setShouldFinish(true);
        SecurityException throwable = new SecurityException("Invalid SecurityStatus returned: " + responseStatus);
        context.setTraceThrowable(throwable);
        throw throwable;
    }

    protected void abortRequest(FilterContext context, SecurityResponse response, int defaultStatusCode, Map<String, List<String>> defaultHeaders) {
        int statusCode = response.statusCode().orElse(defaultStatusCode);
        Map responseHeaders = response.responseHeaders();
        Response.ResponseBuilder responseBuilder = Response.status((int)statusCode);
        if (responseHeaders.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : defaultHeaders.entrySet()) {
                responseBuilder.header(entry.getKey(), entry.getValue());
            }
        } else {
            this.updateHeaders(responseHeaders, responseBuilder);
        }
        if (this.featureConfig.isDebug()) {
            response.description().ifPresent(arg_0 -> ((Response.ResponseBuilder)responseBuilder).entity(arg_0));
        }
        context.getJerseyRequest().abortWith(responseBuilder.build());
    }

    protected void updateHeaders(Map<String, List<String>> responseHeaders, Response.ResponseBuilder responseBuilder) {
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            for (String value : entry.getValue()) {
                responseBuilder.header(entry.getKey(), (Object)value);
            }
        }
    }

    protected FilterContext configureContext(FilterContext context, ContainerRequestContext requestContext, UriInfo uriInfo) {
        context.setMethod(requestContext.getMethod());
        context.setHeaders((Map<String, List<String>>)requestContext.getHeaders());
        context.setTargetUri(requestContext.getUriInfo().getRequestUri());
        context.setResourcePath(context.getTargetUri().getPath());
        context.setJerseyRequest((ContainerRequest)requestContext);
        this.featureConfig().getQueryParamHandlers().forEach(handler -> handler.extract(uriInfo, context.getHeaders()));
        return context;
    }

    protected Security security() {
        return this.security;
    }

    protected FeatureConfig featureConfig() {
        return this.featureConfig;
    }

    protected abstract void processSecurity(ContainerRequestContext var1, FilterContext var2, SecurityTracing var3, SecurityContext var4);

    protected abstract FilterContext initRequestFiltering(ContainerRequestContext var1);

    Config config(String child) {
        return this.security.configFor(child);
    }

    protected static class JerseyResponseEntity
    implements Entity {
        private volatile Function<Flow.Publisher<ByteBuffer>, Flow.Publisher<ByteBuffer>> filterFunction;

        protected JerseyResponseEntity() {
        }

        public void filter(Function<Flow.Publisher<ByteBuffer>, Flow.Publisher<ByteBuffer>> filterFunction) {
            this.filterFunction = filterFunction;
        }

        protected Function<Flow.Publisher<ByteBuffer>, Flow.Publisher<ByteBuffer>> filterFunction() {
            return this.filterFunction;
        }
    }

    static class FilterContext {
        private final JerseyResponseEntity responseMessage = new JerseyResponseEntity();
        private String resourceName;
        private String resourcePath;
        private String method;
        private Map<String, List<String>> headers;
        private URI targetUri;
        private ContainerRequest jerseyRequest;
        private boolean shouldFinish;
        private SecurityDefinition methodSecurity;
        private boolean explicitAtz;
        private boolean traceSuccess = true;
        private String traceDescription;
        private Throwable traceThrowable;

        FilterContext() {
        }

        JerseyResponseEntity getResponseMessage() {
            return this.responseMessage;
        }

        String getResourceName() {
            return this.resourceName;
        }

        void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        String getResourcePath() {
            return this.resourcePath;
        }

        void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        String getMethod() {
            return this.method;
        }

        void setMethod(String method) {
            this.method = method;
        }

        Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        void setHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
        }

        URI getTargetUri() {
            return this.targetUri;
        }

        void setTargetUri(URI targetUri) {
            this.targetUri = targetUri;
        }

        ContainerRequest getJerseyRequest() {
            return this.jerseyRequest;
        }

        void setJerseyRequest(ContainerRequest jerseyRequest) {
            this.jerseyRequest = jerseyRequest;
        }

        boolean isShouldFinish() {
            return this.shouldFinish;
        }

        void setShouldFinish(boolean shouldFinish) {
            this.shouldFinish = shouldFinish;
        }

        SecurityDefinition getMethodSecurity() {
            return this.methodSecurity;
        }

        void setMethodSecurity(SecurityDefinition methodSecurity) {
            this.methodSecurity = methodSecurity;
        }

        boolean isExplicitAtz() {
            return this.explicitAtz;
        }

        void setExplicitAtz(boolean explicitAtz) {
            this.explicitAtz = explicitAtz;
        }

        boolean isTraceSuccess() {
            return this.traceSuccess;
        }

        void setTraceSuccess(boolean traceSuccess) {
            this.traceSuccess = traceSuccess;
        }

        String getTraceDescription() {
            return this.traceDescription;
        }

        void setTraceDescription(String traceDescription) {
            this.traceDescription = traceDescription;
        }

        Throwable getTraceThrowable() {
            return this.traceThrowable;
        }

        void setTraceThrowable(Throwable traceThrowable) {
            this.traceThrowable = traceThrowable;
        }

        void clearTrace() {
            this.setTraceSuccess(true);
            this.setTraceDescription(null);
            this.setTraceThrowable(null);
        }
    }
}

