/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.common.reactive.Flow;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

class SubscriberInputStream
extends InputStream
implements Flow.Subscriber<ByteBuffer> {
    private volatile Flow.Subscription subscription;
    private volatile CompletableFuture<ByteBuffer> processed = new CompletableFuture();
    private boolean closed = false;

    SubscriberInputStream() {
    }

    @Override
    public int read() throws IOException {
        try {
            ByteBuffer currentBuffer;
            while ((currentBuffer = this.processed.get()) != null) {
                if (currentBuffer.remaining() > 0) {
                    return currentBuffer.get();
                }
                if (this.reinitializeFuture()) {
                    this.subscription.request(1L);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onNext(ByteBuffer item) {
        if (item != null) {
            this.processed.complete(item);
        }
    }

    public synchronized void onError(Throwable throwable) {
        this.closed = true;
        if (!this.processed.completeExceptionally(throwable)) {
            CompletableFuture cf = new CompletableFuture();
            cf.completeExceptionally(throwable);
            this.processed = cf;
        }
    }

    public synchronized void onComplete() {
        this.closed = true;
        this.processed.complete(null);
    }

    private synchronized boolean reinitializeFuture() {
        boolean open;
        boolean bl = open = !this.closed;
        if (open) {
            this.processed = new CompletableFuture();
        }
        return open;
    }
}

