/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.common.reactive.Flow;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.Consumer;

class SubscriberOutputStream
implements Flow.Subscriber<ByteBuffer> {
    private final OutputStream outputStream;
    private final Consumer<Throwable> completionCallback;
    private volatile Flow.Subscription subscription;

    SubscriberOutputStream(OutputStream outputStream, Consumer<Throwable> completionCallback) {
        this.outputStream = outputStream;
        this.completionCallback = completionCallback;
    }

    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onNext(ByteBuffer dataBuffer) {
        try {
            if (dataBuffer.hasArray()) {
                this.outputStream.write(dataBuffer.array(), dataBuffer.arrayOffset() + dataBuffer.position(), dataBuffer.remaining());
            } else {
                byte[] data = new byte[dataBuffer.remaining()];
                this.outputStream.write(data);
            }
            this.subscription.request(1L);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void onError(Throwable throwable) {
    }

    public void onComplete() {
        try {
            this.outputStream.close();
            this.completionCallback.accept(null);
        }
        catch (IOException e) {
            this.completionCallback.accept(e);
        }
    }
}

