/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.security.Principal;
import io.helidon.security.SecurityContext;
import io.helidon.security.Subject;
import io.helidon.security.integration.jersey.SecurityDefinition;

class JerseySecurityContext
implements jakarta.ws.rs.core.SecurityContext {
    private final SecurityContext securityContext;
    private final SecurityDefinition methodSecurity;
    private final boolean isSecure;

    JerseySecurityContext(SecurityContext securityContext, SecurityDefinition methodSecurity, boolean isSecure) {
        this.securityContext = securityContext;
        this.methodSecurity = methodSecurity;
        this.isSecure = isSecure;
    }

    public Principal getUserPrincipal() {
        return this.securityContext.user().map(Subject::principal).orElse(SecurityContext.ANONYMOUS_PRINCIPAL);
    }

    public boolean isUserInRole(String role) {
        return this.securityContext.isUserInRole(role, this.methodSecurity.getAuthorizer());
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String getAuthenticationScheme() {
        return null;
    }

    SecurityDefinition methodSecurity() {
        return this.methodSecurity;
    }

    SecurityContext securityContext() {
        return this.securityContext;
    }
}

