/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.config.Config;
import io.helidon.security.QueryParamMapping;
import io.helidon.security.util.TokenHandler;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;

public final class QueryParamHandler {
    private final String paramName;
    private final TokenHandler tokenHandler;

    private QueryParamHandler(QueryParamMapping mapping) {
        this.paramName = mapping.queryParamName();
        this.tokenHandler = mapping.tokenHandler();
    }

    public static QueryParamHandler create(Config config) {
        return new QueryParamHandler(QueryParamMapping.create((Config)config));
    }

    public static QueryParamHandler create(QueryParamMapping mapping) {
        return new QueryParamHandler(mapping);
    }

    void extract(UriInfo uriInfo, Map<String, List<String>> headers) {
        List values = (List)uriInfo.getQueryParameters().get((Object)this.paramName);
        if (null == values) {
            return;
        }
        values.forEach(token -> {
            String tokenValue = this.tokenHandler.extractToken(token);
            this.tokenHandler.addHeader(headers, tokenValue);
        });
    }
}

