/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.security.integration.jersey.SecurityDisabledFilter;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.GenericType;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;

@ConstrainedTo(value=RuntimeType.SERVER)
public final class SecurityDisabledFeature
implements Feature {
    private final Security security;

    public SecurityDisabledFeature(Security security) {
        this.security = security;
    }

    public boolean configure(FeatureContext context) {
        RuntimeType runtimeType = context.getConfiguration().getRuntimeType();
        if (runtimeType != RuntimeType.SERVER || this.security.enabled()) {
            return false;
        }
        context.register((Object)new SecurityDisabledFilter(this.security));
        context.register((Object)new AbstractBinder(){

            protected void configure() {
                ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(SecurityContextRefFactory.class).to(SecurityContext.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class);
                ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<SecurityContext>>(){})).in(RequestScoped.class);
            }
        });
        return true;
    }

    private static class SecurityContextRefFactory
    extends ReferencingFactory<SecurityContext> {
        @Inject
        SecurityContextRefFactory(Provider<Ref<SecurityContext>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

