/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.webserver;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.config.Config;
import io.helidon.security.AuditEvent;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.ClassToInstanceStore;
import io.helidon.security.QueryParamMapping;
import io.helidon.security.SecurityClientBuilder;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityRequest;
import io.helidon.security.SecurityRequestBuilder;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.integration.common.AtnTracing;
import io.helidon.security.integration.common.AtzTracing;
import io.helidon.security.integration.common.SecurityTracing;
import io.helidon.security.internal.SecurityAuditEvent;
import io.helidon.security.util.TokenHandler;
import io.helidon.tracing.SpanContext;
import io.helidon.webserver.Handler;
import io.helidon.webserver.ResponseHeaders;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SecurityHandler
implements Handler {
    private static final Logger LOGGER = Logger.getLogger(SecurityHandler.class.getName());
    private static final String KEY_ROLES_ALLOWED = "roles-allowed";
    private static final String KEY_AUTHENTICATOR = "authenticator";
    private static final String KEY_AUTHORIZER = "authorizer";
    private static final String KEY_AUTHENTICATE = "authenticate";
    private static final String KEY_AUTHENTICATION_OPTIONAL = "authentication-optional";
    private static final String KEY_AUTHORIZE = "authorize";
    private static final String KEY_AUDIT = "audit";
    private static final String KEY_AUDIT_EVENT_TYPE = "audit-event-type";
    private static final String KEY_AUDIT_MESSAGE_FORMAT = "audit-message-format";
    private static final String KEY_QUERY_PARAM_HANDLERS = "query-params";
    private static final String DEFAULT_AUDIT_EVENT_TYPE = "request";
    private static final String DEFAULT_AUDIT_MESSAGE_FORMAT = "%3$s %1$s \"%2$s\" %5$s %6$s requested by %4$s";
    private static final SecurityHandler DEFAULT_INSTANCE = SecurityHandler.builder().build();
    private final Optional<Set<String>> rolesAllowed;
    private final Optional<ClassToInstanceStore<Object>> customObjects;
    private final Optional<Config> config;
    private final Optional<String> explicitAuthenticator;
    private final Optional<String> explicitAuthorizer;
    private final Optional<Boolean> authenticate;
    private final Optional<Boolean> authenticationOptional;
    private final Optional<Boolean> authorize;
    private final Optional<Boolean> audited;
    private final Optional<String> auditEventType;
    private final Optional<String> auditMessageFormat;
    private final List<QueryParamHandler> queryParamHandlers = new LinkedList<QueryParamHandler>();
    private final boolean combined;
    private final Map<String, Config> configMap = new HashMap<String, Config>();
    private final AtomicReference<SecurityHandler> combinedHandler = new AtomicReference();

    private SecurityHandler(Builder builder) {
        this.rolesAllowed = builder.rolesAllowed.flatMap(strings -> {
            HashSet newRoles = new HashSet(strings);
            return Optional.of(newRoles);
        });
        this.customObjects = builder.customObjects.flatMap(store -> {
            ClassToInstanceStore ctis = new ClassToInstanceStore();
            ctis.putAll(store);
            return Optional.of(ctis);
        });
        this.config = builder.config;
        this.explicitAuthenticator = builder.explicitAuthenticator;
        this.explicitAuthorizer = builder.explicitAuthorizer;
        this.authenticate = builder.authenticate;
        this.authenticationOptional = builder.authenticationOptional;
        this.audited = builder.audited;
        this.auditEventType = builder.auditEventType;
        this.auditMessageFormat = builder.auditMessageFormat;
        this.authorize = builder.authorize;
        this.combined = builder.combined;
        this.queryParamHandlers.addAll(builder.queryParamHandlers);
        this.config.ifPresent(conf -> ((List)conf.asNodeList().get()).forEach(node -> this.configMap.put(node.name(), (Config)node)));
    }

    static SecurityHandler create(Config config, SecurityHandler defaults) {
        Builder builder = SecurityHandler.builder(defaults);
        config.get(KEY_ROLES_ALLOWED).asList(String.class).ifPresentOrElse(builder::rolesAllowed, () -> defaults.rolesAllowed.ifPresent(builder::rolesAllowed));
        if (config.exists()) {
            builder.config(config);
        }
        config.get(KEY_AUTHENTICATOR).asString().or(() -> defaults.explicitAuthenticator).ifPresent(builder::authenticator);
        config.get(KEY_AUTHORIZER).asString().or(() -> defaults.explicitAuthorizer).ifPresent(builder::authorizer);
        config.get(KEY_AUTHENTICATE).as(Boolean.class).or(() -> defaults.authenticate).ifPresent(builder::authenticate);
        config.get(KEY_AUTHENTICATION_OPTIONAL).asBoolean().or(() -> defaults.authenticationOptional).ifPresent(builder::authenticationOptional);
        config.get(KEY_AUDIT).asBoolean().or(() -> defaults.audited).ifPresent(builder::audit);
        config.get(KEY_AUTHORIZE).asBoolean().or(() -> defaults.authorize).ifPresent(builder::authorize);
        config.get(KEY_AUDIT_EVENT_TYPE).asString().or(() -> defaults.auditEventType).ifPresent(builder::auditEventType);
        config.get(KEY_AUDIT_MESSAGE_FORMAT).asString().or(() -> defaults.auditMessageFormat).ifPresent(builder::auditMessageFormat);
        config.get(KEY_QUERY_PARAM_HANDLERS).asList(QueryParamHandler::create).ifPresent(it -> it.forEach(builder::addQueryParamHandler));
        if (config.get(KEY_ROLES_ALLOWED).exists()) {
            if (!config.get(KEY_AUTHENTICATE).exists()) {
                builder.authenticate(true);
            }
            if (!config.get(KEY_AUTHORIZE).exists()) {
                builder.authorize(true);
            }
        }
        config.get(KEY_AUTHENTICATION_OPTIONAL).asBoolean().ifPresent(aBoolean -> {
            if (aBoolean.booleanValue() && !config.get(KEY_AUTHENTICATE).exists()) {
                builder.authenticate(true);
            }
        });
        config.get(KEY_AUTHENTICATOR).asString().ifPresent(value -> {
            if (!config.get(KEY_AUTHENTICATE).exists()) {
                builder.authenticate(true);
            }
        });
        config.get(KEY_AUTHORIZER).asString().ifPresent(value -> {
            if (!config.get(KEY_AUTHORIZE).exists()) {
                builder.authorize(true);
            }
        });
        return builder.build();
    }

    private static <T> void configure(Config config, String key, Optional<T> defaultValue, Consumer<T> builderMethod, Class<T> clazz) {
        config.get(key).as(clazz).or(() -> defaultValue).ifPresent(builderMethod);
    }

    static SecurityHandler create() {
        return DEFAULT_INSTANCE;
    }

    private static Builder builder() {
        return new Builder();
    }

    private static Builder builder(SecurityHandler toCopy) {
        return new Builder().configureFrom(toCopy);
    }

    void extractQueryParams(SecurityContext securityContext, ServerRequest req) {
        HashMap headers = new HashMap();
        this.queryParamHandlers.forEach(handler -> handler.extract(req, headers));
        securityContext.env(securityContext.env().derive().headers(headers).build());
    }

    public void accept(ServerRequest req, ServerResponse res) {
        SecurityContext securityContext = (SecurityContext)req.context().get(SecurityContext.class).orElseThrow(() -> new SecurityException("Security context not present. Maybe you forgot to Routing.builder().register(WebSecurity.from(security))..."));
        if (this.combined) {
            this.processSecurity(securityContext, req, res);
        } else {
            if (null == this.combinedHandler.get()) {
                SecurityHandler defaultHandler = req.context().get(SecurityHandler.class).orElse(DEFAULT_INSTANCE);
                if (defaultHandler == DEFAULT_INSTANCE) {
                    this.combinedHandler.set(this);
                } else {
                    this.combinedHandler.compareAndSet(null, SecurityHandler.builder(defaultHandler).configureFrom(this).combined().build());
                }
            }
            this.combinedHandler.get().processSecurity(securityContext, req, res);
        }
    }

    private void processSecurity(SecurityContext securityContext, ServerRequest req, ServerResponse res) {
        SecurityTracing tracing = SecurityTracing.get();
        tracing.securityContext(securityContext);
        this.extractQueryParams(securityContext, req);
        securityContext.endpointConfig(securityContext.endpointConfig().derive().configMap(this.configMap).customObjects(this.customObjects.orElse((ClassToInstanceStore<Object>)new ClassToInstanceStore())).build());
        Optional context = Contexts.context();
        this.processAuthentication(res, securityContext, tracing.atnTracing()).thenCompose(atnResult -> {
            if (atnResult.proceed) {
                return this.processAuthorization(req, res, securityContext, tracing.atzTracing());
            }
            return CompletableFuture.completedFuture(AtxResult.STOP);
        }).thenAccept(atzResult -> {
            if (atzResult.proceed) {
                tracing.logProceed();
                tracing.finish();
                context.ifPresentOrElse(c -> Contexts.runInContext((Context)c, () -> ((ServerRequest)req).next()), () -> ((ServerRequest)req).next());
            } else {
                tracing.logDeny();
                tracing.finish();
            }
        }).exceptionally(throwable -> {
            tracing.error(throwable);
            LOGGER.log(Level.SEVERE, "Unexpected exception during security processing", (Throwable)throwable);
            this.abortRequest(res, null, Http.Status.INTERNAL_SERVER_ERROR_500.code(), Map.of());
            return null;
        });
        res.whenSent().thenAccept(sr -> this.processAudit(req, (ServerResponse)sr, securityContext));
    }

    private void processAudit(ServerRequest req, ServerResponse res, SecurityContext securityContext) {
        if (!this.audited.orElse(true).booleanValue()) {
            return;
        }
        if (this.audited.isEmpty() && req.method() instanceof Http.Method) {
            switch ((Http.Method)req.method()) {
                case GET: 
                case HEAD: {
                    return;
                }
            }
        }
        SecurityAuditEvent auditEvent = SecurityAuditEvent.audit((AuditEvent.AuditSeverity)(switch (res.status().family()) {
            case Http.ResponseStatus.Family.INFORMATIONAL, Http.ResponseStatus.Family.SUCCESSFUL, Http.ResponseStatus.Family.REDIRECTION -> AuditEvent.AuditSeverity.SUCCESS;
            default -> AuditEvent.AuditSeverity.FAILURE;
        }), (String)this.auditEventType.orElse(DEFAULT_AUDIT_EVENT_TYPE), (String)this.auditMessageFormat.orElse(DEFAULT_AUDIT_MESSAGE_FORMAT)).addParam(AuditEvent.AuditParam.plain((String)"method", (Object)req.method())).addParam(AuditEvent.AuditParam.plain((String)"path", (Object)req.path())).addParam(AuditEvent.AuditParam.plain((String)"status", (Object)String.valueOf(res.status().code()))).addParam(AuditEvent.AuditParam.plain((String)"subject", (Object)securityContext.user().orElse(SecurityContext.ANONYMOUS))).addParam(AuditEvent.AuditParam.plain((String)"transport", (Object)"http")).addParam(AuditEvent.AuditParam.plain((String)"resourceType", (Object)"http")).addParam(AuditEvent.AuditParam.plain((String)"targetUri", (Object)req.uri()));
        securityContext.service().ifPresent(svc -> auditEvent.addParam(AuditEvent.AuditParam.plain((String)"service", (Object)svc.toString())));
        securityContext.audit((AuditEvent)auditEvent);
    }

    private CompletionStage<AtxResult> processAuthentication(ServerResponse res, SecurityContext securityContext, AtnTracing atnTracing) {
        if (!this.authenticate.orElse(false).booleanValue()) {
            return CompletableFuture.completedFuture(AtxResult.PROCEED);
        }
        CompletableFuture<AtxResult> future = new CompletableFuture<AtxResult>();
        SecurityClientBuilder clientBuilder = securityContext.atnClientBuilder();
        this.configureSecurityRequest((SecurityRequestBuilder<? extends SecurityRequestBuilder<?>>)clientBuilder, atnTracing.findParent().orElse(null));
        ((SecurityClientBuilder)clientBuilder.explicitProvider((String)this.explicitAuthenticator.orElse(null))).submit().thenAccept(response -> {
            response.responseHeaders().forEach((arg_0, arg_1) -> ((ResponseHeaders)res.headers()).put(arg_0, arg_1));
            switch (response.status()) {
                case SUCCESS: {
                    break;
                }
                case FAILURE_FINISH: {
                    if (!this.atnFinishFailure(res, future, (AuthenticationResponse)response)) break;
                    this.atnSpanFinish(atnTracing, (AuthenticationResponse)response);
                    return;
                }
                case SUCCESS_FINISH: {
                    this.atnFinish(res, future, (AuthenticationResponse)response);
                    this.atnSpanFinish(atnTracing, (AuthenticationResponse)response);
                    return;
                }
                case ABSTAIN: 
                case FAILURE: {
                    if (!this.atnAbstainFailure(res, future, (AuthenticationResponse)response)) break;
                    this.atnSpanFinish(atnTracing, (AuthenticationResponse)response);
                    return;
                }
                default: {
                    SecurityException e = new SecurityException("Invalid SecurityStatus returned: " + response.status());
                    future.completeExceptionally(e);
                    atnTracing.error((Throwable)e);
                    return;
                }
            }
            this.atnSpanFinish(atnTracing, (AuthenticationResponse)response);
            future.complete(new AtxResult(clientBuilder.buildRequest()));
        }).exceptionally(throwable -> {
            atnTracing.error(throwable);
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private void atnSpanFinish(AtnTracing atnTracing, AuthenticationResponse response) {
        response.user().ifPresent(arg_0 -> ((AtnTracing)atnTracing).logUser(arg_0));
        response.service().ifPresent(arg_0 -> ((AtnTracing)atnTracing).logService(arg_0));
        atnTracing.logStatus(response.status());
        atnTracing.finish();
    }

    private boolean atnAbstainFailure(ServerResponse res, CompletableFuture<AtxResult> future, AuthenticationResponse response) {
        if (this.authenticationOptional.orElse(false).booleanValue()) {
            LOGGER.finest("Authentication failed, but was optional, so assuming anonymous");
            return false;
        }
        this.abortRequest(res, (SecurityResponse)response, Http.Status.UNAUTHORIZED_401.code(), Map.of("WWW-Authenticate", List.of("Basic realm=\"Security Realm\"")));
        future.complete(AtxResult.STOP);
        return true;
    }

    private boolean atnFinishFailure(ServerResponse res, CompletableFuture<AtxResult> future, AuthenticationResponse response) {
        if (this.authenticationOptional.orElse(false).booleanValue()) {
            LOGGER.finest("Authentication failed, but was optional, so assuming anonymous");
            return false;
        }
        int defaultStatusCode = Http.Status.UNAUTHORIZED_401.code();
        this.abortRequest(res, (SecurityResponse)response, defaultStatusCode, Map.of());
        future.complete(AtxResult.STOP);
        return true;
    }

    private void atnFinish(ServerResponse res, CompletableFuture<AtxResult> future, AuthenticationResponse response) {
        int defaultStatusCode = Http.Status.OK_200.code();
        this.abortRequest(res, (SecurityResponse)response, defaultStatusCode, Map.of());
        future.complete(AtxResult.STOP);
    }

    private void abortRequest(ServerResponse res, SecurityResponse response, int defaultCode, Map<String, List<String>> defaultHeaders) {
        int statusCode = null == response ? defaultCode : response.statusCode().orElse(defaultCode);
        Map responseHeaders = null == response ? defaultHeaders : response.responseHeaders();
        responseHeaders = responseHeaders.isEmpty() ? defaultHeaders : responseHeaders;
        ResponseHeaders httpHeaders = res.headers();
        for (Map.Entry entry : responseHeaders.entrySet()) {
            httpHeaders.put((String)entry.getKey(), (Iterable)entry.getValue());
        }
        res.status(statusCode);
        res.send();
    }

    private void configureSecurityRequest(SecurityRequestBuilder<? extends SecurityRequestBuilder<?>> request, SpanContext parentSpanContext) {
        request.optional(this.authenticationOptional.orElse(false).booleanValue()).tracingSpan(parentSpanContext);
    }

    private CompletionStage<AtxResult> processAuthorization(ServerRequest req, ServerResponse res, SecurityContext context, AtzTracing atzTracing) {
        CompletableFuture<AtxResult> future = new CompletableFuture<AtxResult>();
        if (!this.authorize.orElse(false).booleanValue()) {
            future.complete(AtxResult.PROCEED);
            atzTracing.logStatus(SecurityResponse.SecurityStatus.ABSTAIN);
            atzTracing.finish();
            return future;
        }
        Set<String> rolesSet = this.rolesAllowed.orElse(Set.of());
        if (!rolesSet.isEmpty()) {
            if (this.explicitAuthorizer.isPresent()) {
                if (rolesSet.stream().noneMatch(role -> context.isUserInRole(role, this.explicitAuthorizer.get()))) {
                    this.auditRoleMissing(context, req.path(), context.user(), rolesSet);
                    this.abortRequest(res, null, Http.Status.FORBIDDEN_403.code(), Map.of());
                    future.complete(AtxResult.STOP);
                    atzTracing.finish();
                    return future;
                }
            } else if (rolesSet.stream().noneMatch(arg_0 -> ((SecurityContext)context).isUserInRole(arg_0))) {
                this.auditRoleMissing(context, req.path(), context.user(), rolesSet);
                this.abortRequest(res, null, Http.Status.FORBIDDEN_403.code(), Map.of());
                future.complete(AtxResult.STOP);
                atzTracing.finish();
                return future;
            }
        }
        SecurityClientBuilder client = context.atzClientBuilder();
        this.configureSecurityRequest((SecurityRequestBuilder<? extends SecurityRequestBuilder<?>>)client, atzTracing.findParent().orElse(null));
        ((SecurityClientBuilder)client.explicitProvider((String)this.explicitAuthorizer.orElse(null))).submit().thenAccept(response -> {
            atzTracing.logStatus(response.status());
            switch (response.status()) {
                case SUCCESS: {
                    break;
                }
                case FAILURE_FINISH: 
                case SUCCESS_FINISH: {
                    int defaultStatus = response.status() == SecurityResponse.SecurityStatus.FAILURE_FINISH ? Http.Status.FORBIDDEN_403.code() : Http.Status.OK_200.code();
                    atzTracing.finish();
                    this.abortRequest(res, (SecurityResponse)response, defaultStatus, Map.of());
                    future.complete(AtxResult.STOP);
                    return;
                }
                case ABSTAIN: 
                case FAILURE: {
                    atzTracing.finish();
                    this.abortRequest(res, (SecurityResponse)response, Http.Status.FORBIDDEN_403.code(), Map.of());
                    future.complete(AtxResult.STOP);
                    return;
                }
                default: {
                    SecurityException e = new SecurityException("Invalid SecurityStatus returned: " + response.status());
                    atzTracing.error((Throwable)e);
                    future.completeExceptionally(e);
                    return;
                }
            }
            atzTracing.finish();
            future.complete(AtxResult.PROCEED);
        }).exceptionally(throwable -> {
            atzTracing.error(throwable);
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private void auditRoleMissing(SecurityContext context, HttpRequest.Path path, Optional<Subject> user, Set<String> rolesSet) {
        context.audit((AuditEvent)SecurityAuditEvent.failure((String)"authz.authorize", (String)"User is not in any of the required roles: %s. Path %s. Subject %s").addParam(AuditEvent.AuditParam.plain((String)"roles", rolesSet)).addParam(AuditEvent.AuditParam.plain((String)"path", (Object)path)).addParam(AuditEvent.AuditParam.plain((String)"subject", user)));
    }

    public List<QueryParamHandler> queryParamHandlers() {
        return Collections.unmodifiableList(this.queryParamHandlers);
    }

    public SecurityHandler authenticator(String explicitAuthenticator) {
        return SecurityHandler.builder(this).authenticator(explicitAuthenticator).build();
    }

    public SecurityHandler authorizer(String explicitAuthorizer) {
        return SecurityHandler.builder(this).authorizer(explicitAuthorizer).build();
    }

    public SecurityHandler rolesAllowed(String ... roles) {
        return SecurityHandler.builder(this).rolesAllowed(roles).authorize(true).authenticate(true).build();
    }

    public SecurityHandler authenticationOptional() {
        return SecurityHandler.builder(this).authenticationOptional(true).build();
    }

    public SecurityHandler authenticate() {
        return SecurityHandler.builder(this).authenticate(true).build();
    }

    public SecurityHandler skipAuthentication() {
        return SecurityHandler.builder(this).authenticate(false).build();
    }

    public SecurityHandler customObject(Object object) {
        return SecurityHandler.builder(this).customObject(object).build();
    }

    public SecurityHandler auditEventType(String eventType) {
        return SecurityHandler.builder(this).auditEventType(eventType).build();
    }

    public SecurityHandler auditMessageFormat(String messageFormat) {
        return SecurityHandler.builder(this).auditMessageFormat(messageFormat).build();
    }

    public SecurityHandler authorize() {
        return SecurityHandler.builder(this).authorize(true).build();
    }

    public SecurityHandler skipAuthorization() {
        return SecurityHandler.builder(this).authorize(false).build();
    }

    public SecurityHandler audit() {
        return SecurityHandler.builder(this).audit(true).build();
    }

    public SecurityHandler skipAudit() {
        return SecurityHandler.builder(this).audit(false).build();
    }

    public SecurityHandler queryParam(String queryParamName, TokenHandler headerHandler) {
        return SecurityHandler.builder(this).addQueryParamHandler(QueryParamHandler.create(queryParamName, headerHandler)).build();
    }

    private static final class Builder
    implements io.helidon.common.Builder<Builder, SecurityHandler> {
        private final List<QueryParamHandler> queryParamHandlers = new LinkedList<QueryParamHandler>();
        private Optional<Set<String>> rolesAllowed = Optional.empty();
        private Optional<ClassToInstanceStore<Object>> customObjects = Optional.empty();
        private Optional<Config> config = Optional.empty();
        private Optional<String> explicitAuthenticator = Optional.empty();
        private Optional<String> explicitAuthorizer = Optional.empty();
        private Optional<Boolean> authenticate = Optional.empty();
        private Optional<Boolean> authenticationOptional = Optional.empty();
        private Optional<Boolean> authorize = Optional.empty();
        private Optional<Boolean> audited = Optional.empty();
        private Optional<String> auditEventType = Optional.empty();
        private Optional<String> auditMessageFormat = Optional.empty();
        private boolean combined;

        private Builder() {
        }

        public SecurityHandler build() {
            return new SecurityHandler(this);
        }

        private Builder combined() {
            this.combined = true;
            return this;
        }

        private Builder configureFrom(SecurityHandler handler) {
            handler.rolesAllowed.ifPresent(this::rolesAllowed);
            handler.customObjects.ifPresent(this::customObjects);
            handler.config.ifPresent(this::config);
            handler.explicitAuthenticator.ifPresent(this::authenticator);
            handler.explicitAuthorizer.ifPresent(this::authorizer);
            handler.authenticate.ifPresent(this::authenticate);
            handler.authenticationOptional.ifPresent(this::authenticationOptional);
            handler.audited.ifPresent(this::audit);
            handler.auditEventType.ifPresent(this::auditEventType);
            handler.auditMessageFormat.ifPresent(this::auditMessageFormat);
            handler.authorize.ifPresent(this::authorize);
            this.queryParamHandlers.addAll(handler.queryParamHandlers());
            return this;
        }

        private Builder customObjects(ClassToInstanceStore<Object> store) {
            this.customObjects.ifPresentOrElse(myStore -> myStore.putAll(store), () -> {
                ClassToInstanceStore ctis = new ClassToInstanceStore();
                ctis.putAll(store);
                this.customObjects = Optional.of(ctis);
            });
            return this;
        }

        public Builder addQueryParamHandler(QueryParamHandler handler) {
            this.queryParamHandlers.add(handler);
            return this;
        }

        Builder authenticator(String explicitAuthenticator) {
            this.explicitAuthenticator = Optional.of(explicitAuthenticator);
            return this;
        }

        Builder authorizer(String explicitAuthorizer) {
            this.explicitAuthorizer = Optional.of(explicitAuthorizer);
            return this;
        }

        Builder rolesAllowed(String ... roles) {
            return this.rolesAllowed(Arrays.asList(roles));
        }

        private Builder config(Config config) {
            this.config = Optional.of(config);
            return this;
        }

        Builder authenticationOptional(boolean isOptional) {
            this.authenticationOptional = Optional.of(isOptional);
            return this;
        }

        Builder authenticate(boolean authenticate) {
            this.authenticate = Optional.of(authenticate);
            return this;
        }

        Builder customObject(Object object) {
            this.customObjects.ifPresentOrElse(store -> store.putInstance(object), () -> {
                ClassToInstanceStore ctis = new ClassToInstanceStore();
                ctis.putInstance(object);
                this.customObjects = Optional.of(ctis);
            });
            return this;
        }

        Builder auditEventType(String eventType) {
            this.auditEventType = Optional.of(eventType);
            return this;
        }

        Builder auditMessageFormat(String messageFormat) {
            this.auditMessageFormat = Optional.of(messageFormat);
            return this;
        }

        Builder authorize(boolean authorize) {
            this.authorize = Optional.of(authorize);
            return this;
        }

        Builder audit(boolean audited) {
            this.audited = Optional.of(audited);
            return this;
        }

        Builder rolesAllowed(Collection<String> roles) {
            this.rolesAllowed.ifPresentOrElse(strings -> strings.addAll(roles), () -> {
                HashSet newRoles = new HashSet(roles);
                this.rolesAllowed = Optional.of(newRoles);
            });
            return this;
        }
    }

    private static final class AtxResult {
        private static final AtxResult PROCEED = new AtxResult(true);
        private static final AtxResult STOP = new AtxResult(false);
        private final boolean proceed;

        private AtxResult(boolean proceed) {
            this.proceed = proceed;
        }

        private AtxResult(SecurityRequest ignored) {
            this.proceed = true;
        }
    }

    public static final class QueryParamHandler {
        private final String queryParamName;
        private final TokenHandler headerHandler;

        private QueryParamHandler(QueryParamMapping mapping) {
            this.queryParamName = mapping.queryParamName();
            this.headerHandler = mapping.tokenHandler();
        }

        public static QueryParamHandler create(Config config) {
            return QueryParamHandler.create(QueryParamMapping.create((Config)config));
        }

        public static QueryParamHandler create(QueryParamMapping mapping) {
            return new QueryParamHandler(mapping);
        }

        public static QueryParamHandler create(String queryParamName, TokenHandler headerHandler) {
            return QueryParamHandler.create(QueryParamMapping.create((String)queryParamName, (TokenHandler)headerHandler));
        }

        void extract(ServerRequest req, Map<String, List<String>> headers) {
            List values = req.queryParams().all(this.queryParamName);
            values.forEach(token -> {
                String tokenValue = this.headerHandler.extractToken(token);
                this.headerHandler.addHeader(headers, tokenValue);
            });
        }
    }
}

