/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.abac;

import io.helidon.common.Errors;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityLevel;
import io.helidon.security.SecurityResponse;
import io.helidon.security.providers.abac.AbacAnnotation;
import io.helidon.security.providers.abac.AbacValidatorConfig;
import io.helidon.security.providers.abac.RuntimeAttribute;
import io.helidon.security.providers.abac.spi.AbacValidator;
import io.helidon.security.providers.abac.spi.AbacValidatorService;
import io.helidon.security.spi.AuthorizationProvider;
import io.helidon.security.spi.SecurityProvider;
import io.helidon.security.spi.SynchronousProvider;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;

public final class AbacProvider
extends SynchronousProvider
implements AuthorizationProvider {
    private final List<AbacValidator<? extends AbacValidatorConfig>> validators = new ArrayList<AbacValidator<? extends AbacValidatorConfig>>();
    private final Set<Class<? extends Annotation>> supportedAnnotations;
    private final Set<String> supportedConfigKeys;
    private final Set<Class<? extends AbacValidatorConfig>> supportedCustomObjects;
    private final boolean failOnUnvalidated;
    private final boolean failIfNoneValidated;

    private AbacProvider(Builder builder) {
        HelidonServiceLoader services = HelidonServiceLoader.create(ServiceLoader.load(AbacValidatorService.class));
        for (AbacValidatorService service : services) {
            this.validators.add(service.instantiate(builder.config.get(service.configKey())));
        }
        this.validators.addAll(builder.validators);
        HashSet annotations = new HashSet();
        HashSet configKeys = new HashSet();
        HashSet customObjects = new HashSet();
        this.validators.forEach(v -> {
            annotations.addAll(v.supportedAnnotations());
            configKeys.add(v.configKey());
            customObjects.add(v.configClass());
        });
        this.supportedAnnotations = Collections.unmodifiableSet(annotations);
        this.supportedConfigKeys = Collections.unmodifiableSet(configKeys);
        this.supportedCustomObjects = Collections.unmodifiableSet(customObjects);
        this.failOnUnvalidated = builder.failOnUnvalidated;
        this.failIfNoneValidated = builder.failIfNoneValidated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AbacProvider create(Config config) {
        return AbacProvider.builder().config(config).build();
    }

    public static AbacProvider create() {
        return AbacProvider.builder().build();
    }

    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        return this.supportedAnnotations;
    }

    protected AuthorizationResponse syncAuthorize(ProviderRequest providerRequest) {
        Errors.Collector collector = Errors.collector();
        ArrayList<RuntimeAttribute> attributes = new ArrayList<RuntimeAttribute>();
        EndpointConfig epConfig = providerRequest.endpointConfig();
        this.validateAnnotations(epConfig, collector);
        this.validateConfig(epConfig, collector);
        this.validateCustom(epConfig, collector);
        Optional abacConfig = epConfig.config("abac");
        for (AbacValidator<? extends AbacValidatorConfig> validator : this.validators) {
            Class<? extends AbacValidatorConfig> configClass = validator.configClass();
            String configKey = validator.configKey();
            Collection<Class<Annotation>> annotations = validator.supportedAnnotations();
            Optional customObject = epConfig.instance(configClass);
            if (customObject.isPresent()) {
                attributes.add(new RuntimeAttribute(validator, (AbacValidatorConfig)customObject.get()));
                continue;
            }
            abacConfig.flatMap(it -> it.get(configKey).asNode().asOptional()).ifPresentOrElse(attribConfig -> attributes.add(new RuntimeAttribute(validator, (AbacValidatorConfig)validator.fromConfig((Config)attribConfig))), () -> {
                ArrayList annotationConfig = new ArrayList();
                for (SecurityLevel securityLevel : epConfig.securityLevels()) {
                    for (Class annotation : annotations) {
                        List list = securityLevel.combineAnnotations(annotation, EndpointConfig.AnnotationScope.values());
                        annotationConfig.addAll(list);
                    }
                }
                if (!annotationConfig.isEmpty()) {
                    attributes.add(new RuntimeAttribute(validator, (AbacValidatorConfig)validator.fromAnnotations(epConfig)));
                }
            });
        }
        for (RuntimeAttribute attribute : attributes) {
            this.validate(attribute.getValidator(), attribute.getConfig(), collector, providerRequest);
        }
        Errors errors = collector.collect();
        if (errors.isValid()) {
            return AuthorizationResponse.permit();
        }
        return ((AuthorizationResponse.Builder)((AuthorizationResponse.Builder)AuthorizationResponse.builder().status(SecurityResponse.SecurityStatus.FAILURE)).description(errors.toString())).build();
    }

    private <A extends AbacValidator<B>, B extends AbacValidatorConfig> void validate(A validator, AbacValidatorConfig config, Errors.Collector collector, ProviderRequest context) {
        validator.validate((AbacValidatorConfig)config, collector, context);
    }

    private void validateCustom(EndpointConfig epConfig, Errors.Collector collector) {
        epConfig.instanceKeys().forEach(clazz -> {
            int attributes = 0;
            int unsupported = 0;
            LinkedList<String> unsupportedClasses = new LinkedList<String>();
            if (AbacValidatorConfig.class.isInstance(epConfig.instance(clazz))) {
                ++attributes;
                if (!this.supportedCustomObjects.contains(clazz)) {
                    ++unsupported;
                    unsupportedClasses.add(clazz.getName());
                }
            }
            boolean fail = false;
            if (unsupported != 0) {
                if (unsupported == attributes && this.failIfNoneValidated) {
                    fail = true;
                } else if (this.failOnUnvalidated) {
                    fail = true;
                }
                if (fail) {
                    for (String key : unsupportedClasses) {
                        collector.fatal((Object)this, key + " custom object is not supported.");
                    }
                    collector.fatal((Object)this, "Supported custom objects: " + this.supportedCustomObjects);
                }
            }
        });
    }

    private void validateConfig(EndpointConfig config, Errors.Collector collector) {
        config.config("abac").ifPresent(abacConfig -> this.validateAbacConfig((Config)abacConfig, collector));
    }

    private void validateAbacConfig(Config abacConfig, Errors.Collector collector) {
        List keys = ((List)abacConfig.asNodeList().orElseGet(List::of)).stream().map(Config::name).collect(Collectors.toList());
        HashSet uniqueKeys = new HashSet(keys);
        if (uniqueKeys.size() != keys.size()) {
            collector.fatal(keys, "There are duplicit keys under \"abac\" node in configuration.");
        }
        int attributes = 0;
        int unsupported = 0;
        LinkedList<String> unsupportedKeys = new LinkedList<String>();
        for (String key : uniqueKeys) {
            ++attributes;
            if (this.supportedConfigKeys.contains(key)) continue;
            ++unsupported;
            unsupportedKeys.add(key);
        }
        boolean fail = false;
        if (unsupported != 0) {
            if (unsupported == attributes && this.failIfNoneValidated) {
                fail = true;
            } else if (this.failOnUnvalidated) {
                fail = true;
            }
            if (fail) {
                for (String key : unsupportedKeys) {
                    collector.fatal((Object)this, "\"" + key + "\" ABAC attribute config key is not supported.");
                }
                collector.fatal((Object)this, "Supported ABAC config keys: " + this.supportedConfigKeys);
            }
        }
    }

    private void validateAnnotations(EndpointConfig epConfig, Errors.Collector collector) {
        for (SecurityLevel securityLevel : epConfig.securityLevels()) {
            int attributeAnnotations = 0;
            int unsupported = 0;
            LinkedList<String> unsupportedClassNames = new LinkedList<String>();
            Map allAnnotations = securityLevel.allAnnotations();
            for (Class type : allAnnotations.keySet()) {
                AbacAnnotation abacAnnotation = type.getAnnotation(AbacAnnotation.class);
                if (null == abacAnnotation && !this.isSupportedAnnotation(type)) continue;
                ++attributeAnnotations;
                if (this.supportedAnnotations.contains(type)) continue;
                ++unsupported;
                unsupportedClassNames.add(type.getName());
            }
            if (unsupported == 0) continue;
            boolean fail = this.failOnUnvalidated;
            if (unsupported == attributeAnnotations && this.failIfNoneValidated) {
                fail = true;
            }
            if (!fail) continue;
            for (String unsupportedClassName : unsupportedClassNames) {
                collector.fatal((Object)this, unsupportedClassName + " attribute annotation is not supported.");
            }
            collector.fatal((Object)this, "Supported annotations: " + this.supportedAnnotations);
        }
    }

    private boolean isSupportedAnnotation(Class<? extends Annotation> type) {
        return RolesAllowed.class.equals(type) || PermitAll.class.equals(type) || DenyAll.class.equals(type);
    }

    @Configured(prefix="abac", description="Attribute Based Access Control provider", provides={SecurityProvider.class, AuthorizationProvider.class})
    public static final class Builder
    implements io.helidon.common.Builder<Builder, AbacProvider> {
        private final List<AbacValidator<? extends AbacValidatorConfig>> validators = new ArrayList<AbacValidator<? extends AbacValidatorConfig>>();
        private Config config = Config.empty();
        private boolean failOnUnvalidated = true;
        private boolean failIfNoneValidated = true;

        private Builder() {
        }

        public AbacProvider build() {
            return new AbacProvider(this);
        }

        public Builder addValidator(AbacValidator<? extends AbacValidatorConfig> validator) {
            this.validators.add(validator);
            return this;
        }

        public Builder configuration(Config config) {
            this.config = config;
            return this;
        }

        public Builder failOnUnvalidated(boolean failOnUnvalidated) {
            this.failOnUnvalidated = failOnUnvalidated;
            return this;
        }

        public Builder failIfNoneValidated(boolean failIfNoneValidated) {
            this.failIfNoneValidated = failIfNoneValidated;
            return this;
        }

        public Builder config(Config config) {
            this.configuration(config);
            config.get("fail-on-unvalidated").asBoolean().ifPresent(this::failOnUnvalidated);
            config.get("fail-if-none-validated").asBoolean().ifPresent(this::failIfNoneValidated);
            return this;
        }
    }
}

