/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.common;

import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.providers.common.OutboundTarget;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public final class OutboundConfig {
    public static final String CONFIG_OUTBOUND = "outbound";
    public static final String PROPERTY_DISABLE_OUTBOUND = "io.helidon.security.client.disable";
    private final Map<Class<?>, Map<OutboundTarget, Object>> configTypeToConfigCache = new ConcurrentHashMap();
    private final LinkedList<OutboundTarget> targets = new LinkedList();

    public static OutboundConfig create(Config providerConfig) {
        return OutboundConfig.createFromConfig(providerConfig, null);
    }

    public static OutboundConfig create(Config providerConfig, OutboundTarget ... defaults) {
        return OutboundConfig.createFromConfig(providerConfig, defaults);
    }

    static OutboundConfig createFromConfig(Config providerConfig, OutboundTarget[] defaults) {
        Config config = providerConfig.get(CONFIG_OUTBOUND);
        List configuredTargets = (List)config.asList(OutboundTarget::create).orElse(List.of());
        boolean useDefaults = configuredTargets.stream().noneMatch(targetConfig -> "default".equals(targetConfig.name())) && null != defaults;
        Builder builder = OutboundConfig.builder();
        if (useDefaults) {
            Arrays.stream(defaults).forEach(builder::addTarget);
        }
        configuredTargets.forEach(builder::addTarget);
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<OutboundTarget> findTarget(SecurityEnvironment env) {
        String transport = env.transport();
        String host = env.targetUri().getHost();
        String path = env.path().orElse(null);
        String method = env.method();
        for (OutboundTarget outboundTarget : this.targets) {
            if (!outboundTarget.matches(transport, host, path, method)) continue;
            return Optional.of(outboundTarget);
        }
        return Optional.empty();
    }

    public <T> Optional<T> findTargetCustomObject(SecurityEnvironment env, Class<T> customObjectClass, Function<Config, ? extends T> customObjectProducer, Supplier<? extends T> defaultValue) {
        Optional<OutboundTarget> targetOptional = this.findTarget(env);
        if (targetOptional.isEmpty()) {
            return Optional.empty();
        }
        OutboundTarget target = targetOptional.get();
        Map cache = this.configTypeToConfigCache.computeIfAbsent(customObjectClass, it -> Collections.synchronizedMap(new IdentityHashMap()));
        Object value = cache.computeIfAbsent(target, it -> {
            Optional<Object> customObject = it.customObject(customObjectClass);
            if (customObject.isPresent()) {
                return customObject.get();
            }
            customObject = target.getConfig().map(customObjectProducer);
            if (customObject.isPresent()) {
                return customObject.get();
            }
            return defaultValue.get();
        });
        return Optional.of(value);
    }

    public List<OutboundTarget> targets() {
        return this.targets;
    }

    @Configured(description="Outbound configuration for outbound security")
    public static final class Builder
    implements io.helidon.common.Builder<Builder, OutboundConfig> {
        private final List<OutboundTarget> targets = new LinkedList<OutboundTarget>();
        private final Set<String> names = new HashSet<String>();

        private Builder() {
        }

        public Builder addTarget(OutboundTarget config) {
            if (this.names.contains(config.name())) {
                throw new IllegalStateException("Duplicate name of a target: " + config.name());
            }
            this.names.add(config.name());
            this.targets.add(config);
            return this;
        }

        public OutboundConfig build() {
            OutboundConfig result = new OutboundConfig();
            result.targets.addAll(this.targets);
            return result;
        }
    }
}

