/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.common.spi;

import io.helidon.common.Builder;
import io.helidon.config.Config;
import io.helidon.security.ClassToInstanceStore;
import java.lang.reflect.Method;
import java.util.Optional;

@FunctionalInterface
public interface AnnotationAnalyzer {
    default public void init(Config config) {
    }

    public AnalyzerResponse analyze(Class<?> var1);

    default public AnalyzerResponse analyze(Class<?> maybeAnnotated, AnalyzerResponse previousResponse) {
        return AnalyzerResponse.abstain(previousResponse);
    }

    default public AnalyzerResponse analyze(Method maybeAnnotated, AnalyzerResponse previousResponse) {
        return AnalyzerResponse.abstain(previousResponse);
    }

    public static final class AnalyzerResponse {
        private final ClassToInstanceStore<Object> registry = ClassToInstanceStore.create((Object[])new Object[0]);
        private final AnalyzerResponse parent;
        private final Flag atnResponse;
        private final Flag atzResponse;
        private final String authenticator;
        private final String authorizer;

        private AnalyzerResponse(Builder builder) {
            this.registry.putAll(builder.registry);
            this.parent = builder.parent;
            this.atnResponse = builder.atnResponse;
            this.atzResponse = builder.atzResponse;
            this.authenticator = builder.authenticator;
            this.authorizer = builder.authorizer;
        }

        public static AnalyzerResponse abstain() {
            return AnalyzerResponse.builder().build();
        }

        public static AnalyzerResponse abstain(AnalyzerResponse previousResponse) {
            return AnalyzerResponse.builder(previousResponse).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(AnalyzerResponse parent) {
            return new Builder().parent(parent);
        }

        public Optional<AnalyzerResponse> parent() {
            return Optional.ofNullable(this.parent);
        }

        public Flag authenticationResponse() {
            return this.atnResponse;
        }

        public Flag authorizationResponse() {
            return this.atzResponse;
        }

        public Optional<String> authenticator() {
            return Optional.ofNullable(this.authenticator);
        }

        public Optional<String> authorizer() {
            return Optional.ofNullable(this.authorizer);
        }

        public ClassToInstanceStore<Object> registry() {
            return this.registry;
        }

        public static class Builder
        implements io.helidon.common.Builder<Builder, AnalyzerResponse> {
            private final ClassToInstanceStore<Object> registry = ClassToInstanceStore.create((Object[])new Object[0]);
            private AnalyzerResponse parent;
            private Flag atnResponse = Flag.ABSTAIN;
            private Flag atzResponse = Flag.ABSTAIN;
            private String authenticator;
            private String authorizer;

            public AnalyzerResponse build() {
                return new AnalyzerResponse(this);
            }

            Builder parent(AnalyzerResponse parent) {
                this.parent = parent;
                return this;
            }

            public Builder register(Object anInstance) {
                this.registry.putInstance(anInstance);
                return this;
            }

            public <T> Builder register(Class<? super T> theClass, T anInstance) {
                this.registry.putInstance(theClass, anInstance);
                return this;
            }

            public Builder authenticationResponse(Flag atnResponse) {
                this.atnResponse = atnResponse;
                return this;
            }

            public Builder authorizeResponse(Flag authorizeResponse) {
                this.atzResponse = authorizeResponse;
                return this;
            }

            public Builder authenticator(String authenticator) {
                this.authenticator = authenticator;
                return this;
            }

            public Builder authorizer(String authorizer) {
                this.authorizer = authorizer;
                return this;
            }
        }
    }

    public static enum Flag {
        REQUIRED,
        OPTIONAL,
        FORBIDDEN,
        ABSTAIN;

    }
}

