/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.common;

import io.helidon.common.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.security.ClassToInstanceStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class OutboundTarget {
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_TRANSPORTS = "transports";
    public static final String CONFIG_HOSTS = "hosts";
    public static final String CONFIG_PATHS = "paths";
    public static final String CONFIG_METHODS = "methods";
    private final String name;
    private final Set<String> transports = new HashSet<String>();
    private final Set<String> hosts = new HashSet<String>();
    private final List<Pattern> hostPatterns = new LinkedList<Pattern>();
    private final Set<String> paths = new HashSet<String>();
    private final List<Pattern> pathPatterns = new LinkedList<Pattern>();
    private final Set<String> methods = new HashSet<String>();
    private final Config config;
    private final ClassToInstanceStore<Object> customObjects = new ClassToInstanceStore();
    private final boolean matchAllTransports;
    private final boolean matchAllHosts;
    private final boolean matchAllPaths;
    private final boolean matchAllMethods;

    private OutboundTarget(Builder builder) {
        this.name = builder.name;
        this.transports.addAll(builder.transports);
        this.hosts.addAll(builder.hosts);
        this.paths.addAll(builder.paths);
        this.methods.addAll(builder.methods);
        this.config = builder.config;
        this.customObjects.putAll(builder.customObjects);
        this.matchAllTransports = this.transports.isEmpty() || this.anyMatch(this.transports);
        this.matchAllHosts = this.hosts.isEmpty() || this.anyMatch(this.hosts);
        this.matchAllPaths = this.paths.isEmpty() || this.anyMatch(this.paths);
        this.matchAllMethods = this.methods.isEmpty();
        if (!this.matchAllHosts) {
            this.hosts.stream().filter(s -> s.contains("*")).forEach(host -> this.hostPatterns.add(this.toPattern((String)host)));
        }
        if (!this.matchAllPaths) {
            this.paths.forEach(path -> this.pathPatterns.add(Pattern.compile(path)));
        }
    }

    public static OutboundTarget create(Config config) {
        Builder builder = new Builder();
        builder.config(config);
        builder.name((String)config.get(CONFIG_NAME).asString().get());
        ((List)config.get(CONFIG_TRANSPORTS).asList(String.class).orElse(List.of())).forEach(builder::addTransport);
        ((List)config.get(CONFIG_HOSTS).asList(String.class).orElse(List.of())).forEach(builder::addHost);
        ((List)config.get(CONFIG_PATHS).asList(String.class).orElse(List.of())).forEach(builder::addPath);
        ((List)config.get(CONFIG_METHODS).asList(String.class).orElse(List.of())).forEach(builder::addMethod);
        return builder.build();
    }

    public static Builder builder(String name) {
        return new Builder().name(name);
    }

    private Pattern toPattern(String host) {
        String pattern = host.replaceAll("\\.", "\\.");
        pattern = pattern.replaceAll("\\*", ".*");
        return Pattern.compile(pattern);
    }

    private boolean anyMatch(Set<String> values) {
        return values.contains("*");
    }

    public String name() {
        return this.name;
    }

    public Set<String> transports() {
        return Collections.unmodifiableSet(this.transports);
    }

    public Set<String> hosts() {
        return Collections.unmodifiableSet(this.hosts);
    }

    public Optional<Config> getConfig() {
        return Optional.ofNullable(this.config);
    }

    public <T> Optional<? extends T> customObject(Class<? extends T> clazz) {
        return this.customObjects.getInstance(clazz);
    }

    boolean matches(String transport, String host, String path, String method) {
        return this.matchTransport(transport) && this.matchHost(host) && this.matchPath(path) && this.matchMethod(method);
    }

    boolean matchPath(String path) {
        return this.match(path, this.matchAllPaths, this.paths, this.pathPatterns);
    }

    boolean matchMethod(String method) {
        return this.matchAllMethods || method != null && this.methods.contains(method.toUpperCase());
    }

    private boolean match(String toMatch, boolean matchAll, Set<String> values, List<Pattern> patterns) {
        if (matchAll) {
            return true;
        }
        if (null == toMatch) {
            return false;
        }
        if (values.contains(toMatch)) {
            return true;
        }
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(toMatch).matches()) continue;
            return true;
        }
        return false;
    }

    boolean matchHost(String requestHost) {
        return this.match(requestHost, this.matchAllHosts, this.hosts, this.hostPatterns);
    }

    boolean matchTransport(String requestTransport) {
        if (this.matchAllTransports) {
            return true;
        }
        for (String transport : this.transports) {
            if (!requestTransport.equals(transport)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutboundTarget that = (OutboundTarget)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "TargetConfig{name='" + this.name + "', transports=" + String.valueOf(this.transports) + ", hosts=" + String.valueOf(this.hosts) + ", hostPatterns=" + String.valueOf(this.hostPatterns) + ", methods=" + String.valueOf(this.methods) + ", config=" + String.valueOf(this.config) + ", matchAllTransports=" + this.matchAllTransports + ", matchAllHosts=" + this.matchAllHosts + ", matchAllMethods=" + this.matchAllMethods + "}";
    }

    @Configured
    public static final class Builder
    implements io.helidon.common.Builder<Builder, OutboundTarget> {
        private final Set<String> transports = new HashSet<String>();
        private final Set<String> hosts = new HashSet<String>();
        private final Set<String> paths = new HashSet<String>();
        private final Set<String> methods = new HashSet<String>();
        private final ClassToInstanceStore<Object> customObjects = new ClassToInstanceStore();
        private String name;
        private Config config;

        private Builder() {
        }

        @ConfiguredOption(required=true)
        public Builder name(String name) {
            Objects.requireNonNull(name, "Outbound target name cannot be null");
            this.name = name;
            return this;
        }

        public Builder config(Config config) {
            this.config = config;
            return this;
        }

        @ConfiguredOption(key="hosts", kind=ConfiguredOption.Kind.LIST)
        public Builder addHost(String host) {
            this.hosts.add(host);
            return this;
        }

        @ConfiguredOption(key="transport", kind=ConfiguredOption.Kind.LIST)
        public Builder addTransport(String transport) {
            this.transports.add(transport);
            return this;
        }

        @ConfiguredOption(key="paths", kind=ConfiguredOption.Kind.LIST)
        public Builder addPath(String path) {
            this.paths.add(path);
            return this;
        }

        @ConfiguredOption(key="methods", kind=ConfiguredOption.Kind.LIST)
        public Builder addMethod(String method) {
            this.methods.add(method.toUpperCase());
            return this;
        }

        public <U, V extends U> Builder customObject(Class<U> objectClass, V anObject) {
            this.customObjects.putInstance(objectClass, anObject);
            return this;
        }

        public OutboundTarget build() {
            return new OutboundTarget(this);
        }
    }
}

