/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.header;

import io.helidon.config.Config;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.Subject;
import io.helidon.security.SubjectType;
import io.helidon.security.providers.common.OutboundConfig;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.providers.header.HeaderAtnOutboundConfig;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.SynchronousProvider;
import io.helidon.security.util.TokenHandler;
import java.util.HashMap;
import java.util.Optional;

public class HeaderAtnProvider
extends SynchronousProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    private final boolean optional;
    private final boolean authenticate;
    private final boolean propagate;
    private final SubjectType subjectType;
    private final TokenHandler atnTokenHandler;
    private final TokenHandler outboundTokenHandler;
    private final OutboundConfig outboundConfig;
    private final TokenHandler defaultOutboundTokenHandler;

    private HeaderAtnProvider(Builder builder) {
        this.optional = builder.optional;
        this.authenticate = builder.authenticate;
        this.propagate = builder.propagate;
        this.subjectType = builder.subjectType;
        this.atnTokenHandler = builder.atnTokenHandler;
        this.outboundTokenHandler = builder.outboundTokenHandler;
        this.outboundConfig = builder.outboundConfig;
        this.defaultOutboundTokenHandler = this.outboundTokenHandler == null ? this.atnTokenHandler : this.outboundTokenHandler;
    }

    public static HeaderAtnProvider create(Config config) {
        return HeaderAtnProvider.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected AuthenticationResponse syncAuthenticate(ProviderRequest providerRequest) {
        Optional username;
        if (!this.authenticate) {
            return AuthenticationResponse.abstain();
        }
        try {
            username = this.atnTokenHandler.extractToken(providerRequest.env().headers());
        }
        catch (Exception e) {
            if (this.optional) {
                return AuthenticationResponse.abstain();
            }
            return AuthenticationResponse.failed((String)"Header not available or in a wrong format", (Throwable)e);
        }
        return username.map(Principal::create).map(principal -> {
            if (this.subjectType == SubjectType.USER) {
                return AuthenticationResponse.success((Principal)principal);
            }
            return AuthenticationResponse.successService((Principal)principal);
        }).orElseGet(() -> {
            if (this.optional) {
                return AuthenticationResponse.abstain();
            }
            return AuthenticationResponse.failed((String)"Header not available or in a wrong format");
        });
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return this.propagate;
    }

    protected OutboundSecurityResponse syncOutbound(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundEndpointConfig) {
        Optional toPropagate = this.subjectType == SubjectType.USER ? providerRequest.securityContext().user() : providerRequest.securityContext().service();
        Optional target = this.outboundConfig.findTargetCustomObject(outboundEnv, HeaderAtnOutboundConfig.class, HeaderAtnOutboundConfig::create, HeaderAtnOutboundConfig::create);
        if (target.isEmpty()) {
            if (this.outboundTokenHandler != null) {
                return toPropagate.map(Subject::principal).map(Principal::id).map(id -> this.respond(outboundEnv, this.outboundTokenHandler, (String)id)).orElseGet(OutboundSecurityResponse::abstain);
            }
            return OutboundSecurityResponse.abstain();
        }
        HeaderAtnOutboundConfig outboundConfig = (HeaderAtnOutboundConfig)target.get();
        TokenHandler tokenHandler = outboundConfig.tokenHandler().orElse(this.defaultOutboundTokenHandler);
        return outboundConfig.explicitUser().or(() -> toPropagate.map(Subject::principal).map(Principal::id)).map(id -> this.respond(outboundEnv, tokenHandler, (String)id)).orElseGet(OutboundSecurityResponse::abstain);
    }

    private OutboundSecurityResponse respond(SecurityEnvironment outboundEnv, TokenHandler handler, String username) {
        HashMap headers = new HashMap(outboundEnv.headers());
        handler.header(headers, username);
        return OutboundSecurityResponse.withHeaders(headers);
    }

    public static final class Builder
    implements io.helidon.common.Builder<HeaderAtnProvider> {
        private final OutboundConfig.Builder outboundBuilder = OutboundConfig.builder();
        private boolean optional = false;
        private boolean authenticate = true;
        private Boolean propagate;
        private SubjectType subjectType = SubjectType.USER;
        private TokenHandler atnTokenHandler;
        private TokenHandler outboundTokenHandler;
        private OutboundConfig outboundConfig;

        private Builder() {
        }

        public HeaderAtnProvider build() {
            this.outboundConfig = this.outboundBuilder.build();
            if (this.propagate == null || this.propagate.booleanValue()) {
                this.propagate = this.outboundTokenHandler != null || this.outboundConfig.targets().size() > 0;
            }
            if (this.outboundConfig.targets().size() > 0 && this.outboundTokenHandler == null) {
                this.outboundTokenHandler = this.atnTokenHandler;
            }
            return new HeaderAtnProvider(this);
        }

        public Builder config(Config config) {
            config.get("optional").asBoolean().ifPresent(this::optional);
            config.get("authenticate").asBoolean().ifPresent(this::authenticate);
            config.get("propagate").asBoolean().ifPresent(this::propagate);
            config.get("principal-type").asString().map(SubjectType::valueOf).ifPresent(this::subjectType);
            config.get("atn-token").as(TokenHandler::create).ifPresent(this::atnTokenHandler);
            config.get("outbound-token").as(TokenHandler::create).ifPresent(this::outboundTokenHandler);
            config.get("outbound").asList(OutboundTarget::create).ifPresent(it -> it.forEach(arg_0 -> ((OutboundConfig.Builder)this.outboundBuilder).addTarget(arg_0)));
            return this;
        }

        public Builder subjectType(SubjectType subjectType) {
            this.subjectType = subjectType;
            switch (subjectType) {
                case USER: 
                case SERVICE: {
                    break;
                }
                default: {
                    throw new SecurityException("Invalid configuration. Principal type not supported: " + subjectType);
                }
            }
            return this;
        }

        public Builder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        public Builder authenticate(boolean authenticate) {
            this.authenticate = authenticate;
            return this;
        }

        public Builder atnTokenHandler(TokenHandler tokenHandler) {
            this.atnTokenHandler = tokenHandler;
            return this;
        }

        public Builder outboundTokenHandler(TokenHandler tokenHandler) {
            this.outboundTokenHandler = tokenHandler;
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder addOutboundTarget(OutboundTarget target) {
            this.outboundBuilder.addTarget(target);
            return this;
        }
    }
}

