/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.httpauth;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.security.providers.httpauth.DigestToken;
import io.helidon.security.providers.httpauth.HttpDigest;
import io.helidon.security.providers.httpauth.SecureUserStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ConfigUserStore
implements SecureUserStore {
    private final Map<String, ConfigUser> users = new HashMap<String, ConfigUser>();

    public static SecureUserStore create(Config config) {
        ConfigUserStore store = new ConfigUserStore();
        config.asNodeList().ifPresent(configs -> configs.forEach(config1 -> {
            ConfigUser user = (ConfigUser)config1.as(ConfigUser::create).get();
            store.users.put(user.login(), user);
        }));
        return store;
    }

    @Override
    public Optional<SecureUserStore.User> user(String login) {
        return Optional.ofNullable((SecureUserStore.User)this.users.get(login));
    }

    static class ConfigUser
    implements SecureUserStore.User {
        private final Set<String> roles = new LinkedHashSet<String>();
        private String login;
        private char[] password;

        ConfigUser() {
        }

        static ConfigUser create(Config config) {
            ConfigUser cu = new ConfigUser();
            cu.login = (String)config.get("login").asString().get();
            cu.password = ((String)config.get("password").asString().orElse((Object)"")).toCharArray();
            cu.roles.addAll((Collection)config.get("roles").asList(String.class).orElse((Object)CollectionsHelper.listOf()));
            return cu;
        }

        @Deprecated
        char[] password() {
            return this.password;
        }

        @Override
        public String login() {
            return this.login;
        }

        @Override
        public boolean isPasswordValid(char[] password) {
            return Arrays.equals(this.password, password);
        }

        public Set<String> roles() {
            return this.roles;
        }

        @Override
        public Optional<String> digestHa1(String realm, HttpDigest.Algorithm algorithm) {
            return Optional.of(DigestToken.ha1(algorithm, realm, this.login(), this.password()));
        }

        public String toString() {
            return "User info for \"" + this.login + "\"";
        }
    }
}

