/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.httpauth;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Grant;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Role;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.SubjectType;
import io.helidon.security.providers.httpauth.ConfigUserStore;
import io.helidon.security.providers.httpauth.HttpAuthException;
import io.helidon.security.providers.httpauth.SecureUserStore;
import io.helidon.security.providers.httpauth.spi.UserStoreService;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.SynchronousProvider;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpBasicAuthProvider
extends SynchronousProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    public static final String EP_PROPERTY_OUTBOUND_USER = "io.helidon.security.outbound.user";
    public static final String EP_PROPERTY_OUTBOUND_PASSWORD = "io.helidon.security.outbound.password";
    static final String HEADER_AUTHENTICATION_REQUIRED = "WWW-Authenticate";
    static final String HEADER_AUTHENTICATION = "authorization";
    static final String BASIC_PREFIX = "basic ";
    private static final Logger LOGGER = Logger.getLogger(HttpBasicAuthProvider.class.getName());
    private static final Pattern CREDENTIAL_PATTERN = Pattern.compile("(.*):(.*)");
    private static final char[] EMPTY_PASSWORD = new char[0];
    private final List<SecureUserStore> userStores;
    private final String realm;
    private final SubjectType subjectType;

    HttpBasicAuthProvider(Builder builder) {
        this.userStores = new LinkedList<SecureUserStore>(builder.userStores);
        this.realm = builder.realm;
        this.subjectType = builder.subjectType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HttpBasicAuthProvider create(Config config) {
        return HttpBasicAuthProvider.builder().config(config).build();
    }

    private static OutboundSecurityResponse toBasicAuthOutbound(String username, char[] password) {
        String b64 = Base64.getEncoder().encodeToString((username + ":" + new String(password)).getBytes(StandardCharsets.UTF_8));
        String basicAuthB64 = BASIC_PREFIX + b64;
        return OutboundSecurityResponse.withHeaders((Map)CollectionsHelper.mapOf((Object)"Authorization", (Object)CollectionsHelper.listOf((Object[])new String[]{basicAuthB64})));
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outbondEnv, EndpointConfig outboundEp) {
        if (outboundEp.abacAttributeNames().contains(EP_PROPERTY_OUTBOUND_USER)) {
            return true;
        }
        SecurityContext secContext = providerRequest.securityContext();
        boolean userSupported = secContext.user().flatMap(user -> user.privateCredential(BasicPrivateCredentials.class)).isPresent();
        boolean serviceSupported = secContext.service().map(user -> user.privateCredential(BasicPrivateCredentials.class)).isPresent();
        return userSupported || serviceSupported;
    }

    protected OutboundSecurityResponse syncOutbound(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundEp) {
        Optional maybeUsername = outboundEp.abacAttribute(EP_PROPERTY_OUTBOUND_USER);
        if (maybeUsername.isPresent()) {
            String username = maybeUsername.get().toString();
            char[] password = this.passwordFromEndpoint(outboundEp);
            return HttpBasicAuthProvider.toBasicAuthOutbound(username, password);
        }
        SecurityContext secContext = providerRequest.securityContext();
        Optional<OutboundSecurityResponse> creds = secContext.user().flatMap(this::credentialsFromSubject);
        if (!creds.isPresent()) {
            creds = secContext.service().flatMap(this::credentialsFromSubject);
        }
        Optional<char[]> overridePassword = outboundEp.abacAttribute(EP_PROPERTY_OUTBOUND_PASSWORD).map(String::valueOf).map(String::toCharArray);
        return creds.map(credentials -> {
            char[] password = overridePassword.orElse(((BasicPrivateCredentials)credentials).password);
            return HttpBasicAuthProvider.toBasicAuthOutbound(((BasicPrivateCredentials)credentials).username, password);
        }).orElseGet(OutboundSecurityResponse::abstain);
    }

    private Optional<BasicPrivateCredentials> credentialsFromSubject(Subject subject) {
        return subject.privateCredential(BasicPrivateCredentials.class);
    }

    private char[] passwordFromEndpoint(EndpointConfig outboundEp) {
        return outboundEp.abacAttribute(EP_PROPERTY_OUTBOUND_PASSWORD).map(String::valueOf).map(String::toCharArray).orElse(EMPTY_PASSWORD);
    }

    protected AuthenticationResponse syncAuthenticate(ProviderRequest providerRequest) {
        Map headers = providerRequest.env().headers();
        List authorizationHeader = (List)headers.get(HEADER_AUTHENTICATION);
        if (null == authorizationHeader) {
            return this.fail("No authorization header");
        }
        return authorizationHeader.stream().filter(header -> header.toLowerCase().startsWith(BASIC_PREFIX)).findFirst().map(this::validateBasicAuth).orElseGet(() -> this.fail("Authorization header does not contain basic authentication: " + authorizationHeader));
    }

    private AuthenticationResponse validateBasicAuth(String basicAuthHeader) {
        SecureUserStore userStore;
        String usernameAndPassword;
        String b64 = basicAuthHeader.substring(BASIC_PREFIX.length());
        try {
            usernameAndPassword = new String(Base64.getDecoder().decode(b64), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return this.fail("Basic authentication header with invalid content - not base64 encoded");
        }
        Matcher matcher = CREDENTIAL_PATTERN.matcher(usernameAndPassword);
        if (!matcher.matches()) {
            LOGGER.finest(() -> "Basic authentication header with invalid content: " + usernameAndPassword);
            return this.fail("Basic authentication header with invalid content");
        }
        String username = matcher.group(1);
        char[] password = matcher.group(2).toCharArray();
        Optional<Object> foundUser = Optional.empty();
        Iterator<SecureUserStore> iterator = this.userStores.iterator();
        while (iterator.hasNext() && !(foundUser = (userStore = iterator.next()).user(username)).isPresent()) {
        }
        return foundUser.map(user -> {
            if (user.isPasswordValid(password)) {
                if (this.subjectType == SubjectType.USER) {
                    return AuthenticationResponse.success((Subject)this.buildSubject((SecureUserStore.User)user, password));
                }
                return AuthenticationResponse.successService((Subject)this.buildSubject((SecureUserStore.User)user, password));
            }
            return this.invalidUser();
        }).orElseGet(this::invalidUser);
    }

    private AuthenticationResponse invalidUser() {
        return this.fail("Invalid username or password");
    }

    private AuthenticationResponse fail(String message) {
        return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().statusCode(401)).responseHeader(HEADER_AUTHENTICATION_REQUIRED, this.buildChallenge())).status(SecurityResponse.SecurityStatus.FAILURE)).description(message)).build();
    }

    private String buildChallenge() {
        return "Basic realm=\"" + this.realm + "\"";
    }

    private Subject buildSubject(SecureUserStore.User user, char[] password) {
        Subject.Builder builder = Subject.builder().principal(Principal.builder().name(user.login()).build()).addPrivateCredential(BasicPrivateCredentials.class, (Object)new BasicPrivateCredentials(user.login(), password));
        user.roles().forEach(role -> builder.addGrant((Grant)Role.create((String)role)));
        return builder.build();
    }

    private static final class BasicPrivateCredentials {
        private final String username;
        private final char[] password;

        private BasicPrivateCredentials(String username, char[] password) {
            this.username = username;
            this.password = password;
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<HttpBasicAuthProvider> {
        private List<SecureUserStore> userStores = new LinkedList<SecureUserStore>();
        private String realm = "helidon";
        private SubjectType subjectType = SubjectType.USER;

        private Builder() {
        }

        public Builder config(Config config) {
            config.get("realm").asString().ifPresent(this::realm);
            config.get("principal-type").asString().as(SubjectType::valueOf).ifPresent(this::subjectType);
            HelidonServiceLoader.Builder loader = HelidonServiceLoader.builder(ServiceLoader.load(UserStoreService.class));
            final Config usersConfig = config.get("users");
            if (usersConfig.exists() && !usersConfig.isLeaf()) {
                loader.addService((Object)new UserStoreService(){

                    @Override
                    public String configKey() {
                        return "users";
                    }

                    @Override
                    public SecureUserStore create(Config config) {
                        return (SecureUserStore)usersConfig.as(ConfigUserStore::create).orElseThrow(() -> new HttpAuthException("No users configured! Key \"users\" must be in configuration"));
                    }
                });
            }
            loader.build().forEach(userStoreService -> this.addUserStore(userStoreService.create(config.get(userStoreService.configKey()))));
            return this;
        }

        public HttpBasicAuthProvider build() {
            return new HttpBasicAuthProvider(this);
        }

        public Builder subjectType(SubjectType subjectType) {
            this.subjectType = subjectType;
            switch (subjectType) {
                case USER: 
                case SERVICE: {
                    break;
                }
                default: {
                    throw new SecurityException("Invalid configuration. Principal type not supported: " + subjectType);
                }
            }
            return this;
        }

        public Builder addUserStore(SecureUserStore store) {
            this.userStores.add(store);
            return this;
        }

        public Builder userStore(SecureUserStore store) {
            this.userStores.clear();
            this.userStores.add(store);
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            return this;
        }
    }
}

