/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.httpauth;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Grant;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Role;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.SubjectType;
import io.helidon.security.providers.common.OutboundConfig;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.providers.httpauth.ConfigUserStore;
import io.helidon.security.providers.httpauth.HttpAuthException;
import io.helidon.security.providers.httpauth.HttpBasicOutboundConfig;
import io.helidon.security.providers.httpauth.SecureUserStore;
import io.helidon.security.providers.httpauth.spi.UserStoreService;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.SecurityProvider;
import io.helidon.security.spi.SynchronousProvider;
import io.helidon.security.util.TokenHandler;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpBasicAuthProvider
extends SynchronousProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    @Deprecated(since="3.2.3", forRemoval=true)
    public static final String EP_PROPERTY_OUTBOUND_USER = "io.helidon.security.outbound.user";
    @Deprecated(since="3.2.3", forRemoval=true)
    public static final String EP_PROPERTY_OUTBOUND_PASSWORD = "io.helidon.security.outbound.password";
    static final String HEADER_AUTHENTICATION_REQUIRED = "WWW-Authenticate";
    static final String HEADER_AUTHENTICATION = "authorization";
    static final String BASIC_PREFIX = "basic ";
    private static final Logger LOGGER = Logger.getLogger(HttpBasicAuthProvider.class.getName());
    static final Pattern CREDENTIAL_PATTERN = Pattern.compile("(.*?):(.*)");
    private final List<SecureUserStore> userStores;
    private final boolean optional;
    private final String realm;
    private final SubjectType subjectType;
    private final OutboundConfig outboundConfig;
    private final boolean outboundTargetsExist;

    HttpBasicAuthProvider(Builder builder) {
        this.userStores = new LinkedList<SecureUserStore>(builder.userStores);
        this.optional = builder.optional;
        this.realm = builder.realm;
        this.subjectType = builder.subjectType;
        this.outboundConfig = builder.outboundBuilder.build();
        this.outboundTargetsExist = this.outboundConfig.targets().size() > 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HttpBasicAuthProvider create(Config config) {
        return HttpBasicAuthProvider.builder().config(config).build();
    }

    private static OutboundSecurityResponse toBasicAuthOutbound(SecurityEnvironment outboundEnv, TokenHandler tokenHandler, String username, char[] password) {
        String b64 = Base64.getEncoder().encodeToString((username + ":" + new String(password)).getBytes(StandardCharsets.UTF_8));
        HashMap headers = new HashMap(outboundEnv.headers());
        tokenHandler.addHeader(headers, b64);
        return OutboundSecurityResponse.withHeaders(headers);
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outbondEnv, EndpointConfig outboundEp) {
        if (outboundEp.abacAttributeNames().contains(EP_PROPERTY_OUTBOUND_USER)) {
            return true;
        }
        return this.outboundTargetsExist;
    }

    protected OutboundSecurityResponse syncOutbound(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundEp) {
        Optional maybeUsername = outboundEp.abacAttribute(EP_PROPERTY_OUTBOUND_USER);
        if (maybeUsername.isPresent()) {
            String username = maybeUsername.get().toString();
            char[] password = this.passwordFromEndpoint(outboundEp);
            return HttpBasicAuthProvider.toBasicAuthOutbound(outboundEnv, HttpBasicOutboundConfig.DEFAULT_TOKEN_HANDLER, username, password);
        }
        Optional target = this.outboundConfig.findTargetCustomObject(outboundEnv, HttpBasicOutboundConfig.class, HttpBasicOutboundConfig::create, HttpBasicOutboundConfig::create);
        if (target.isEmpty()) {
            return OutboundSecurityResponse.abstain();
        }
        HttpBasicOutboundConfig outboundConfig = (HttpBasicOutboundConfig)target.get();
        if (outboundConfig.hasExplicitUser()) {
            return HttpBasicAuthProvider.toBasicAuthOutbound(outboundEnv, outboundConfig.tokenHandler(), outboundConfig.explicitUser(), outboundConfig.explicitPassword());
        }
        SecurityContext secContext = providerRequest.securityContext();
        Optional<OutboundSecurityResponse> creds = secContext.user().flatMap(this::credentialsFromSubject);
        if (creds.isEmpty()) {
            creds = secContext.service().flatMap(this::credentialsFromSubject);
        }
        Optional<char[]> overridePassword = outboundEp.abacAttribute(EP_PROPERTY_OUTBOUND_PASSWORD).map(String::valueOf).map(String::toCharArray);
        return creds.map(credentials -> {
            char[] password = overridePassword.orElse(credentials.password);
            return HttpBasicAuthProvider.toBasicAuthOutbound(outboundEnv, outboundConfig.tokenHandler(), credentials.username, password);
        }).orElseGet(OutboundSecurityResponse::abstain);
    }

    private Optional<BasicPrivateCredentials> credentialsFromSubject(Subject subject) {
        return subject.privateCredential(BasicPrivateCredentials.class);
    }

    private char[] passwordFromEndpoint(EndpointConfig outboundEp) {
        return outboundEp.abacAttribute(EP_PROPERTY_OUTBOUND_PASSWORD).map(String::valueOf).map(String::toCharArray).orElse(HttpBasicOutboundConfig.EMPTY_PASSWORD);
    }

    protected AuthenticationResponse syncAuthenticate(ProviderRequest providerRequest) {
        Map headers = providerRequest.env().headers();
        List authorizationHeader = (List)headers.get(HEADER_AUTHENTICATION);
        if (null == authorizationHeader) {
            return this.failOrAbstain("No authorization header");
        }
        return authorizationHeader.stream().filter(header -> header.toLowerCase().startsWith(BASIC_PREFIX)).findFirst().map(this::validateBasicAuth).orElseGet(() -> this.failOrAbstain("Authorization header does not contain basic authentication: " + authorizationHeader));
    }

    private AuthenticationResponse validateBasicAuth(String basicAuthHeader) {
        SecureUserStore userStore;
        String usernameAndPassword;
        String b64 = basicAuthHeader.substring(BASIC_PREFIX.length());
        try {
            usernameAndPassword = new String(Base64.getDecoder().decode(b64), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return this.failOrAbstain("Basic authentication header with invalid content - not base64 encoded");
        }
        Matcher matcher = CREDENTIAL_PATTERN.matcher(usernameAndPassword);
        if (!matcher.matches()) {
            LOGGER.finest(() -> "Basic authentication header with invalid content: " + usernameAndPassword);
            return this.failOrAbstain("Basic authentication header with invalid content");
        }
        String username = matcher.group(1);
        char[] password = matcher.group(2).toCharArray();
        Optional<Object> foundUser = Optional.empty();
        Iterator<SecureUserStore> iterator = this.userStores.iterator();
        while (iterator.hasNext() && !(foundUser = (userStore = iterator.next()).user(username)).isPresent()) {
        }
        return foundUser.map(user -> {
            if (user.isPasswordValid(password)) {
                if (this.subjectType == SubjectType.USER) {
                    return AuthenticationResponse.success((Subject)this.buildSubject((SecureUserStore.User)user, password));
                }
                return AuthenticationResponse.successService((Subject)this.buildSubject((SecureUserStore.User)user, password));
            }
            return this.invalidUser();
        }).orElseGet(this::invalidUser);
    }

    private AuthenticationResponse invalidUser() {
        return this.failOrAbstain("Invalid username or password");
    }

    private AuthenticationResponse failOrAbstain(String message) {
        if (this.optional) {
            return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.ABSTAIN)).description(message)).build();
        }
        return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().statusCode(401)).responseHeader(HEADER_AUTHENTICATION_REQUIRED, this.buildChallenge())).status(SecurityResponse.SecurityStatus.FAILURE)).description(message)).build();
    }

    private String buildChallenge() {
        return "Basic realm=\"" + this.realm + "\"";
    }

    private Subject buildSubject(SecureUserStore.User user, char[] password) {
        Subject.Builder builder = Subject.builder().principal(Principal.builder().name(user.login()).build()).addPrivateCredential(BasicPrivateCredentials.class, (Object)new BasicPrivateCredentials(user.login(), password));
        user.roles().forEach(role -> builder.addGrant((Grant)Role.create((String)role)));
        return builder.build();
    }

    @Configured(prefix="http-basic-auth", description="HTTP Basic Authentication provider", provides={SecurityProvider.class, AuthenticationProvider.class})
    public static final class Builder
    implements io.helidon.common.Builder<Builder, HttpBasicAuthProvider> {
        private final List<SecureUserStore> userStores = new LinkedList<SecureUserStore>();
        private final OutboundConfig.Builder outboundBuilder = OutboundConfig.builder();
        private boolean optional = false;
        private String realm = "helidon";
        private SubjectType subjectType = SubjectType.USER;

        private Builder() {
        }

        public Builder config(Config config) {
            config.get("optional").asBoolean().ifPresent(this::optional);
            config.get("realm").asString().ifPresent(this::realm);
            config.get("principal-type").asString().as(SubjectType::valueOf).ifPresent(this::subjectType);
            HelidonServiceLoader.Builder loader = HelidonServiceLoader.builder(ServiceLoader.load(UserStoreService.class));
            final Config usersConfig = config.get("users");
            if (usersConfig.exists() && !usersConfig.isLeaf()) {
                loader.addService((Object)new UserStoreService(){

                    @Override
                    public String configKey() {
                        return "users";
                    }

                    @Override
                    public SecureUserStore create(Config config) {
                        return (SecureUserStore)usersConfig.as(ConfigUserStore::create).orElseThrow(() -> new HttpAuthException("No users configured! Key \"users\" must be in configuration"));
                    }
                });
            }
            loader.build().forEach(userStoreService -> this.addUserStore(userStoreService.create(config.get(userStoreService.configKey()))));
            config.get("outbound").asList(OutboundTarget::create).ifPresent(it -> it.forEach(arg_0 -> ((OutboundConfig.Builder)this.outboundBuilder).addTarget(arg_0)));
            return this;
        }

        public HttpBasicAuthProvider build() {
            return new HttpBasicAuthProvider(this);
        }

        public Builder subjectType(SubjectType subjectType) {
            this.subjectType = subjectType;
            switch (subjectType) {
                case USER: 
                case SERVICE: {
                    break;
                }
                default: {
                    throw new SecurityException("Invalid configuration. Principal type not supported: " + subjectType);
                }
            }
            return this;
        }

        public Builder addUserStore(SecureUserStore store) {
            this.userStores.add(store);
            return this;
        }

        public Builder userStore(SecureUserStore store) {
            this.userStores.clear();
            this.userStores.add(store);
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder addOutboundTarget(OutboundTarget target) {
            this.outboundBuilder.addTarget(target);
            return this;
        }
    }

    private static final class BasicPrivateCredentials {
        private final String username;
        private final char[] password;

        private BasicPrivateCredentials(String username, char[] password) {
            this.username = username;
            this.password = password;
        }
    }
}

