/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.httpsign;

import io.helidon.config.Config;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.SubjectType;
import io.helidon.security.providers.common.OutboundConfig;
import io.helidon.security.providers.httpsign.HttpSignHeader;
import io.helidon.security.providers.httpsign.HttpSignature;
import io.helidon.security.providers.httpsign.HttpSignatureException;
import io.helidon.security.providers.httpsign.InboundClientDefinition;
import io.helidon.security.providers.httpsign.OutboundTargetDefinition;
import io.helidon.security.providers.httpsign.SignedHeadersConfig;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class HttpSignProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    static final String ALGORITHM_HMAC = "hmac-sha256";
    static final String ALGORITHM_RSA = "rsa-sha256";
    static final SignedHeadersConfig DEFAULT_REQUIRED_HEADERS = SignedHeadersConfig.builder().defaultConfig(SignedHeadersConfig.HeadersConfig.create(List.of("date", "(request-target)"))).config("get", SignedHeadersConfig.HeadersConfig.create(List.of("date", "(request-target)", "host"), List.of("authorization"))).config("head", SignedHeadersConfig.HeadersConfig.create(List.of("date", "(request-target)", "host"), List.of("authorization"))).config("delete", SignedHeadersConfig.HeadersConfig.create(List.of("date", "(request-target)", "host"), List.of("authorization"))).config("put", SignedHeadersConfig.HeadersConfig.create(List.of("date", "(request-target)", "host"), List.of("authorization"))).config("post", SignedHeadersConfig.HeadersConfig.create(List.of("date", "(request-target)", "host"), List.of("authorization"))).build();
    static final String ATTRIB_NAME_KEY_ID = HttpSignProvider.class.getName() + ".keyId";
    private final boolean optional;
    private final String realm;
    private final Set<HttpSignHeader> acceptHeaders;
    private final SignedHeadersConfig inboundRequiredHeaders;
    private final Map<String, InboundClientDefinition> inboundKeys;
    private final OutboundConfig outboundConfig;
    private final Map<String, OutboundTargetDefinition> targetKeys = new HashMap<String, OutboundTargetDefinition>();
    private final boolean backwardCompatibleEol;

    private HttpSignProvider(Builder builder) {
        this.optional = builder.optional;
        this.realm = builder.realm;
        this.acceptHeaders = builder.acceptHeaders.isEmpty() ? EnumSet.of(HttpSignHeader.SIGNATURE, HttpSignHeader.AUTHORIZATION) : EnumSet.copyOf(builder.acceptHeaders);
        this.inboundRequiredHeaders = builder.inboundRequiredHeaders;
        this.inboundKeys = builder.inboundKeys;
        this.outboundConfig = builder.outboundConfig;
        this.backwardCompatibleEol = builder.backwardCompatibleEol;
        this.outboundConfig.targets().forEach(target -> target.getConfig().ifPresent(targetConfig -> {
            OutboundTargetDefinition outboundTargetDefinition = (OutboundTargetDefinition)targetConfig.get("signature").as(OutboundTargetDefinition::create).get();
            this.targetKeys.put(target.name(), outboundTargetDefinition);
        }));
    }

    public static HttpSignProvider create(Config config) {
        return HttpSignProvider.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompletionStage<AuthenticationResponse> authenticate(ProviderRequest providerRequest) {
        Map headers = providerRequest.env().headers();
        if (headers.get("Signature") != null && this.acceptHeaders.contains((Object)HttpSignHeader.SIGNATURE)) {
            return CompletableFuture.supplyAsync(() -> this.signatureHeader((List)headers.get("Signature"), providerRequest.env()), providerRequest.securityContext().executorService());
        }
        if (headers.get("Authorization") != null && this.acceptHeaders.contains((Object)HttpSignHeader.AUTHORIZATION)) {
            return CompletableFuture.supplyAsync(() -> this.authorizeHeader(providerRequest.env()), providerRequest.securityContext().executorService());
        }
        if (this.optional) {
            return CompletableFuture.completedFuture(AuthenticationResponse.abstain());
        }
        return CompletableFuture.completedFuture(AuthenticationResponse.failed((String)("Missing header. Accepted headers: " + this.acceptHeaders)));
    }

    private AuthenticationResponse authorizeHeader(SecurityEnvironment env) {
        List authorization = (List)env.headers().get("Authorization");
        AuthenticationResponse response = null;
        for (String authorizationValue : authorization) {
            if (!authorizationValue.toLowerCase().startsWith("signature ") || !(response = this.signatureHeader(List.of(authorizationValue.substring("singature ".length())), env)).status().isSuccess()) continue;
            return response;
        }
        if (this.optional) {
            return AuthenticationResponse.abstain();
        }
        return this.challenge(env, null == response ? "No Signature authorization header" : response.description().orElse("Unknown problem"));
    }

    private AuthenticationResponse challenge(SecurityEnvironment env, String description) {
        return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().responseHeader("WWW-Authenticate", "Signature realm=\"" + this.realm + ",headers=\"" + this.headersForMethod(env.method()) + "\"")).status(SecurityResponse.SecurityStatus.FAILURE)).statusCode(401)).description(description)).build();
    }

    private String headersForMethod(String method) {
        return String.join((CharSequence)" ", this.inboundRequiredHeaders.headers(method.toLowerCase()));
    }

    private AuthenticationResponse signatureHeader(List<String> signatures, SecurityEnvironment env) {
        Object lastError = signatures.isEmpty() ? "No signature values for Signature header" : null;
        for (String signature : signatures) {
            HttpSignature httpSignature = HttpSignature.fromHeader(signature, this.backwardCompatibleEol);
            Optional<String> validate = httpSignature.validate();
            if (validate.isPresent()) {
                lastError = validate.get();
                continue;
            }
            InboundClientDefinition clientDefinition = this.inboundKeys.get(httpSignature.getKeyId());
            if (null == clientDefinition) {
                lastError = "Client definition for client with key " + httpSignature.getKeyId() + " not found";
                continue;
            }
            return this.validateSignature(env, httpSignature, clientDefinition);
        }
        if (this.optional) {
            return AuthenticationResponse.abstain();
        }
        return AuthenticationResponse.failed((String)lastError);
    }

    private AuthenticationResponse validateSignature(SecurityEnvironment env, HttpSignature httpSignature, InboundClientDefinition clientDefinition) {
        Optional<String> validationResult = httpSignature.validate(env, clientDefinition, this.inboundRequiredHeaders.headers(env.method(), env.headers()));
        if (validationResult.isPresent()) {
            return AuthenticationResponse.failed((String)validationResult.get());
        }
        Principal principal = Principal.builder().name(clientDefinition.principalName()).addAttribute(ATTRIB_NAME_KEY_ID, (Object)clientDefinition.keyId()).build();
        Subject subject = Subject.builder().principal(principal).build();
        if (clientDefinition.subjectType() == SubjectType.USER) {
            return AuthenticationResponse.success((Subject)subject);
        }
        return AuthenticationResponse.successService((Subject)subject);
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return this.outboundConfig.findTarget(outboundEnv).isPresent();
    }

    public CompletionStage<OutboundSecurityResponse> outboundSecurity(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return CompletableFuture.supplyAsync(() -> this.signRequest(outboundEnv), providerRequest.securityContext().executorService());
    }

    private OutboundSecurityResponse signRequest(SecurityEnvironment outboundEnv) {
        Optional targetOpt = this.outboundConfig.findTarget(outboundEnv);
        return targetOpt.map(target -> {
            Map<String, List> headers;
            OutboundTargetDefinition targetConfig = this.targetKeys.computeIfAbsent(target.name(), key -> target.getConfig().flatMap(config -> config.get("signature").as(OutboundTargetDefinition.class).asOptional()).orElse((OutboundTargetDefinition)target.customObject(OutboundTargetDefinition.class).orElseThrow(() -> new HttpSignatureException("Failed to find configuration for outbound signatures for target " + target.name()))));
            TreeMap<String, List<String>> newHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            newHeaders.putAll(outboundEnv.headers());
            HttpSignature signature = HttpSignature.sign(outboundEnv, targetConfig, newHeaders, targetConfig.backwardCompatibleEol());
            OutboundSecurityResponse.Builder builder = (OutboundSecurityResponse.Builder)((OutboundSecurityResponse.Builder)OutboundSecurityResponse.builder().requestHeaders(newHeaders)).status(SecurityResponse.SecurityStatus.SUCCESS);
            switch (targetConfig.header()) {
                case SIGNATURE: {
                    builder.requestHeader("Signature", signature.toSignatureHeader());
                    break;
                }
                case AUTHORIZATION: {
                    builder.requestHeader("Authorization", "Signature " + signature.toSignatureHeader());
                    break;
                }
                case CUSTOM: {
                    headers = new HashMap();
                    targetConfig.tokenHandler().addHeader(headers, signature.toSignatureHeader());
                    headers.forEach((x$0, x$1) -> {
                        OutboundSecurityResponse.Builder cfr_ignored_0 = (OutboundSecurityResponse.Builder)builder.requestHeader(x$0, x$1);
                    });
                    break;
                }
                default: {
                    throw new HttpSignatureException("Invalid header configuration: " + targetConfig.header());
                }
            }
            headers = outboundEnv.headers();
            if (headers.containsKey("host")) {
                builder.requestHeader("host", (List)headers.get("host"));
            }
            if (headers.containsKey("date")) {
                builder.requestHeader("date", (List)headers.get("date"));
            }
            return builder.build();
        }).orElse(OutboundSecurityResponse.empty());
    }

    public static final class Builder
    implements io.helidon.common.Builder<HttpSignProvider> {
        private boolean optional = true;
        private String realm = "helidon";
        private final Set<HttpSignHeader> acceptHeaders = EnumSet.noneOf(HttpSignHeader.class);
        private SignedHeadersConfig inboundRequiredHeaders = SignedHeadersConfig.builder().build();
        private OutboundConfig outboundConfig = OutboundConfig.builder().build();
        private final Map<String, InboundClientDefinition> inboundKeys = new HashMap<String, InboundClientDefinition>();
        @Deprecated
        private boolean backwardCompatibleEol = true;

        private Builder() {
        }

        public HttpSignProvider build() {
            return new HttpSignProvider(this);
        }

        public Builder config(Config config) {
            config.get("headers").asList(HttpSignHeader.class).ifPresent(list -> list.forEach(this::addAcceptHeader));
            config.get("optional").asBoolean().ifPresent(this::optional);
            config.get("realm").asString().ifPresent(this::realm);
            config.get("sign-headers").as(SignedHeadersConfig::create).ifPresent(this::inboundRequiredHeaders);
            this.outboundConfig = OutboundConfig.create((Config)config);
            config.get("inbound.keys").asList(InboundClientDefinition::create).ifPresent(list -> list.forEach(inbound -> this.inboundKeys.put(inbound.keyId(), (InboundClientDefinition)inbound)));
            config.get("backward-compatible-eol").asBoolean().ifPresent(this::backwardCompatibleEol);
            return this;
        }

        public Builder outbound(OutboundConfig targets) {
            this.outboundConfig = targets;
            return this;
        }

        public Builder addInbound(InboundClientDefinition client) {
            this.inboundKeys.put(client.keyId(), client);
            return this;
        }

        public Builder inboundRequiredHeaders(SignedHeadersConfig inboundRequiredHeaders) {
            this.inboundRequiredHeaders = inboundRequiredHeaders;
            return this;
        }

        public Builder addAcceptHeader(HttpSignHeader header) {
            this.acceptHeaders.add(header);
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder backwardCompatibleEol(Boolean backwardCompatible) {
            this.backwardCompatibleEol = backwardCompatible;
            return this;
        }
    }
}

