/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.httpsign;

import io.helidon.common.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.config.metadata.ConfiguredOptions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class SignedHeadersConfig {
    public static final String REQUEST_TARGET = "(request-target)";
    private final HeadersConfig defaultConfig;
    private final Map<String, HeadersConfig> methodConfigs;

    private SignedHeadersConfig(Builder builder) {
        this.defaultConfig = builder.defaultConfig;
        this.methodConfigs = new TreeMap<String, HeadersConfig>(String.CASE_INSENSITIVE_ORDER);
        this.methodConfigs.putAll(builder.methodConfigs);
    }

    public static SignedHeadersConfig create(Config config) {
        Builder builder = SignedHeadersConfig.builder();
        ((List)config.asNodeList().get()).forEach(methodConfig -> {
            HeadersConfig mc = HeadersConfig.create(methodConfig);
            methodConfig.get("method").asString().ifPresentOrElse(method -> builder.config((String)method, mc), () -> builder.defaultConfig(mc));
        });
        return builder.build();
    }

    public static Builder builder() {
        return new Builder().defaultConfig(HeadersConfig.create());
    }

    public List<String> headers(String method, Map<String, List<String>> transportHeaders) {
        return this.methodConfigs.getOrDefault(method, this.defaultConfig).getHeaders(transportHeaders);
    }

    public List<String> headers(String method) {
        return new ArrayList<String>(this.methodConfigs.getOrDefault((Object)method, (HeadersConfig)this.defaultConfig).always);
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, SignedHeadersConfig> {
        private static final HeadersConfig DEFAULT_HEADERS = HeadersConfig.create(List.of("date"));
        private final Map<String, HeadersConfig> methodConfigs = new TreeMap<String, HeadersConfig>(String.CASE_INSENSITIVE_ORDER);
        private HeadersConfig defaultConfig = DEFAULT_HEADERS;

        private Builder() {
        }

        public SignedHeadersConfig build() {
            return new SignedHeadersConfig(this);
        }

        public Builder defaultConfig(HeadersConfig config) {
            this.defaultConfig = config;
            return this;
        }

        public Builder config(String method, HeadersConfig config) {
            this.methodConfigs.put(method, config);
            return this;
        }
    }

    @Configured
    public static final class HeadersConfig {
        private final List<String> always;
        private final List<String> ifPresent;

        private HeadersConfig(List<String> requiredHeaders, List<String> ifPresentHeaders) {
            this.always = new ArrayList<String>(requiredHeaders);
            this.ifPresent = new LinkedList<String>(ifPresentHeaders);
        }

        public static HeadersConfig create() {
            return HeadersConfig.create(List.of());
        }

        public static HeadersConfig create(List<String> requiredHeaders) {
            return HeadersConfig.create(requiredHeaders, List.of());
        }

        public static HeadersConfig create(List<String> requiredHeaders, List<String> ifPresentHeaders) {
            return new HeadersConfig(requiredHeaders, ifPresentHeaders);
        }

        @ConfiguredOptions(value={@ConfiguredOption(key="always", type=String.class, kind=ConfiguredOption.Kind.LIST, description="Headers that must be signed (and signature validation or creation should fail if not signed or present)"), @ConfiguredOption(key="if-present", type=String.class, kind=ConfiguredOption.Kind.LIST, description="Headers that must be signed if present in request."), @ConfiguredOption(key="method", type=String.class, description="HTTP method this header configuration is bound to. If not present, it is considered default header configuration.")})
        public static HeadersConfig create(Config config) {
            return HeadersConfig.create((List)config.get("always").asList(String.class).orElse(List.of()), (List)config.get("if-present").asList(String.class).orElse(List.of()));
        }

        List<String> getHeaders(Map<String, List<String>> transportHeaders) {
            ArrayList<String> result = new ArrayList<String>(this.always);
            this.ifPresent.stream().filter(transportHeaders::containsKey).forEach(result::add);
            return result;
        }
    }
}

