/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.Errors;
import io.helidon.common.LazyValue;
import io.helidon.common.http.Http;
import io.helidon.common.http.SetCookie;
import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.security.SecurityException;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.providers.oidc.common.BaseBuilder;
import io.helidon.security.providers.oidc.common.OidcCookieHandler;
import io.helidon.security.providers.oidc.common.OidcUtil;
import io.helidon.security.providers.oidc.common.Tenant;
import io.helidon.security.providers.oidc.common.TenantConfig;
import io.helidon.security.providers.oidc.common.TenantConfigImpl;
import io.helidon.security.util.TokenHandler;
import io.helidon.webclient.WebClient;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webserver.cors.CrossOriginConfig;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.json.JsonObject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;

public final class OidcConfig
extends TenantConfigImpl {
    public static final String PARAM_HEADER_NAME = "X_OIDC_TOKEN_HEADER";
    public static final String DEFAULT_TENANT_PARAM_NAME = "h_tenant";
    static final String DEFAULT_REDIRECT_URI = "/oidc/redirect";
    static final String DEFAULT_LOGOUT_URI = "/oidc/logout";
    static final boolean DEFAULT_REDIRECT = true;
    static final String DEFAULT_ATTEMPT_PARAM = "h_ra";
    static final int DEFAULT_MAX_REDIRECTS = 5;
    static final boolean DEFAULT_FORCE_HTTPS_REDIRECTS = false;
    static final Duration DEFAULT_TOKEN_REFRESH_SKEW = Duration.ofSeconds(5L);
    static final boolean DEFAULT_RELATIVE_URIS = false;
    static final int DEFAULT_PROXY_PORT = 80;
    static final String DEFAULT_PROXY_PROTOCOL = "http";
    static final String TENANT_IDENT = "name";
    static final String DEFAULT_PARAM_NAME = "accessToken";
    static final boolean DEFAULT_PARAM_USE = false;
    static final boolean DEFAULT_HEADER_USE = false;
    static final boolean DEFAULT_COOKIE_USE = true;
    static final String DEFAULT_COOKIE_NAME = "JSESSIONID";
    static final String DEFAULT_TENANT_COOKIE_NAME = "HELIDON_TENANT";
    private static final Logger LOGGER = Logger.getLogger(OidcConfig.class.getName());
    private final Map<String, TenantConfig> tenantConfigurations;
    private final String redirectUri;
    private final String logoutUri;
    private final boolean logoutEnabled;
    private final String frontendUri;
    private final boolean redirect;
    private final String redirectAttemptParam;
    private final int maxRedirects;
    private final URI postLogoutUri;
    private final CrossOriginConfig crossOriginConfig;
    private final boolean forceHttpsRedirects;
    private final Duration tokenRefreshSkew;
    private final boolean relativeUris;
    private final Client generalClient;
    private final WebClient webClient;
    private final LazyValue<Optional<WebTarget>> introspectEndpoint;
    private final Supplier<WebClient.Builder> webClientBuilderSupplier;
    private final Supplier<ClientBuilder> jaxrsClientBuilderSupplier;
    private final LazyValue<Tenant> defaultTenant;
    private final boolean useParam;
    private final String paramName;
    private final String tenantParamName;
    private final boolean useHeader;
    private final TokenHandler headerHandler;
    private final boolean useCookie;
    private final OidcCookieHandler tokenCookieHandler;
    private final OidcCookieHandler idTokenCookieHandler;
    private final OidcCookieHandler tenantCookieHandler;

    private OidcConfig(Builder builder) {
        super(builder);
        this.frontendUri = builder.frontendUri;
        this.redirectUri = builder.redirectUri;
        this.logoutUri = builder.logoutUri;
        this.logoutEnabled = builder.logoutEnabled;
        this.postLogoutUri = builder.postLogoutUri;
        this.redirect = builder.redirect;
        this.redirectAttemptParam = builder.redirectAttemptParam;
        this.maxRedirects = builder.maxRedirects;
        this.forceHttpsRedirects = builder.forceHttpsRedirects;
        this.crossOriginConfig = builder.crossOriginConfig;
        this.tokenRefreshSkew = builder.tokenRefreshSkew;
        this.tenantConfigurations = Map.copyOf(builder.tenantConfigurations);
        this.webClient = builder.webClient;
        this.generalClient = builder.generalClient;
        this.relativeUris = builder.relativeUris;
        this.useParam = builder.useParam;
        this.paramName = builder.paramName;
        this.tenantParamName = builder.tenantParamName;
        this.useHeader = builder.useHeader;
        this.headerHandler = builder.headerHandler;
        this.useCookie = builder.useCookie;
        this.tokenCookieHandler = builder.tokenCookieBuilder.build();
        this.idTokenCookieHandler = builder.idTokenCookieBuilder.build();
        this.tenantCookieHandler = builder.tenantCookieBuilder.build();
        this.introspectEndpoint = builder.validateJwtWithJwk() ? LazyValue.create(Optional.empty()) : LazyValue.create(() -> Optional.of(this.appClient().target(builder.introspectUri())));
        this.webClientBuilderSupplier = builder.webClientBuilderSupplier;
        this.jaxrsClientBuilderSupplier = builder.jaxrsClientBuilderSupplier;
        this.defaultTenant = LazyValue.create(() -> Tenant.create(this, this));
        LOGGER.finest(() -> "Redirect URI with host: " + this.frontendUri + this.redirectUri);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OidcConfig create(Config config) {
        return OidcConfig.builder().config(config).build();
    }

    public static <T> Single<T> postJsonResponse(WebClientRequestBuilder requestBuilder, Object toSubmit, Function<JsonObject, T> jsonProcessor, BiFunction<Http.ResponseStatus, String, Optional<T>> errorEntityProcessor, BiFunction<Throwable, String, Optional<T>> errorProcessor) {
        return requestBuilder.submit(toSubmit).flatMapSingle(response -> {
            if (response.status().family() == Http.ResponseStatus.Family.SUCCESSFUL) {
                return response.content().as(JsonObject.class).map(jsonProcessor).onErrorResumeWithSingle(t -> ((Optional)errorProcessor.apply((Throwable)t, "Failed to read JSON from response")).map(Single::just).orElseGet(() -> Single.error((Throwable)t)));
            }
            return response.content().as(String.class).flatMapSingle(it -> ((Optional)errorEntityProcessor.apply(response.status(), (String)it)).map(Single::just).orElseGet(() -> Single.error((Throwable)new SecurityException("Failed to process request: " + it)))).onErrorResumeWithSingle(t -> ((Optional)errorProcessor.apply((Throwable)t, "Failed to process error entity")).map(Single::just).orElseGet(() -> Single.error((Throwable)t)));
        }).onErrorResumeWithSingle(t -> ((Optional)errorProcessor.apply((Throwable)t, "Failed to invoke request")).map(Single::just).orElseGet(() -> Single.error((Throwable)t)));
    }

    public boolean useParam() {
        return this.useParam;
    }

    public String paramName() {
        return this.paramName;
    }

    public String tenantParamName() {
        return this.tenantParamName;
    }

    public boolean useHeader() {
        return this.useHeader;
    }

    public TokenHandler headerHandler() {
        return this.headerHandler;
    }

    public boolean useCookie() {
        return this.useCookie;
    }

    public OidcCookieHandler tokenCookieHandler() {
        return this.tokenCookieHandler;
    }

    public OidcCookieHandler idTokenCookieHandler() {
        return this.idTokenCookieHandler;
    }

    public OidcCookieHandler tenantCookieHandler() {
        return this.tenantCookieHandler;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public boolean forceHttpsRedirects() {
        return this.forceHttpsRedirects;
    }

    public boolean logoutEnabled() {
        return this.logoutEnabled;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public URI postLogoutUri() {
        return this.postLogoutUri;
    }

    public String redirectUriWithHost() {
        if (this.frontendUri == null) {
            throw new SecurityException("Frontend URI is not defined");
        }
        return this.frontendUri + this.redirectUri;
    }

    public String redirectUriWithHost(String frontendUri) {
        if (this.frontendUri != null) {
            return this.redirectUriWithHost();
        }
        return frontendUri + this.redirectUri;
    }

    public boolean shouldRedirect() {
        return this.redirect;
    }

    public String redirectAttemptParam() {
        return this.redirectAttemptParam;
    }

    public int maxRedirects() {
        return this.maxRedirects;
    }

    public CrossOriginConfig crossOriginConfig() {
        return this.crossOriginConfig;
    }

    public Duration tokenRefreshSkew() {
        return this.tokenRefreshSkew;
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public String cookieName() {
        return this.tokenCookieHandler().cookieName();
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public String cookieOptions() {
        return this.tokenCookieHandler().createCookieOptions();
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public String cookieValuePrefix() {
        return this.tokenCookieHandler().cookieValuePrefix();
    }

    public boolean relativeUris() {
        return this.relativeUris;
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public Client generalClient() {
        return this.generalClient;
    }

    public WebClient generalWebClient() {
        return this.webClient;
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public Client appClient() {
        return ((Tenant)this.defaultTenant.get()).appClient();
    }

    public WebClient appWebClient() {
        return ((Tenant)this.defaultTenant.get()).appWebClient();
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public WebTarget tokenEndpoint() {
        return ((Tenant)this.defaultTenant.get()).tokenEndpoint();
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public WebTarget introspectEndpoint() {
        return ((Optional)this.introspectEndpoint.get()).orElse(null);
    }

    public TenantConfig tenantConfig(String tenantId) {
        TenantConfig tenantConfig = this.tenantConfigurations.get(tenantId);
        if (tenantConfig == null) {
            return this.tenantConfigurations.getOrDefault("@default", this);
        }
        return tenantConfig;
    }

    public URI tokenEndpointUri() {
        return ((Tenant)this.defaultTenant.get()).tokenEndpointUri();
    }

    public String authorizationEndpointUri() {
        return ((Tenant)this.defaultTenant.get()).authorizationEndpointUri();
    }

    public URI logoutEndpointUri() {
        return ((Tenant)this.defaultTenant.get()).logoutEndpointUri();
    }

    public String issuer() {
        return ((Tenant)this.defaultTenant.get()).issuer();
    }

    public JwkKeys signJwk() {
        return ((Tenant)this.defaultTenant.get()).signJwk();
    }

    public URI introspectUri() {
        return ((Tenant)this.defaultTenant.get()).introspectUri();
    }

    Supplier<WebClient.Builder> webClientBuilderSupplier() {
        return this.webClientBuilderSupplier;
    }

    Supplier<ClientBuilder> jaxrsClientBuilderSupplier() {
        return this.jaxrsClientBuilderSupplier;
    }

    @Configured(description="Open ID Connect configuration")
    public static class Builder
    extends BaseBuilder<Builder, OidcConfig> {
        private final Map<String, TenantConfig> tenantConfigurations = new HashMap<String, TenantConfig>();
        private String redirectUri = "/oidc/redirect";
        private String logoutUri = "/oidc/logout";
        private boolean logoutEnabled = false;
        private String frontendUri;
        private boolean redirect = true;
        private String redirectAttemptParam = "h_ra";
        private int maxRedirects = 5;
        private URI postLogoutUri;
        private CrossOriginConfig crossOriginConfig;
        private boolean forceHttpsRedirects = false;
        private Duration tokenRefreshSkew = DEFAULT_TOKEN_REFRESH_SKEW;
        private String proxyHost;
        private String proxyProtocol = "http";
        private int proxyPort = 80;
        @Deprecated
        private Client generalClient;
        private WebClient webClient;
        private Supplier<WebClient.Builder> webClientBuilderSupplier;
        private Supplier<ClientBuilder> jaxrsClientBuilderSupplier;
        private String paramName = "accessToken";
        private String tenantParamName = "h_tenant";
        private boolean useHeader = false;
        private boolean useParam = false;
        private final OidcCookieHandler.Builder tenantCookieBuilder = OidcCookieHandler.builder().cookieName("HELIDON_TENANT");
        private final OidcCookieHandler.Builder tokenCookieBuilder = OidcCookieHandler.builder().cookieName("JSESSIONID");
        private final OidcCookieHandler.Builder idTokenCookieBuilder = OidcCookieHandler.builder().cookieName("JSESSIONID_2");
        private TokenHandler headerHandler = TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("bearer ").build();
        private boolean useCookie = true;
        private boolean cookieSameSiteDefault = true;
        private boolean relativeUris = false;

        protected Builder() {
        }

        public OidcConfig build() {
            this.buildConfiguration();
            Errors.Collector collector = Errors.collector();
            if (this.useCookie && this.logoutEnabled && this.postLogoutUri == null) {
                collector.fatal("post-logout-uri must be defined when logout is enabled.");
            }
            collector.collect().checkValid();
            if (this.cookieSameSiteDefault && this.useCookie && this.identityUri() != null) {
                String frontendHost;
                String identityHost = this.identityUri().getHost();
                if (this.frontendUri != null && identityHost.equals(frontendHost = URI.create(this.frontendUri).getHost())) {
                    LOGGER.info("As frontend host and identity host are equal, setting Same-Site policy to Strict this can be overridden using configuration option of OIDC: \"cookie-same-site\"");
                    this.tenantCookieBuilder.sameSite(SetCookie.SameSite.STRICT);
                    this.tokenCookieBuilder.sameSite(SetCookie.SameSite.STRICT);
                    this.idTokenCookieBuilder.sameSite(SetCookie.SameSite.STRICT);
                }
            }
            if (this.logoutEnabled) {
                this.idTokenCookieBuilder.encryptionEnabled(true);
            }
            this.webClientBuilderSupplier = () -> OidcUtil.webClientBaseBuilder(this.proxyHost, this.proxyPort, this.relativeUris, this.clientTimeout());
            this.jaxrsClientBuilderSupplier = () -> OidcUtil.clientBaseBuilder(this.proxyProtocol, this.proxyHost, this.proxyPort);
            this.generalClient = this.jaxrsClientBuilderSupplier.get().build();
            this.webClient = this.webClientBuilderSupplier.get().build();
            return new OidcConfig(this);
        }

        @Override
        public Builder config(Config config) {
            super.config(config);
            config.get("frontend-uri").asString().ifPresent(this::frontendUri);
            config.get("proxy-protocol").asString().ifPresent(this::proxyProtocol);
            config.get("proxy-host").asString().ifPresent(this::proxyHost);
            config.get("proxy-port").asInt().ifPresent(this::proxyPort);
            config.get("relative-uris").asBoolean().ifPresent(this::relativeUris);
            config.get("query-param-use").asBoolean().ifPresent(this::useParam);
            config.get("query-param-name").asString().ifPresent(this::paramName);
            config.get("query-param-tenant-name").asString().ifPresent(this::paramTenantName);
            config.get("header-use").asBoolean().ifPresent(this::useHeader);
            config.get("header-token").as(TokenHandler.class).ifPresent(this::headerTokenHandler);
            config.get("cookie-use").asBoolean().ifPresent(this::useCookie);
            config.get("cookie-name").asString().ifPresent(this::cookieName);
            config.get("cookie-name-id-token").asString().ifPresent(this::cookieNameIdToken);
            config.get("cookie-name-tenant").asString().ifPresent(this::cookieTenantName);
            config.get("cookie-domain").asString().ifPresent(this::cookieDomain);
            config.get("cookie-path").asString().ifPresent(this::cookiePath);
            config.get("cookie-max-age-seconds").asLong().ifPresent(this::cookieMaxAgeSeconds);
            config.get("cookie-http-only").asBoolean().ifPresent(this::cookieHttpOnly);
            config.get("cookie-secure").asBoolean().ifPresent(this::cookieSecure);
            config.get("cookie-same-site").asString().ifPresent(this::cookieSameSite);
            config.get("cookie-encryption-enabled").asBoolean().ifPresent(this::cookieEncryptionEnabled);
            config.get("cookie-encryption-id-enabled").asBoolean().ifPresent(this::cookieEncryptionEnabledIdToken);
            config.get("cookie-encryption-tenant-enabled").asBoolean().ifPresent(this::cookieEncryptionEnabledTenantName);
            config.get("cookie-encryption-password").as(String.class).map(String::toCharArray).ifPresent(this::cookieEncryptionPassword);
            config.get("cookie-encryption-name").asString().ifPresent(this::cookieEncryptionName);
            config.get("redirect-uri").asString().ifPresent(this::redirectUri);
            config.get("post-logout-uri").as(URI.class).ifPresent(this::postLogoutUri);
            config.get("logout-enabled").asBoolean().ifPresent(this::logoutEnabled);
            config.get("redirect").asBoolean().ifPresent(this::redirect);
            config.get("redirect-attempt-param").asString().ifPresent(this::redirectAttemptParam);
            config.get("max-redirects").asInt().ifPresent(this::maxRedirects);
            config.get("force-https-redirects").asBoolean().ifPresent(this::forceHttpsRedirects);
            config.get("cors").as(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            config.get("token-refresh-before-expiration").as(Duration.class).ifPresent(this::tokenRefreshSkew);
            config.get("tenants").asList(Config.class).ifPresent(confList -> confList.forEach(tenantConfig -> this.tenantFromConfig(config, (Config)tenantConfig)));
            return this;
        }

        private void tenantFromConfig(Config defaultConfig, Config tenantConfig) {
            this.addTenantConfig(TenantConfig.tenantBuilder().config(defaultConfig).config(tenantConfig).build());
        }

        public Builder tokenRefreshSkew(Duration tokenRefreshSkew) {
            this.tokenRefreshSkew = tokenRefreshSkew;
            return this;
        }

        public Builder crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            this.crossOriginConfig = crossOriginConfig;
            return this;
        }

        public Builder logoutEnabled(Boolean logoutEnabled) {
            this.logoutEnabled = logoutEnabled;
            return this;
        }

        public Builder redirect(boolean redirect) {
            this.redirect = redirect;
            return this;
        }

        public Builder frontendUri(String uri) {
            this.frontendUri = uri;
            return this;
        }

        public Builder forceHttpsRedirects(boolean forceHttpsRedirects) {
            this.forceHttpsRedirects = forceHttpsRedirects;
            return this;
        }

        public Builder relativeUris(boolean relativeUris) {
            this.relativeUris = relativeUris;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder logoutUri(String logoutUri) {
            this.logoutUri = logoutUri;
            return this;
        }

        public Builder postLogoutUri(URI uri) {
            this.postLogoutUri = uri;
            return this;
        }

        public Builder redirectAttemptParam(String paramName) {
            this.redirectAttemptParam = paramName;
            return this;
        }

        public Builder maxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public Builder proxyProtocol(String protocol) {
            this.proxyProtocol = protocol;
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost == null || proxyHost.isEmpty() ? null : proxyHost;
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder headerTokenHandler(TokenHandler tokenHandler) {
            this.headerHandler = tokenHandler;
            return this;
        }

        public Builder useHeader(Boolean useHeader) {
            this.useHeader = useHeader;
            return this;
        }

        public Builder paramName(String paramName) {
            this.paramName = paramName;
            return this;
        }

        public Builder paramTenantName(String paramName) {
            this.tenantParamName = paramName;
            return this;
        }

        public Builder useParam(Boolean useParam) {
            this.useParam = useParam;
            return this;
        }

        public Builder cookieEncryptionName(String cookieEncryptionName) {
            this.tokenCookieBuilder.encryptionName(cookieEncryptionName);
            this.idTokenCookieBuilder.encryptionName(cookieEncryptionName);
            this.tenantCookieBuilder.encryptionName(cookieEncryptionName);
            return this;
        }

        public Builder cookieEncryptionPassword(char[] cookieEncryptionPassword) {
            this.tokenCookieBuilder.encryptionPassword(cookieEncryptionPassword);
            this.idTokenCookieBuilder.encryptionPassword(cookieEncryptionPassword);
            this.tenantCookieBuilder.encryptionPassword(cookieEncryptionPassword);
            return this;
        }

        public Builder cookieEncryptionEnabled(boolean cookieEncryptionEnabled) {
            this.tokenCookieBuilder.encryptionEnabled(cookieEncryptionEnabled);
            return this;
        }

        public Builder cookieEncryptionEnabledIdToken(boolean cookieEncryptionEnabled) {
            this.idTokenCookieBuilder.encryptionEnabled(cookieEncryptionEnabled);
            return this;
        }

        public Builder cookieEncryptionEnabledTenantName(boolean cookieEncryptionEnabled) {
            this.tenantCookieBuilder.encryptionEnabled(cookieEncryptionEnabled);
            return this;
        }

        public Builder cookieSameSite(String sameSite) {
            return this.cookieSameSite(SetCookie.SameSite.valueOf((String)sameSite.toUpperCase(Locale.ROOT)));
        }

        public Builder cookieSameSite(SetCookie.SameSite sameSite) {
            this.tokenCookieBuilder.sameSite(sameSite);
            this.idTokenCookieBuilder.sameSite(sameSite);
            this.tenantCookieBuilder.sameSite(sameSite);
            this.cookieSameSiteDefault = false;
            return this;
        }

        public Builder cookieSecure(Boolean secure) {
            this.tokenCookieBuilder.secure(secure);
            this.idTokenCookieBuilder.secure(secure);
            this.tenantCookieBuilder.secure(secure);
            return this;
        }

        public Builder cookieHttpOnly(Boolean httpOnly) {
            this.tokenCookieBuilder.httpOnly(httpOnly);
            this.idTokenCookieBuilder.httpOnly(httpOnly);
            this.tenantCookieBuilder.httpOnly(httpOnly);
            return this;
        }

        public Builder cookieMaxAgeSeconds(long age) {
            this.tokenCookieBuilder.maxAge(age);
            this.idTokenCookieBuilder.maxAge(age);
            this.tenantCookieBuilder.maxAge(age);
            return this;
        }

        public Builder cookiePath(String path) {
            this.tokenCookieBuilder.path(path);
            this.idTokenCookieBuilder.path(path);
            this.tenantCookieBuilder.path(path);
            return this;
        }

        public Builder cookieDomain(String domain) {
            this.tokenCookieBuilder.domain(domain);
            this.idTokenCookieBuilder.domain(domain);
            this.tenantCookieBuilder.domain(domain);
            return this;
        }

        public Builder cookieName(String cookieName) {
            this.tokenCookieBuilder.cookieName(cookieName);
            return this;
        }

        public Builder cookieNameIdToken(String cookieName) {
            this.idTokenCookieBuilder.cookieName(cookieName);
            return this;
        }

        public Builder cookieTenantName(String cookieName) {
            this.tenantCookieBuilder.cookieName(cookieName);
            return this;
        }

        public Builder useCookie(Boolean useCookie) {
            this.useCookie = useCookie;
            return this;
        }

        public Builder addTenantConfig(TenantConfig tenantConfig) {
            this.tenantConfigurations.put(tenantConfig.name(), tenantConfig);
            return this;
        }
    }

    public static enum RequestType {
        CODE_TO_TOKEN,
        INTROSPECT_JWT;

    }

    public static enum ClientAuthentication {
        CLIENT_SECRET_BASIC,
        CLIENT_SECRET_POST,
        CLIENT_SECRET_JWT,
        PRIVATE_KEY_JWT,
        NONE;

    }
}

