/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.http.SetCookie;
import io.helidon.common.reactive.Single;
import io.helidon.security.providers.oidc.common.OidcEncryption;
import io.helidon.security.spi.EncryptionProvider;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OidcCookieHandler {
    private static final Logger LOGGER = Logger.getLogger(OidcCookieHandler.class.getName());
    private final String createCookieOptions;
    private final List<Consumer<SetCookie.Builder>> removeCookieUpdaters = new LinkedList<Consumer<SetCookie.Builder>>();
    private final List<Consumer<SetCookie.Builder>> createCookieUpdaters = new LinkedList<Consumer<SetCookie.Builder>>();
    private final String cookieName;
    private final String valuePrefix;
    private final Function<String, Single<String>> encryptFunction;
    private final Function<String, Single<String>> decryptFunction;

    private OidcCookieHandler(Builder builder) {
        this.cookieName = builder.cookieName;
        this.valuePrefix = this.cookieName + "=";
        String path = builder.path;
        boolean httpOnly = builder.httpOnly;
        SetCookie.SameSite sameSite = builder.sameSite;
        String domain = builder.domain;
        boolean secure = builder.secure;
        Long maxAge = builder.maxAge;
        this.removeCookieUpdaters.add(it -> it.path(path));
        if (httpOnly) {
            this.removeCookieUpdaters.add(it -> it.httpOnly(true));
        }
        if (sameSite != null) {
            this.removeCookieUpdaters.add(it -> it.sameSite(sameSite));
        }
        if (domain != null) {
            this.removeCookieUpdaters.add(it -> it.domain(domain));
        }
        if (secure) {
            this.removeCookieUpdaters.add(it -> it.secure(true));
        }
        this.createCookieUpdaters.addAll(this.removeCookieUpdaters);
        if (maxAge != null) {
            this.createCookieUpdaters.add(it -> it.maxAge(Duration.ofSeconds(maxAge)));
        }
        this.removeCookieUpdaters.add(it -> it.expires(Instant.ofEpochMilli(0L)));
        String value = this.createCookieDirectValue("value").build().toString();
        int index = value.indexOf(59);
        this.createCookieOptions = index < 0 ? "" : value.substring(index);
        if (builder.encryptionEnabled) {
            EncryptionProvider.EncryptionSupport cookieEncryption = OidcEncryption.create("Cookie(" + this.cookieName + ")", builder.encryptionName, builder.encryptionPassword);
            this.encryptFunction = it -> cookieEncryption.encrypt(it.getBytes(StandardCharsets.UTF_8));
            this.decryptFunction = it -> cookieEncryption.decrypt(it).map(String::new);
        } else {
            this.encryptFunction = Single::just;
            this.decryptFunction = Single::just;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(() -> "OIDC Create cookie example: " + value);
            LOGGER.finest(() -> "OIDC Remove cookie example: " + this.removeCookie().build());
        }
    }

    static Builder builder() {
        return new Builder();
    }

    public Single<SetCookie.Builder> createCookie(String value) {
        return this.encryptFunction.apply(value).map(this::createCookieDirectValue);
    }

    public String cookieName() {
        return this.cookieName;
    }

    public SetCookie.Builder removeCookie() {
        SetCookie.Builder builder = SetCookie.builder((String)this.cookieName, (String)"");
        this.removeCookieUpdaters.forEach(it -> it.accept(builder));
        return builder;
    }

    public Optional<Single<String>> findCookie(Map<String, List<String>> headers) {
        Objects.requireNonNull(headers);
        List<String> cookies = headers.get("Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Optional.empty();
        }
        for (String cookie : cookies) {
            String[] cookieValues;
            for (String cookieValue : cookieValues = cookie.split(";\\s?")) {
                String trimmed = cookieValue.trim();
                if (!trimmed.startsWith(this.valuePrefix)) continue;
                return Optional.of(this.decrypt(trimmed.substring(this.valuePrefix.length())));
            }
        }
        return Optional.empty();
    }

    public Single<String> decrypt(String cipherText) {
        return this.decryptFunction.apply(cipherText);
    }

    String createCookieOptions() {
        return this.createCookieOptions;
    }

    String cookieValuePrefix() {
        return this.valuePrefix;
    }

    private SetCookie.Builder createCookieDirectValue(String value) {
        SetCookie.Builder builder = SetCookie.builder((String)this.cookieName, (String)value);
        this.createCookieUpdaters.forEach(it -> it.accept(builder));
        return builder;
    }

    static class Builder
    implements io.helidon.common.Builder<OidcCookieHandler> {
        static final String DEFAULT_PATH = "/";
        static final boolean DEFAULT_HTTP_ONLY = true;
        static final boolean DEFAULT_SECURE = false;
        static final SetCookie.SameSite DEFAULT_SAME_SITE = SetCookie.SameSite.LAX;
        private String path = "/";
        private boolean httpOnly = true;
        private SetCookie.SameSite sameSite = DEFAULT_SAME_SITE;
        private String domain;
        private boolean secure = false;
        private Long maxAge;
        private String cookieName;
        private String encryptionName;
        private char[] encryptionPassword;
        private boolean encryptionEnabled;

        private Builder() {
        }

        public OidcCookieHandler build() {
            return new OidcCookieHandler(this);
        }

        Builder path(String cookiePath) {
            this.path = cookiePath;
            return this;
        }

        Builder httpOnly(boolean cookieHttpOnly) {
            this.httpOnly = cookieHttpOnly;
            return this;
        }

        Builder sameSite(SetCookie.SameSite cookieSameSite) {
            this.sameSite = cookieSameSite;
            return this;
        }

        Builder domain(String cookieDomain) {
            this.domain = cookieDomain;
            return this;
        }

        Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        Builder maxAge(Long maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        Builder cookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        public Builder encryptionName(String encryptionName) {
            this.encryptionName = encryptionName;
            return this;
        }

        public Builder encryptionPassword(char[] encryptionPassword) {
            this.encryptionPassword = encryptionPassword;
            return this;
        }

        public Builder encryptionEnabled(Boolean encryptionEnabled) {
            this.encryptionEnabled = encryptionEnabled;
            return this;
        }
    }
}

