/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.Errors;
import io.helidon.security.Security;
import io.helidon.security.SecurityException;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.providers.httpauth.HttpBasicAuthProvider;
import io.helidon.security.providers.httpauth.HttpBasicOutboundConfig;
import io.helidon.security.providers.oidc.common.IdcsSupport;
import io.helidon.security.providers.oidc.common.OidcConfig;
import io.helidon.security.providers.oidc.common.OidcMetadata;
import io.helidon.security.providers.oidc.common.TenantConfig;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.webclient.WebClient;
import io.helidon.webclient.security.WebClientSecurity;
import io.helidon.webclient.spi.WebClientService;
import java.net.URI;
import javax.json.JsonObject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public final class Tenant {
    private final TenantConfig tenantConfig;
    private final URI tokenEndpointUri;
    private final String authorizationEndpointUri;
    private final URI logoutEndpointUri;
    private final String issuer;
    private final Client appClient;
    private final WebClient appWebClient;
    private final WebTarget tokenEndpoint;
    private final JwkKeys signJwk;
    private final URI introspectUri;

    private Tenant(TenantConfig tenantConfig, URI tokenEndpointUri, URI authorizationEndpointUri, URI logoutEndpointUri, String issuer, Client appClient, WebClient appWebClient, WebTarget tokenEndpoint, JwkKeys signJwk, URI introspectUri) {
        this.tenantConfig = tenantConfig;
        this.tokenEndpointUri = tokenEndpointUri;
        this.authorizationEndpointUri = authorizationEndpointUri.toString();
        this.logoutEndpointUri = logoutEndpointUri;
        this.issuer = issuer;
        this.appClient = appClient;
        this.appWebClient = appWebClient;
        this.tokenEndpoint = tokenEndpoint;
        this.signJwk = signJwk;
        this.introspectUri = introspectUri;
    }

    public static Tenant create(OidcConfig oidcConfig, TenantConfig tenantConfig) {
        WebClient webClient = oidcConfig.generalWebClient();
        Errors.Collector collector = Errors.collector();
        OidcMetadata oidcMetadata = OidcMetadata.builder().remoteEnabled(tenantConfig.useWellKnown()).json(tenantConfig.oidcMetadata()).webClient(webClient).identityUri(tenantConfig.identityUri()).collector(collector).build();
        URI tokenEndpointUri = oidcMetadata.getOidcEndpoint(collector, tenantConfig.tenantTokenEndpointUri().orElse(null), "token_endpoint", "/oauth2/v1/token");
        URI authorizationEndpointUri = oidcMetadata.getOidcEndpoint(collector, tenantConfig.authorizationEndpoint().orElse(null), "authorization_endpoint", "/oauth2/v1/authorize");
        URI logoutEndpointUri = oidcMetadata.getOidcEndpoint(collector, tenantConfig.tenantLogoutEndpointUri().orElse(null), "end_session_endpoint", "oauth2/v1/userlogout");
        String issuer = tenantConfig.tenantIssuer().or(() -> oidcMetadata.getString("issuer")).orElse(null);
        collector.collect().checkValid();
        WebClient.Builder webClientBuilder = oidcConfig.webClientBuilderSupplier().get();
        ClientBuilder clientBuilder = oidcConfig.jaxrsClientBuilderSupplier().get();
        if (tenantConfig.tokenEndpointAuthentication() == OidcConfig.ClientAuthentication.CLIENT_SECRET_BASIC) {
            HttpAuthenticationFeature basicAuth = HttpAuthenticationFeature.basicBuilder().credentials(tenantConfig.clientId(), tenantConfig.clientSecret()).build();
            clientBuilder.register((Object)basicAuth);
            HttpBasicAuthProvider httpBasicAuth = HttpBasicAuthProvider.builder().addOutboundTarget(OutboundTarget.builder((String)"oidc").addHost("*").customObject(HttpBasicOutboundConfig.class, (Object)HttpBasicOutboundConfig.create((String)tenantConfig.clientId(), (String)tenantConfig.clientSecret())).build()).build();
            Security tokenOutboundSecurity = Security.builder().addOutboundSecurityProvider((OutboundSecurityProvider)httpBasicAuth).build();
            webClientBuilder.addService((WebClientService)WebClientSecurity.create((Security)tokenOutboundSecurity));
        }
        Client appClient = clientBuilder.build();
        WebClient appWebClient = webClientBuilder.build();
        WebTarget tokenEndpoint = appClient.target(tokenEndpointUri);
        JwkKeys signJwk = tenantConfig.tenantSignJwk().orElseGet(() -> {
            URI jwkUri;
            if (tenantConfig.validateJwtWithJwk() && (jwkUri = oidcMetadata.getOidcEndpoint(collector, null, "jwks_uri", null)) != null) {
                if ("idcs".equals(tenantConfig.serverType())) {
                    return IdcsSupport.signJwk(appWebClient, webClient, tokenEndpointUri, jwkUri, tenantConfig.clientTimeout());
                }
                return JwkKeys.builder().json((JsonObject)webClient.get().uri(jwkUri).request(JsonObject.class).await()).build();
            }
            return JwkKeys.builder().build();
        });
        URI introspectUri = tenantConfig.tenantIntrospectUri().orElse(null);
        if (!tenantConfig.validateJwtWithJwk()) {
            introspectUri = oidcMetadata.getOidcEndpoint(collector, introspectUri, "introspection_endpoint", "/oauth2/v1/introspect");
        }
        return new Tenant(tenantConfig, tokenEndpointUri, authorizationEndpointUri, logoutEndpointUri, issuer, appClient, appWebClient, tokenEndpoint, signJwk, introspectUri);
    }

    public TenantConfig tenantConfig() {
        return this.tenantConfig;
    }

    public URI tokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public String authorizationEndpointUri() {
        return this.authorizationEndpointUri;
    }

    public URI logoutEndpointUri() {
        return this.logoutEndpointUri;
    }

    public String issuer() {
        return this.issuer;
    }

    public WebClient appWebClient() {
        return this.appWebClient;
    }

    public JwkKeys signJwk() {
        return this.signJwk;
    }

    public URI introspectUri() {
        if (this.introspectUri == null) {
            throw new SecurityException("Introspect URI is not configured when using validate with JWK.");
        }
        return this.introspectUri;
    }

    WebTarget tokenEndpoint() {
        return this.tokenEndpoint;
    }

    Client appClient() {
        return this.appClient;
    }
}

