/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.Errors;
import io.helidon.common.configurable.Resource;
import io.helidon.common.http.FormParams;
import io.helidon.common.http.Http;
import io.helidon.common.http.SetCookie;
import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.security.Security;
import io.helidon.security.SecurityException;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.providers.httpauth.HttpBasicAuthProvider;
import io.helidon.security.providers.httpauth.HttpBasicOutboundConfig;
import io.helidon.security.providers.oidc.common.IdcsSupport;
import io.helidon.security.providers.oidc.common.OidcCookieHandler;
import io.helidon.security.providers.oidc.common.OidcMetadata;
import io.helidon.security.providers.oidc.common.OidcUtil;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.util.TokenHandler;
import io.helidon.webclient.WebClient;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.security.WebClientSecurity;
import io.helidon.webclient.spi.WebClientService;
import io.helidon.webserver.cors.CrossOriginConfig;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Logger;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public final class OidcConfig {
    public static final String PARAM_HEADER_NAME = "X_OIDC_TOKEN_HEADER";
    static final int DEFAULT_PROXY_PORT = 80;
    static final String DEFAULT_REDIRECT_URI = "/oidc/redirect";
    static final String DEFAULT_LOGOUT_URI = "/oidc/logout";
    static final String DEFAULT_COOKIE_NAME = "JSESSIONID";
    static final boolean DEFAULT_COOKIE_USE = true;
    static final String DEFAULT_PARAM_NAME = "accessToken";
    static final boolean DEFAULT_PARAM_USE = false;
    static final boolean DEFAULT_HEADER_USE = true;
    static final String DEFAULT_PROXY_PROTOCOL = "http";
    static final String DEFAULT_BASE_SCOPES = "openid";
    static final boolean DEFAULT_JWT_VALIDATE_JWK = true;
    static final boolean DEFAULT_REDIRECT = false;
    static final String DEFAULT_REALM = "helidon";
    static final String DEFAULT_ATTEMPT_PARAM = "h_ra";
    static final int DEFAULT_MAX_REDIRECTS = 5;
    static final int DEFAULT_TIMEOUT_SECONDS = 30;
    static final boolean DEFAULT_FORCE_HTTPS_REDIRECTS = false;
    static final Duration DEFAULT_TOKEN_REFRESH_SKEW = Duration.ofSeconds(5L);
    private static final Logger LOGGER = Logger.getLogger(OidcConfig.class.getName());
    private static final JsonReaderFactory JSON = Json.createReaderFactory(Collections.emptyMap());
    private final String redirectUri;
    private final String logoutUri;
    private final boolean logoutEnabled;
    private final boolean useCookie;
    private final boolean useParam;
    private final String paramName;
    private final URI identityUri;
    private final WebTarget tokenEndpoint;
    private final URI tokenEndpointUri;
    private final String scopeAudience;
    private final String frontendUri;
    private final boolean useHeader;
    private final TokenHandler headerHandler;
    private final String authorizationEndpointUri;
    private final String clientId;
    private final JwkKeys signJwk;
    private final String baseScopes;
    private final boolean validateJwtWithJwk;
    private final WebTarget introspectEndpoint;
    private final String issuer;
    private final String audience;
    private final Client appClient;
    private final Client generalClient;
    private final boolean redirect;
    private final String realm;
    private final String redirectAttemptParam;
    private final int maxRedirects;
    private final ClientAuthentication tokenEndpointAuthentication;
    private final String clientSecret;
    private final WebClient webClient;
    private final WebClient appWebClient;
    private final URI introspectUri;
    private final Duration clientTimeout;
    private final OidcCookieHandler tokenCookieHandler;
    private final OidcCookieHandler idTokenCookieHandler;
    private final URI postLogoutUri;
    private final URI logoutEndpointUri;
    private final CrossOriginConfig crossOriginConfig;
    private final boolean forceHttpsRedirects;
    private final Duration tokenRefreshSkew;

    private OidcConfig(Builder builder) {
        String tmp;
        this.clientId = builder.clientId;
        this.useCookie = builder.useCookie;
        this.useParam = builder.useParam;
        this.paramName = builder.paramName;
        this.frontendUri = builder.frontendUri;
        this.redirectUri = builder.redirectUri;
        this.logoutUri = builder.logoutUri;
        this.logoutEnabled = builder.logoutEnabled;
        this.postLogoutUri = builder.postLogoutUri;
        this.useHeader = builder.useHeader;
        this.headerHandler = builder.headerHandler;
        this.authorizationEndpointUri = builder.authorizationEndpointUri.toString();
        this.logoutEndpointUri = builder.logoutEndpointUri;
        this.baseScopes = builder.baseScopes;
        this.validateJwtWithJwk = builder.validateJwtWithJwk;
        this.issuer = builder.issuer;
        this.audience = builder.audience;
        this.identityUri = builder.identityUri;
        this.redirect = builder.redirect;
        this.realm = builder.realm;
        this.redirectAttemptParam = builder.redirectAttemptParam;
        this.maxRedirects = builder.maxRedirects;
        this.appClient = builder.appClient;
        this.appWebClient = builder.appWebClient;
        this.webClient = builder.webClient;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.tokenEndpointUri = builder.tokenEndpointUri;
        this.generalClient = builder.generalClient;
        this.tokenEndpointAuthentication = builder.tokenEndpointAuthentication;
        this.clientTimeout = builder.clientTimeout;
        this.forceHttpsRedirects = builder.forceHttpsRedirects;
        this.clientSecret = this.tokenEndpointAuthentication == ClientAuthentication.CLIENT_SECRET_POST ? builder.clientSecret : null;
        this.signJwk = builder.signJwk == null ? JwkKeys.builder().build() : builder.signJwk;
        if (this.validateJwtWithJwk) {
            this.introspectEndpoint = null;
            this.introspectUri = null;
        } else {
            this.introspectUri = builder.introspectUri;
            this.introspectEndpoint = this.appClient.target(builder.introspectUri);
        }
        this.tokenCookieHandler = builder.tokenCookieBuilder.build();
        if (this.logoutEnabled) {
            builder.idTokenCookieBuilder.encryptionEnabled(true);
        }
        this.idTokenCookieHandler = builder.idTokenCookieBuilder.build();
        this.scopeAudience = builder.scopeAudience == null || builder.scopeAudience.trim().isEmpty() ? "" : ((tmp = builder.scopeAudience.trim()).endsWith("/") ? tmp : tmp + "/");
        this.crossOriginConfig = builder.crossOriginConfig;
        this.tokenRefreshSkew = builder.tokenRefreshSkew;
        LOGGER.finest(() -> "OIDC Scope audience: " + this.scopeAudience);
        LOGGER.finest(() -> "Redirect URI with host: " + this.frontendUri + this.redirectUri);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OidcConfig create(Config config) {
        return OidcConfig.builder().config(config).build();
    }

    public static <T> Single<T> postJsonResponse(WebClientRequestBuilder requestBuilder, Object toSubmit, Function<JsonObject, T> jsonProcessor, BiFunction<Http.ResponseStatus, String, Optional<T>> errorEntityProcessor, BiFunction<Throwable, String, Optional<T>> errorProcessor) {
        return requestBuilder.submit(toSubmit).flatMapSingle(response -> {
            if (response.status().family() == Http.ResponseStatus.Family.SUCCESSFUL) {
                return response.content().as(JsonObject.class).map(jsonProcessor).onErrorResumeWithSingle(t -> ((Optional)errorProcessor.apply((Throwable)t, "Failed to read JSON from response")).map(Single::just).orElseGet(() -> Single.error((Throwable)t)));
            }
            return response.content().as(String.class).flatMapSingle(it -> ((Optional)errorEntityProcessor.apply(response.status(), (String)it)).map(Single::just).orElseGet(() -> Single.error((Throwable)new SecurityException("Failed to process request: " + it)))).onErrorResumeWithSingle(t -> ((Optional)errorProcessor.apply((Throwable)t, "Failed to process error entity")).map(Single::just).orElseGet(() -> Single.error((Throwable)t)));
        }).onErrorResumeWithSingle(t -> ((Optional)errorProcessor.apply((Throwable)t, "Failed to invoke request")).map(Single::just).orElseGet(() -> Single.error((Throwable)t)));
    }

    public JwkKeys signJwk() {
        return this.signJwk;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public boolean forceHttpsRedirects() {
        return this.forceHttpsRedirects;
    }

    public boolean logoutEnabled() {
        return this.logoutEnabled;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public URI postLogoutUri() {
        return this.postLogoutUri;
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public WebTarget tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public URI tokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public boolean useParam() {
        return this.useParam;
    }

    public String paramName() {
        return this.paramName;
    }

    public boolean useCookie() {
        return this.useCookie;
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public String cookieName() {
        return this.tokenCookieHandler.cookieName();
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public String cookieOptions() {
        return this.tokenCookieHandler.createCookieOptions();
    }

    public OidcCookieHandler tokenCookieHandler() {
        return this.tokenCookieHandler;
    }

    public OidcCookieHandler idTokenCookieHandler() {
        return this.idTokenCookieHandler;
    }

    public boolean useHeader() {
        return this.useHeader;
    }

    public TokenHandler headerHandler() {
        return this.headerHandler;
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public String cookieValuePrefix() {
        return this.tokenCookieHandler.cookieValuePrefix();
    }

    public String scopeAudience() {
        return this.scopeAudience;
    }

    public String authorizationEndpointUri() {
        return this.authorizationEndpointUri;
    }

    public URI logoutEndpointUri() {
        return this.logoutEndpointUri;
    }

    public String clientId() {
        return this.clientId;
    }

    public String redirectUriWithHost() {
        if (this.frontendUri == null) {
            throw new SecurityException("Frontend URI is not defined");
        }
        return this.frontendUri + this.redirectUri;
    }

    public String redirectUriWithHost(String frontendUri) {
        if (this.frontendUri != null) {
            return this.redirectUriWithHost();
        }
        return frontendUri + this.redirectUri;
    }

    public String baseScopes() {
        return this.baseScopes;
    }

    public boolean validateJwtWithJwk() {
        return this.validateJwtWithJwk;
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public WebTarget introspectEndpoint() {
        return this.introspectEndpoint;
    }

    public URI introspectUri() {
        if (this.introspectUri == null) {
            throw new SecurityException("Introspect URI is not configured when using validate with JWK.");
        }
        return this.introspectUri;
    }

    public String issuer() {
        return this.issuer;
    }

    public String audience() {
        return this.audience;
    }

    public URI identityUri() {
        return this.identityUri;
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public Client generalClient() {
        return this.generalClient;
    }

    public WebClient generalWebClient() {
        return this.webClient;
    }

    @Deprecated(forRemoval=true, since="2.4.0")
    public Client appClient() {
        return this.appClient;
    }

    public WebClient appWebClient() {
        return this.appWebClient;
    }

    public boolean shouldRedirect() {
        return this.redirect;
    }

    public String realm() {
        return this.realm;
    }

    public String redirectAttemptParam() {
        return this.redirectAttemptParam;
    }

    public int maxRedirects() {
        return this.maxRedirects;
    }

    public ClientAuthentication tokenEndpointAuthentication() {
        return this.tokenEndpointAuthentication;
    }

    public void updateRequest(RequestType type, WebClientRequestBuilder request, FormParams.Builder form) {
        if (type == RequestType.CODE_TO_TOKEN && this.tokenEndpointAuthentication == ClientAuthentication.CLIENT_SECRET_POST) {
            form.add("client_id", new String[]{this.clientId});
            form.add("client_secret", new String[]{this.clientSecret});
        }
    }

    public Duration clientTimeout() {
        return this.clientTimeout;
    }

    public CrossOriginConfig crossOriginConfig() {
        return this.crossOriginConfig;
    }

    public Duration tokenRefreshSkew() {
        return this.tokenRefreshSkew;
    }

    @Configured(description="Open ID Connect configuration")
    public static class Builder
    implements io.helidon.common.Builder<Builder, OidcConfig> {
        static final String DEFAULT_SERVER_TYPE = "@default";
        private final OidcCookieHandler.Builder tokenCookieBuilder = OidcCookieHandler.builder().cookieName("JSESSIONID");
        private final OidcCookieHandler.Builder idTokenCookieBuilder = OidcCookieHandler.builder().cookieName("JSESSIONID_2");
        private String issuer;
        private String audience;
        private String baseScopes = "openid";
        private URI identityUri;
        private String clientId;
        private String clientSecret;
        private String redirectUri = "/oidc/redirect";
        private String logoutUri = "/oidc/logout";
        private boolean logoutEnabled = false;
        private boolean useCookie = true;
        private boolean useParam = false;
        private String paramName = "accessToken";
        private String proxyProtocol = "http";
        private String proxyHost;
        private int proxyPort = 80;
        private String scopeAudience;
        private OidcMetadata.Builder oidcMetadata = OidcMetadata.builder();
        private String frontendUri;
        private boolean useHeader = true;
        private TokenHandler headerHandler = TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("bearer ").build();
        private URI tokenEndpointUri;
        private ClientAuthentication tokenEndpointAuthentication = ClientAuthentication.CLIENT_SECRET_BASIC;
        private URI authorizationEndpointUri;
        private URI logoutEndpointUri;
        private JwkKeys signJwk;
        private boolean oidcMetadataWellKnown = true;
        private boolean validateJwtWithJwk = true;
        private URI introspectUri;
        private boolean redirect = false;
        private String realm = "helidon";
        private String redirectAttemptParam = "h_ra";
        private int maxRedirects = 5;
        private boolean cookieSameSiteDefault = true;
        private String serverType;
        @Deprecated
        private Client generalClient;
        @Deprecated
        private WebTarget tokenEndpoint;
        @Deprecated
        private Client appClient;
        private WebClient appWebClient;
        private WebClient webClient;
        private Duration clientTimeout = Duration.ofSeconds(30L);
        private URI postLogoutUri;
        private CrossOriginConfig crossOriginConfig;
        private boolean forceHttpsRedirects = false;
        private Duration tokenRefreshSkew = DEFAULT_TOKEN_REFRESH_SKEW;

        public OidcConfig build() {
            this.serverType = OidcUtil.fixServerType(this.serverType);
            Errors.Collector collector = Errors.collector();
            OidcUtil.validateExists(collector, this.clientId, "Client Id", "client-id");
            OidcUtil.validateExists(collector, this.clientSecret, "Client Secret", "client-secret");
            OidcUtil.validateExists(collector, this.identityUri, "Identity URI", "identity-uri");
            collector.collect().checkValid();
            collector = Errors.collector();
            WebClient.Builder webClientBuilder = OidcUtil.webClientBaseBuilder(this.proxyHost, this.proxyPort, this.clientTimeout);
            ClientBuilder clientBuilder = OidcUtil.clientBaseBuilder(this.proxyProtocol, this.proxyHost, this.proxyPort);
            this.generalClient = clientBuilder.build();
            this.webClient = webClientBuilder.build();
            OidcMetadata oidcMetadata = this.oidcMetadata.webClient(this.webClient).remoteEnabled(this.oidcMetadataWellKnown).identityUri(this.identityUri).collector(collector).build();
            this.tokenEndpointUri = oidcMetadata.getOidcEndpoint(collector, this.tokenEndpointUri, "token_endpoint", "/oauth2/v1/token");
            this.authorizationEndpointUri = oidcMetadata.getOidcEndpoint(collector, this.authorizationEndpointUri, "authorization_endpoint", "/oauth2/v1/authorize");
            this.logoutEndpointUri = oidcMetadata.getOidcEndpoint(collector, this.logoutEndpointUri, "end_session_endpoint", "oauth2/v1/userlogout");
            if (this.issuer == null) {
                oidcMetadata.getString("issuer").ifPresent(it -> {
                    this.issuer = it;
                });
            }
            if (this.audience == null && this.identityUri != null) {
                this.audience = this.identityUri.toString();
            }
            if (this.useCookie && this.logoutEnabled && this.postLogoutUri == null) {
                collector.fatal("post-logout-uri must be defined when logout is enabled.");
            }
            collector.collect().checkValid();
            if (this.cookieSameSiteDefault && this.useCookie && this.identityUri != null) {
                String frontendHost;
                String identityHost = this.identityUri.getHost();
                if (this.frontendUri != null && identityHost.equals(frontendHost = URI.create(this.frontendUri).getHost())) {
                    LOGGER.info("As frontend host and identity host are equal, setting Same-Site policy to Strict this can be overridden using configuration option of OIDC: \"cookie-same-site\"");
                    this.tokenCookieBuilder.sameSite(SetCookie.SameSite.STRICT);
                    this.idTokenCookieBuilder.sameSite(SetCookie.SameSite.STRICT);
                }
            }
            if (this.tokenEndpointAuthentication == ClientAuthentication.CLIENT_SECRET_BASIC) {
                HttpAuthenticationFeature basicAuth = HttpAuthenticationFeature.basicBuilder().credentials(this.clientId, this.clientSecret).build();
                clientBuilder.register((Object)basicAuth);
                HttpBasicAuthProvider httpBasicAuth = HttpBasicAuthProvider.builder().addOutboundTarget(OutboundTarget.builder((String)"oidc").addHost("*").customObject(HttpBasicOutboundConfig.class, (Object)HttpBasicOutboundConfig.create((String)this.clientId, (String)this.clientSecret)).build()).build();
                Security tokenOutboundSecurity = Security.builder().addOutboundSecurityProvider((OutboundSecurityProvider)httpBasicAuth).build();
                webClientBuilder.addService((WebClientService)WebClientSecurity.create((Security)tokenOutboundSecurity));
            }
            this.appClient = clientBuilder.build();
            this.appWebClient = webClientBuilder.build();
            this.tokenEndpoint = this.appClient.target(this.tokenEndpointUri);
            if (this.validateJwtWithJwk) {
                URI jwkUri;
                if (this.signJwk == null && (jwkUri = oidcMetadata.getOidcEndpoint(collector, null, "jwks_uri", null)) != null) {
                    this.signJwk = "idcs".equals(this.serverType) ? IdcsSupport.signJwk(this.appWebClient, this.webClient, this.tokenEndpointUri, jwkUri, this.clientTimeout) : JwkKeys.builder().json((JsonObject)this.webClient.get().uri(jwkUri).request(JsonObject.class).await()).build();
                }
            } else {
                this.introspectUri = oidcMetadata.getOidcEndpoint(collector, this.introspectUri, "introspection_endpoint", "/oauth2/v1/introspect");
            }
            return new OidcConfig(this);
        }

        public Builder config(Config config) {
            config.get("client-id").asString().ifPresent(this::clientId);
            config.get("client-secret").asString().ifPresent(this::clientSecret);
            config.get("identity-uri").as(URI.class).ifPresent(this::identityUri);
            config.get("frontend-uri").asString().ifPresent(this::frontendUri);
            config.get("proxy-protocol").asString().ifPresent(this::proxyProtocol);
            config.get("proxy-host").asString().ifPresent(this::proxyHost);
            config.get("proxy-port").asInt().ifPresent(this::proxyPort);
            config.get("redirect-uri").asString().ifPresent(this::redirectUri);
            config.get("scope-audience").asString().ifPresent(this::scopeAudience);
            config.get("cookie-use").asBoolean().ifPresent(this::useCookie);
            config.get("cookie-name").asString().ifPresent(this::cookieName);
            config.get("cookie-name-id-token").asString().ifPresent(this::cookieNameIdToken);
            config.get("cookie-domain").asString().ifPresent(this::cookieDomain);
            config.get("cookie-path").asString().ifPresent(this::cookiePath);
            config.get("cookie-max-age-seconds").asLong().ifPresent(this::cookieMaxAgeSeconds);
            config.get("cookie-http-only").asBoolean().ifPresent(this::cookieHttpOnly);
            config.get("cookie-secure").asBoolean().ifPresent(this::cookieSecure);
            config.get("cookie-same-site").asString().ifPresent(this::cookieSameSite);
            config.get("query-param-use").asBoolean().ifPresent(this::useParam);
            config.get("query-param-name").asString().ifPresent(this::paramName);
            config.get("header-use").asBoolean().ifPresent(this::useHeader);
            config.get("header-token").as(TokenHandler.class).ifPresent(this::headerTokenHandler);
            config.get("cookie-encryption-enabled").asBoolean().ifPresent(this::cookieEncryptionEnabled);
            config.get("cookie-encryption-password").as(String.class).map(String::toCharArray).ifPresent(this::cookieEncryptionPassword);
            config.get("cookie-encryption-name").asString().ifPresent(this::cookieEncryptionName);
            config.get("base-scopes").asString().ifPresent(this::baseScopes);
            config.get("oidc-metadata.resource").as(Resource::create).ifPresent(this::oidcMetadata);
            config.get("oidc-metadata-well-known").asBoolean().ifPresent(this::oidcMetadataWellKnown);
            config.get("sign-jwk.resource").as(Resource::create).ifPresent(this::signJwk);
            config.get("token-endpoint-uri").as(URI.class).ifPresent(this::tokenEndpointUri);
            config.get("token-endpoint-auth").asString().map(String::toUpperCase).map(ClientAuthentication::valueOf).ifPresent(this::tokenEndpointAuthentication);
            config.get("authorization-endpoint-uri").as(URI.class).ifPresent(this::authorizationEndpointUri);
            config.get("logout-endpoint-uri").as(URI.class).ifPresent(this::logoutEndpointUri);
            config.get("post-logout-uri").as(URI.class).ifPresent(this::postLogoutUri);
            config.get("logout-enabled").asBoolean().ifPresent(this::logoutEnabled);
            config.get("introspect-endpoint-uri").as(URI.class).ifPresent(this::introspectEndpointUri);
            config.get("validate-with-jwk").asBoolean().ifPresent(this::validateJwtWithJwk);
            config.get("issuer").asString().ifPresent(this::issuer);
            config.get("audience").asString().ifPresent(this::audience);
            config.get("redirect").asBoolean().ifPresent(this::redirect);
            config.get("redirect-attempt-param").asString().ifPresent(this::redirectAttemptParam);
            config.get("max-redirects").asInt().ifPresent(this::maxRedirects);
            config.get("force-https-redirects").asBoolean().ifPresent(this::forceHttpsRedirects);
            config.get("server-type").asString().ifPresent(this::serverType);
            config.get("client-timeout-millis").asLong().ifPresent(this::clientTimeoutMillis);
            config.get("cors").as(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            config.get("token-refresh-before-expiration").as(Duration.class).ifPresent(this::tokenRefreshSkew);
            return this;
        }

        public Builder tokenRefreshSkew(Duration tokenRefreshSkew) {
            this.tokenRefreshSkew = tokenRefreshSkew;
            return this;
        }

        public Builder cookieEncryptionName(String cookieEncryptionName) {
            this.tokenCookieBuilder.encryptionName(cookieEncryptionName);
            this.idTokenCookieBuilder.encryptionName(cookieEncryptionName);
            return this;
        }

        public Builder cookieEncryptionPassword(char[] cookieEncryptionPassword) {
            this.tokenCookieBuilder.encryptionPassword(cookieEncryptionPassword);
            this.idTokenCookieBuilder.encryptionPassword(cookieEncryptionPassword);
            return this;
        }

        public Builder cookieEncryptionEnabled(boolean cookieEncryptionEnabled) {
            this.tokenCookieBuilder.encryptionEnabled(cookieEncryptionEnabled);
            return this;
        }

        public Builder cookieEncryptionEnabledIdToken(boolean cookieEncryptionEnabled) {
            this.idTokenCookieBuilder.encryptionEnabled(cookieEncryptionEnabled);
            return this;
        }

        public Builder crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            this.crossOriginConfig = crossOriginConfig;
            return this;
        }

        public Builder logoutEnabled(Boolean logoutEnabled) {
            this.logoutEnabled = logoutEnabled;
            return this;
        }

        public Builder redirect(boolean redirect) {
            this.redirect = redirect;
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder validateJwtWithJwk(Boolean useJwk) {
            this.validateJwtWithJwk = useJwk;
            return this;
        }

        public Builder introspectEndpointUri(URI uri) {
            this.validateJwtWithJwk(false);
            this.introspectUri = uri;
            return this;
        }

        public Builder baseScopes(String scopes) {
            this.baseScopes = scopes;
            return this;
        }

        public Builder oidcMetadataWellKnown(Boolean useWellKnown) {
            this.oidcMetadataWellKnown = useWellKnown;
            return this;
        }

        public Builder signJwk(Resource resource) {
            this.validateJwtWithJwk(true);
            this.signJwk = JwkKeys.builder().resource(resource).build();
            return this;
        }

        public Builder signJwk(JwkKeys jwk) {
            this.validateJwtWithJwk(true);
            this.signJwk = jwk;
            return this;
        }

        public Builder oidcMetadata(Resource resource) {
            this.oidcMetadata.json(JSON.createReader(resource.stream()).readObject());
            return this;
        }

        public Builder oidcMetadata(JsonObject metadata) {
            this.oidcMetadata.json(metadata);
            return this;
        }

        public Builder headerTokenHandler(TokenHandler tokenHandler) {
            this.headerHandler = tokenHandler;
            return this;
        }

        public Builder useHeader(Boolean useHeader) {
            this.useHeader = useHeader;
            return this;
        }

        public Builder scopeAudience(String audience) {
            this.scopeAudience = audience;
            return this;
        }

        public Builder cookieSameSite(String sameSite) {
            return this.cookieSameSite(SetCookie.SameSite.valueOf((String)sameSite.toUpperCase(Locale.ROOT)));
        }

        public Builder cookieSameSite(SetCookie.SameSite sameSite) {
            this.tokenCookieBuilder.sameSite(sameSite);
            this.idTokenCookieBuilder.sameSite(sameSite);
            this.cookieSameSiteDefault = false;
            return this;
        }

        public Builder cookieSecure(Boolean secure) {
            this.tokenCookieBuilder.secure(secure);
            this.idTokenCookieBuilder.secure(secure);
            return this;
        }

        public Builder cookieHttpOnly(Boolean httpOnly) {
            this.tokenCookieBuilder.httpOnly(httpOnly);
            this.idTokenCookieBuilder.httpOnly(httpOnly);
            return this;
        }

        public Builder cookieMaxAgeSeconds(long age) {
            this.tokenCookieBuilder.maxAge(age);
            this.idTokenCookieBuilder.maxAge(age);
            return this;
        }

        public Builder cookiePath(String path) {
            this.tokenCookieBuilder.path(path);
            this.idTokenCookieBuilder.path(path);
            return this;
        }

        public Builder cookieDomain(String domain) {
            this.tokenCookieBuilder.domain(domain);
            this.idTokenCookieBuilder.domain(domain);
            return this;
        }

        public Builder frontendUri(String uri) {
            this.frontendUri = uri;
            return this;
        }

        public Builder tokenEndpointUri(URI uri) {
            this.tokenEndpointUri = uri;
            return this;
        }

        public Builder tokenEndpointAuthentication(ClientAuthentication tokenEndpointAuthentication) {
            switch (tokenEndpointAuthentication) {
                case CLIENT_SECRET_BASIC: 
                case CLIENT_SECRET_POST: 
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Token endpoint authentication type " + tokenEndpointAuthentication + " is not supported.");
                }
            }
            this.tokenEndpointAuthentication = tokenEndpointAuthentication;
            return this;
        }

        public Builder authorizationEndpointUri(URI uri) {
            this.authorizationEndpointUri = uri;
            return this;
        }

        public Builder logoutEndpointUri(URI logoutEndpointUri) {
            this.logoutEndpointUri = logoutEndpointUri;
            return this;
        }

        public Builder cookieName(String cookieName) {
            this.tokenCookieBuilder.cookieName(cookieName);
            return this;
        }

        public Builder cookieNameIdToken(String cookieName) {
            this.idTokenCookieBuilder.cookieName(cookieName);
            return this;
        }

        public Builder useCookie(Boolean useCookie) {
            this.useCookie = useCookie;
            return this;
        }

        public Builder forceHttpsRedirects(boolean forceHttpsRedirects) {
            this.forceHttpsRedirects = forceHttpsRedirects;
            return this;
        }

        public Builder paramName(String paramName) {
            this.paramName = paramName;
            return this;
        }

        public Builder useParam(Boolean useParam) {
            this.useParam = useParam;
            return this;
        }

        public Builder identityUri(URI uri) {
            this.identityUri = uri;
            return this;
        }

        public Builder proxyProtocol(String protocol) {
            this.proxyProtocol = protocol;
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost == null || proxyHost.isEmpty() ? null : proxyHost;
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder logoutUri(String logoutUri) {
            this.logoutUri = logoutUri;
            return this;
        }

        public Builder postLogoutUri(URI uri) {
            this.postLogoutUri = uri;
            return this;
        }

        public Builder redirectAttemptParam(String paramName) {
            this.redirectAttemptParam = paramName;
            return this;
        }

        public Builder maxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public Builder serverType(String type) {
            this.serverType = type;
            return this;
        }

        public Builder clientTimeout(Duration duration) {
            this.clientTimeout = duration;
            return this;
        }

        private void clientTimeoutMillis(long millis) {
            this.clientTimeout(Duration.ofMillis(millis));
        }
    }

    public static enum ClientAuthentication {
        CLIENT_SECRET_BASIC,
        CLIENT_SECRET_POST,
        CLIENT_SECRET_JWT,
        PRIVATE_KEY_JWT,
        NONE;

    }

    public static enum RequestType {
        CODE_TO_TOKEN,
        INTROSPECT_JWT;

    }
}

