/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.Errors;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.jsonp.JsonpSupport;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.WebClient;
import io.helidon.webclient.spi.WebClientService;
import io.helidon.webclient.tracing.WebClientTracing;
import jakarta.ws.rs.client.ClientBuilder;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

final class OidcUtil {
    private static final Logger LOGGER = Logger.getLogger(OidcUtil.class.getName());

    private OidcUtil() {
    }

    static String fixServerType(String serverType) {
        if (serverType != null) {
            if (!"idcs".equals(serverType) && !"@default".equals(serverType)) {
                LOGGER.warning("OIDC server-type is configured to " + serverType + ", currently only \"idcs\", and \"@default\" are supported");
                return "@default";
            }
        } else {
            return "@default";
        }
        return serverType;
    }

    static ClientBuilder clientBaseBuilder(String proxyProtocol, String proxyHost, int proxyPort) {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.property("io.helidon.security.client.disable", (Object)Boolean.TRUE);
        if (proxyHost != null) {
            clientBuilder.property("jersey.config.client.proxy.uri", (Object)(proxyProtocol + "://" + proxyHost + ":" + proxyPort));
        }
        return clientBuilder;
    }

    static WebClient.Builder webClientBaseBuilder(String proxyHost, int proxyPort, Duration clientTimeout) {
        WebClient.Builder webClientBuilder = WebClient.builder().addService((WebClientService)WebClientTracing.create()).addMediaSupport((MediaSupport)JsonpSupport.create()).connectTimeout(clientTimeout.toMillis(), TimeUnit.MILLISECONDS).readTimeout(clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (proxyHost != null) {
            webClientBuilder.proxy(Proxy.builder().type(Proxy.ProxyType.HTTP).host(proxyHost).port(proxyPort).build());
        }
        return webClientBuilder;
    }

    static void validateExists(Errors.Collector collector, Object value, String name, String configKey) {
        if (value == null) {
            collector.fatal(name + " must be configured (\"" + configKey + "\" key in config)");
        }
    }
}

