/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.http.FormParams;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.security.SecurityException;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.webclient.WebClient;
import io.helidon.webclient.WebClientResponse;
import jakarta.json.JsonObject;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

class IdcsSupport {
    private IdcsSupport() {
    }

    static JwkKeys signJwk(WebClient appWebClient, WebClient generalClient, URI tokenEndpointUri, URI signJwkUri, Duration clientTimeout) {
        FormParams form = FormParams.builder().add("grant_type", new String[]{"client_credentials"}).add("scope", new String[]{"urn:opc:idm:__myscopes__"}).build();
        try {
            WebClientResponse response = (WebClientResponse)appWebClient.post().uri(tokenEndpointUri).accept(new MediaType[]{MediaType.APPLICATION_JSON}).submit((Object)form).await(clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
            if (response.status().family() == Http.ResponseStatus.Family.SUCCESSFUL) {
                JsonObject json = (JsonObject)response.content().as(JsonObject.class).await(clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
                String accessToken = json.getString("access_token");
                JsonObject jwkJson = (JsonObject)generalClient.get().uri(signJwkUri).headers(it -> {
                    it.add("Authorization", new String[]{"Bearer " + accessToken});
                    return it;
                }).request(JsonObject.class).await(clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
                return JwkKeys.create((JsonObject)jwkJson);
            }
            String errorEntity = (String)response.content().as(String.class).await(clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
            throw new SecurityException("Failed to read JWK from IDCS. Status: " + response.status() + ", entity: " + errorEntity);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SecurityException("Failed to read JWK from IDCS", (Throwable)e);
        }
    }
}

