/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.Errors;
import io.helidon.webclient.WebClient;
import jakarta.json.JsonObject;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

final class OidcMetadata {
    private static final Logger LOGGER = Logger.getLogger(OidcMetadata.class.getName());
    private static final String DEFAULT_OIDC_METADATA_URI = "/.well-known/openid-configuration";
    private final JsonObject oidcMetadata;
    private final URI identityUri;

    private OidcMetadata(Builder builder) {
        this.oidcMetadata = builder.metadata;
        this.identityUri = builder.identityUri;
    }

    URI getOidcEndpoint(Errors.Collector collector, URI currentValue, String metaKey, String defaultUri) {
        if (currentValue != null) {
            LOGGER.finest(() -> metaKey + " explicitly configured: " + currentValue);
            return currentValue;
        }
        URI foundValue = null;
        if (this.oidcMetadata == null) {
            if (this.identityUri == null) {
                collector.fatal("Identity URI is not defined, cannot provide endpoint for " + metaKey);
                return null;
            }
        } else {
            String jsonValue = this.oidcMetadata.getString(metaKey, null);
            if (jsonValue != null) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(metaKey + " loaded from well known metadata: " + jsonValue);
                }
                foundValue = URI.create(jsonValue);
            }
        }
        if (foundValue != null) {
            return foundValue;
        }
        if (defaultUri == null) {
            collector.fatal(metaKey + " default URI is not defined and URI was not in OIDC metadata");
            return null;
        }
        return this.identityUri.resolve(defaultUri);
    }

    static Builder builder() {
        return new Builder();
    }

    public Optional<String> getString(String key) {
        return Optional.ofNullable(this.oidcMetadata).map(it -> it.getString(key, null));
    }

    static class Builder
    implements io.helidon.common.Builder<Builder, OidcMetadata> {
        private boolean enableRemoteLoad;
        private JsonObject metadata;
        private WebClient webClient;
        private Errors.Collector collector = Errors.collector();
        private URI identityUri;

        private Builder() {
        }

        public OidcMetadata build() {
            if (this.metadata == null && this.enableRemoteLoad) {
                this.load();
            }
            return new OidcMetadata(this);
        }

        Builder remoteEnabled(boolean enableRemoteLoad) {
            this.enableRemoteLoad = enableRemoteLoad;
            return this;
        }

        Builder json(JsonObject jsonObject) {
            this.metadata = jsonObject;
            return this;
        }

        Builder webClient(WebClient webClient) {
            this.webClient = webClient;
            return this;
        }

        Builder collector(Errors.Collector collector) {
            this.collector = collector;
            return this;
        }

        Builder identityUri(URI identityUri) {
            this.identityUri = identityUri;
            return this;
        }

        private void load() {
            URI wellKnown = this.identityUri.resolve(Builder.fixPath(this.identityUri.getPath(), OidcMetadata.DEFAULT_OIDC_METADATA_URI));
            try {
                this.metadata = (JsonObject)this.webClient.get().uri(wellKnown).request(JsonObject.class).await(Duration.ofSeconds(20L));
                LOGGER.finest(() -> "OIDC Metadata loaded from well known URI: " + wellKnown);
            }
            catch (Exception e) {
                this.collector.fatal((Object)e, "Failed to load metadata: " + e.getClass().getName() + ": " + e.getMessage() + " from " + wellKnown);
            }
        }

        static String fixPath(String basePath, String relativePath) {
            if (basePath == null || basePath.isEmpty()) {
                if (relativePath == null || relativePath.isEmpty()) {
                    return "/";
                }
                return Builder.startsWithSlash(relativePath) ? relativePath : "/" + relativePath;
            }
            if (relativePath == null || relativePath.isEmpty()) {
                return basePath;
            }
            if (Builder.endsWithSlash(basePath)) {
                return Builder.startsWithSlash(relativePath) ? basePath + relativePath.substring(1) : basePath + relativePath;
            }
            return Builder.startsWithSlash(relativePath) ? basePath + relativePath : basePath + "/" + relativePath;
        }

        private static boolean startsWithSlash(String toTest) {
            return toTest.charAt(0) == '/';
        }

        private static boolean endsWithSlash(String toTest) {
            return toTest.charAt(toTest.length() - 1) == '/';
        }
    }
}

