/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.Builder;
import io.helidon.common.Errors;
import io.helidon.common.config.Config;
import io.helidon.common.configurable.Resource;
import io.helidon.config.DeprecatedConfig;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.providers.oidc.common.OidcConfig;
import io.helidon.security.providers.oidc.common.OidcUtil;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;

@Configured
abstract class BaseBuilder<B extends BaseBuilder<B, T>, T>
implements Builder<B, T> {
    static final String DEFAULT_SERVER_TYPE = "@default";
    static final String DEFAULT_BASE_SCOPES = "openid";
    static final String DEFAULT_REALM = "helidon";
    static final boolean DEFAULT_JWT_VALIDATE_JWK = true;
    static final int DEFAULT_TIMEOUT_SECONDS = 30;
    private static final JsonReaderFactory JSON = Json.createReaderFactory(Collections.emptyMap());
    private JsonObject oidcMetadata;
    private OidcConfig.ClientAuthentication tokenEndpointAuthentication = OidcConfig.ClientAuthentication.CLIENT_SECRET_BASIC;
    private String clientId;
    private String clientSecret;
    private String baseScopes = "openid";
    private String realm = "helidon";
    private String issuer;
    private String audience;
    private String serverType;
    private URI authorizationEndpointUri;
    private URI logoutEndpointUri;
    private URI identityUri;
    private URI tokenEndpointUri;
    private Duration clientTimeout = Duration.ofSeconds(30L);
    private JwkKeys signJwk;
    private boolean validateJwtWithJwk = true;
    private URI introspectUri;
    private String scopeAudience;
    private boolean useWellKnown = true;
    private boolean optionalAudience = false;
    private boolean checkAudience = true;

    BaseBuilder() {
    }

    void buildConfiguration() {
        this.serverType = OidcUtil.fixServerType(this.serverType);
        Errors.Collector collector = Errors.collector();
        OidcUtil.validateExists(collector, this.clientId, "Client Id", "client-id");
        if (this.tokenEndpointAuthentication != OidcConfig.ClientAuthentication.CLIENT_CERTIFICATE || this.serverType.equals("idcs")) {
            OidcUtil.validateExists(collector, this.clientSecret, "Client Secret", "client-secret");
        }
        OidcUtil.validateExists(collector, this.identityUri, "Identity URI", "identity-uri");
        if (this.audience == null && !this.optionalAudience && this.identityUri != null) {
            this.audience = this.identityUri.toString();
        }
        collector.collect().checkValid();
    }

    public B config(Config config) {
        config.get("client-id").asString().ifPresent(this::clientId);
        config.get("client-secret").asString().ifPresent(this::clientSecret);
        config.get("identity-uri").as(URI.class).ifPresent(this::identityUri);
        config.get("oidc-metadata.resource").map(Resource::create).ifPresent(this::oidcMetadata);
        config.get("base-scopes").asString().ifPresent(this::baseScopes);
        config.get("oidc-metadata.resource").map(Resource::create).ifPresent(this::oidcMetadata);
        config.get("oidc-metadata-well-known").asBoolean().ifPresent(this::oidcMetadataWellKnown);
        config.get("scope-audience").asString().ifPresent(this::scopeAudience);
        config.get("token-endpoint-auth").asString().map(String::toUpperCase).map(OidcConfig.ClientAuthentication::valueOf).ifPresent(this::tokenEndpointAuthentication);
        config.get("authorization-endpoint-uri").as(URI.class).ifPresent(this::authorizationEndpointUri);
        config.get("token-endpoint-uri").as(URI.class).ifPresent(this::tokenEndpointUri);
        config.get("logout-endpoint-uri").as(URI.class).ifPresent(this::logoutEndpointUri);
        config.get("sign-jwk.resource").map(Resource::create).ifPresent(this::signJwk);
        config.get("introspect-endpoint-uri").as(URI.class).ifPresent(this::introspectEndpointUri);
        DeprecatedConfig.get((Config)config, (String)"validate-jwt-with-jwk", (String)"validate-with-jwk").asBoolean().ifPresent(this::validateJwtWithJwk);
        config.get("issuer").asString().ifPresent(this::issuer);
        config.get("audience").asString().ifPresent(this::audience);
        config.get("server-type").asString().ifPresent(this::serverType);
        config.get("client-timeout-millis").asLong().ifPresent(this::clientTimeoutMillis);
        config.get("optional-audience").asBoolean().ifPresent(this::optionalAudience);
        config.get("check-audience").asBoolean().ifPresent(this::checkAudience);
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption
    public B clientId(String clientId) {
        this.clientId = clientId;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption
    public B clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption
    public B identityUri(URI uri) {
        this.identityUri = uri;
        return (B)((BaseBuilder)this.identity());
    }

    public B realm(String realm) {
        this.realm = realm;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption
    public B audience(String audience) {
        this.audience = audience;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption
    public B issuer(String issuer) {
        this.issuer = issuer;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption(value="true")
    public B validateJwtWithJwk(Boolean useJwk) {
        this.validateJwtWithJwk = useJwk;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption
    public B introspectEndpointUri(URI uri) {
        this.validateJwtWithJwk(false);
        this.introspectUri = uri;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption(key="sign-jwk.resource")
    public B signJwk(Resource resource) {
        this.validateJwtWithJwk(true);
        this.signJwk = JwkKeys.builder().resource(resource).build();
        return (B)((BaseBuilder)this.identity());
    }

    public B signJwk(JwkKeys jwk) {
        this.validateJwtWithJwk(true);
        this.signJwk = jwk;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption(key="token-endpoint-auth", value="CLIENT_SECRET_BASIC")
    public B tokenEndpointAuthentication(OidcConfig.ClientAuthentication tokenEndpointAuthentication) {
        switch (tokenEndpointAuthentication) {
            case CLIENT_SECRET_BASIC: 
            case CLIENT_SECRET_POST: 
            case CLIENT_CERTIFICATE: 
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Token endpoint authentication type " + String.valueOf((Object)tokenEndpointAuthentication) + " is not supported.");
            }
        }
        this.tokenEndpointAuthentication = tokenEndpointAuthentication;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption
    public B authorizationEndpointUri(URI uri) {
        this.authorizationEndpointUri = uri;
        return (B)((BaseBuilder)this.identity());
    }

    public B logoutEndpointUri(URI logoutEndpointUri) {
        this.logoutEndpointUri = logoutEndpointUri;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption
    public B tokenEndpointUri(URI uri) {
        this.tokenEndpointUri = uri;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption(key="oidc-metadata.resource")
    public B oidcMetadata(Resource resource) {
        return this.oidcMetadata(JSON.createReader(resource.stream()).readObject());
    }

    public B oidcMetadata(JsonObject metadata) {
        this.oidcMetadata = metadata;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption(value="openid")
    public B baseScopes(String scopes) {
        this.baseScopes = scopes;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption(value="true")
    public B oidcMetadataWellKnown(boolean useWellKnown) {
        this.useWellKnown = useWellKnown;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption(value="@default")
    public B serverType(String type) {
        this.serverType = type;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption(key="client-timeout-millis", value="30000")
    public B clientTimeout(Duration duration) {
        this.clientTimeout = duration;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption
    public B scopeAudience(String audience) {
        this.scopeAudience = audience;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption(value="false")
    public B optionalAudience(boolean optional) {
        this.optionalAudience = optional;
        return (B)((BaseBuilder)this.identity());
    }

    @ConfiguredOption(value="false")
    public B checkAudience(boolean checkAudience) {
        this.checkAudience = checkAudience;
        return (B)((BaseBuilder)this.identity());
    }

    private void clientTimeoutMillis(long millis) {
        this.clientTimeout(Duration.ofMillis(millis));
    }

    OidcConfig.ClientAuthentication tokenEndpointAuthentication() {
        return this.tokenEndpointAuthentication;
    }

    JsonObject oidcMetadata() {
        return this.oidcMetadata;
    }

    public boolean useWellKnown() {
        return this.useWellKnown;
    }

    String clientId() {
        return this.clientId;
    }

    String clientSecret() {
        return this.clientSecret;
    }

    String baseScopes() {
        return this.baseScopes;
    }

    String realm() {
        return this.realm;
    }

    String issuer() {
        return this.issuer;
    }

    String audience() {
        return this.audience;
    }

    boolean checkAudience() {
        return this.checkAudience;
    }

    String serverType() {
        return this.serverType;
    }

    URI authorizationEndpointUri() {
        return this.authorizationEndpointUri;
    }

    URI logoutEndpointUri() {
        return this.logoutEndpointUri;
    }

    URI identityUri() {
        return this.identityUri;
    }

    URI tokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    Duration clientTimeout() {
        return this.clientTimeout;
    }

    JwkKeys signJwk() {
        return this.signJwk;
    }

    boolean validateJwtWithJwk() {
        return this.validateJwtWithJwk;
    }

    URI introspectUri() {
        return this.introspectUri;
    }

    String scopeAudience() {
        return this.scopeAudience;
    }

    String name() {
        return DEFAULT_SERVER_TYPE;
    }
}

