/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.Errors;
import io.helidon.common.LazyValue;
import io.helidon.common.config.Config;
import io.helidon.common.socket.SocketOptions;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.http.SetCookie;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.MediaContextConfig;
import io.helidon.http.media.jsonp.JsonpSupport;
import io.helidon.security.SecurityException;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.providers.oidc.common.BaseBuilder;
import io.helidon.security.providers.oidc.common.OidcCookieHandler;
import io.helidon.security.providers.oidc.common.Tenant;
import io.helidon.security.providers.oidc.common.TenantConfig;
import io.helidon.security.providers.oidc.common.TenantConfigImpl;
import io.helidon.security.util.TokenHandler;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import io.helidon.webclient.tracing.WebClientTracing;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class OidcConfig
extends TenantConfigImpl {
    public static final String PARAM_HEADER_NAME = "X_OIDC_TOKEN_HEADER";
    public static final String PARAM_ID_HEADER_NAME = "X_OIDC_ID_TOKEN_HEADER";
    public static final String DEFAULT_TENANT_PARAM_NAME = "h_tenant";
    public static final String DEFAULT_COOKIE_NAME = "JSESSIONID";
    public static final String DEFAULT_ID_COOKIE_NAME = "JSESSIONID_2";
    public static final String DEFAULT_REFRESH_COOKIE_NAME = "JSESSIONID_3";
    public static final String DEFAULT_TENANT_COOKIE_NAME = "HELIDON_TENANT";
    public static final String DEFAULT_STATE_COOKIE_NAME = "OIDC_STATE";
    static final String DEFAULT_REDIRECT_URI = "/oidc/redirect";
    static final String DEFAULT_LOGOUT_URI = "/oidc/logout";
    static final boolean DEFAULT_REDIRECT = true;
    static final String DEFAULT_ATTEMPT_PARAM = "h_ra";
    static final int DEFAULT_MAX_REDIRECTS = 5;
    static final boolean DEFAULT_FORCE_HTTPS_REDIRECTS = false;
    static final Duration DEFAULT_TOKEN_REFRESH_SKEW = Duration.ofSeconds(5L);
    static final boolean DEFAULT_RELATIVE_URIS = false;
    static final int DEFAULT_PROXY_PORT = 80;
    static final String DEFAULT_PROXY_PROTOCOL = "http";
    static final String TENANT_IDENT = "name";
    static final String DEFAULT_PARAM_NAME = "accessToken";
    static final String DEFAULT_ID_TOKEN_PARAM_NAME = "id_token";
    static final boolean DEFAULT_PARAM_USE = false;
    static final boolean DEFAULT_HEADER_USE = false;
    static final boolean DEFAULT_COOKIE_USE = true;
    private static final System.Logger LOGGER = System.getLogger(OidcConfig.class.getName());
    private final Map<String, TenantConfig> tenantConfigurations;
    private final String redirectUri;
    private final String logoutUri;
    private final boolean logoutEnabled;
    private final String frontendUri;
    private final boolean redirect;
    private final String redirectAttemptParam;
    private final int maxRedirects;
    private final URI postLogoutUri;
    private final CrossOriginConfig crossOriginConfig;
    private final boolean forceHttpsRedirects;
    private final Duration tokenRefreshSkew;
    private final boolean relativeUris;
    private final WebClient webClient;
    private final Supplier<WebClientConfig.Builder> webClientBuilderSupplier;
    private final LazyValue<Tenant> defaultTenant;
    private final boolean useParam;
    private final String paramName;
    private final String idTokenParamName;
    private final String tenantParamName;
    private final boolean useHeader;
    private final TokenHandler headerHandler;
    private final boolean useCookie;
    private final OidcCookieHandler tokenCookieHandler;
    private final OidcCookieHandler idTokenCookieHandler;
    private final OidcCookieHandler refreshTokenCookieHandler;
    private final OidcCookieHandler tenantCookieHandler;
    private final OidcCookieHandler stateCookieHandler;
    private final boolean tokenSignatureValidation;
    private final boolean idTokenSignatureValidation;
    private final boolean accessTokenIpCheck;

    private OidcConfig(Builder builder) {
        super(builder);
        this.frontendUri = builder.frontendUri;
        this.redirectUri = builder.redirectUri;
        this.logoutUri = builder.logoutUri;
        this.logoutEnabled = builder.logoutEnabled;
        this.postLogoutUri = builder.postLogoutUri;
        this.redirect = builder.redirect;
        this.redirectAttemptParam = builder.redirectAttemptParam;
        this.maxRedirects = builder.maxRedirects;
        this.forceHttpsRedirects = builder.forceHttpsRedirects;
        this.crossOriginConfig = builder.crossOriginConfig;
        this.tokenRefreshSkew = builder.tokenRefreshSkew;
        this.tenantConfigurations = Map.copyOf(builder.tenantConfigurations);
        this.webClient = builder.webClient;
        this.relativeUris = builder.relativeUris;
        this.useParam = builder.useParam;
        this.paramName = builder.paramName;
        this.idTokenParamName = builder.idTokenParamName;
        this.tenantParamName = builder.tenantParamName;
        this.useHeader = builder.useHeader;
        this.headerHandler = builder.headerHandler;
        this.useCookie = builder.useCookie;
        this.tokenCookieHandler = builder.tokenCookieBuilder.build();
        this.idTokenCookieHandler = builder.idTokenCookieBuilder.build();
        this.tenantCookieHandler = builder.tenantCookieBuilder.build();
        this.refreshTokenCookieHandler = builder.refreshTokenCookieBuilder.build();
        this.stateCookieHandler = builder.stateCookieBuilder.build();
        this.tokenSignatureValidation = builder.tokenSignatureValidation;
        this.idTokenSignatureValidation = builder.idTokenSignatureValidation;
        this.accessTokenIpCheck = builder.accessTokenIpCheck;
        this.webClientBuilderSupplier = builder.webClientBuilderSupplier;
        this.defaultTenant = LazyValue.create(() -> Tenant.create(this, this));
        LOGGER.log(System.Logger.Level.TRACE, () -> "Redirect URI with host: " + this.frontendUri + this.redirectUri);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OidcConfig create(Config config) {
        return OidcConfig.builder().config(config).build();
    }

    public boolean useParam() {
        return this.useParam;
    }

    public String paramName() {
        return this.paramName;
    }

    public String idTokenParamName() {
        return this.idTokenParamName;
    }

    public String tenantParamName() {
        return this.tenantParamName;
    }

    public boolean useHeader() {
        return this.useHeader;
    }

    public TokenHandler headerHandler() {
        return this.headerHandler;
    }

    public boolean useCookie() {
        return this.useCookie;
    }

    public OidcCookieHandler tokenCookieHandler() {
        return this.tokenCookieHandler;
    }

    public OidcCookieHandler idTokenCookieHandler() {
        return this.idTokenCookieHandler;
    }

    public OidcCookieHandler tenantCookieHandler() {
        return this.tenantCookieHandler;
    }

    public OidcCookieHandler refreshTokenCookieHandler() {
        return this.refreshTokenCookieHandler;
    }

    public OidcCookieHandler stateCookieHandler() {
        return this.stateCookieHandler;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public boolean forceHttpsRedirects() {
        return this.forceHttpsRedirects;
    }

    public boolean logoutEnabled() {
        return this.logoutEnabled;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public URI postLogoutUri() {
        return this.postLogoutUri;
    }

    public String redirectUriWithHost() {
        if (this.frontendUri == null) {
            throw new SecurityException("Frontend URI is not defined");
        }
        return this.frontendUri + this.redirectUri;
    }

    public String redirectUriWithHost(String frontendUri) {
        if (this.frontendUri != null) {
            return this.redirectUriWithHost();
        }
        return frontendUri + this.redirectUri;
    }

    public boolean shouldRedirect() {
        return this.redirect;
    }

    public String redirectAttemptParam() {
        return this.redirectAttemptParam;
    }

    public int maxRedirects() {
        return this.maxRedirects;
    }

    public CrossOriginConfig crossOriginConfig() {
        return this.crossOriginConfig;
    }

    public Duration tokenRefreshSkew() {
        return this.tokenRefreshSkew;
    }

    @Deprecated(since="4.2.1", forRemoval=true)
    public boolean relativeUris() {
        return this.relativeUris;
    }

    public WebClient generalWebClient() {
        return this.webClient;
    }

    public WebClient appWebClient() {
        return ((Tenant)this.defaultTenant.get()).appWebClient();
    }

    public TenantConfig tenantConfig(String tenantId) {
        TenantConfig tenantConfig = this.tenantConfigurations.get(tenantId);
        if (tenantConfig == null) {
            return this.tenantConfigurations.getOrDefault("@default", this);
        }
        return tenantConfig;
    }

    public URI tokenEndpointUri() {
        return ((Tenant)this.defaultTenant.get()).tokenEndpointUri();
    }

    public String authorizationEndpointUri() {
        return ((Tenant)this.defaultTenant.get()).authorizationEndpointUri();
    }

    public URI logoutEndpointUri() {
        return ((Tenant)this.defaultTenant.get()).logoutEndpointUri();
    }

    public String issuer() {
        return ((Tenant)this.defaultTenant.get()).issuer();
    }

    public JwkKeys signJwk() {
        return ((Tenant)this.defaultTenant.get()).signJwk();
    }

    public URI introspectUri() {
        return ((Tenant)this.defaultTenant.get()).introspectUri();
    }

    public boolean tokenSignatureValidation() {
        return this.tokenSignatureValidation;
    }

    public boolean idTokenSignatureValidation() {
        return this.idTokenSignatureValidation;
    }

    public boolean accessTokenIpCheck() {
        return this.accessTokenIpCheck;
    }

    Supplier<WebClientConfig.Builder> webClientBuilderSupplier() {
        return this.webClientBuilderSupplier;
    }

    @Configured(description="Open ID Connect configuration")
    public static class Builder
    extends BaseBuilder<Builder, OidcConfig> {
        private final Map<String, TenantConfig> tenantConfigurations = new HashMap<String, TenantConfig>();
        private String redirectUri = "/oidc/redirect";
        private String logoutUri = "/oidc/logout";
        private boolean logoutEnabled = false;
        private String frontendUri;
        private boolean redirect = true;
        private String redirectAttemptParam = "h_ra";
        private int maxRedirects = 5;
        private URI postLogoutUri;
        private CrossOriginConfig crossOriginConfig;
        private boolean forceHttpsRedirects = false;
        private Duration tokenRefreshSkew = DEFAULT_TOKEN_REFRESH_SKEW;
        private String proxyHost;
        private String proxyProtocol = "http";
        private int proxyPort = 80;
        private WebClient webClient;
        private Supplier<WebClientConfig.Builder> webClientBuilderSupplier;
        private String paramName = "accessToken";
        private String idTokenParamName = "id_token";
        private String tenantParamName = "h_tenant";
        private boolean useHeader = false;
        private boolean useParam = false;
        private final OidcCookieHandler.Builder tenantCookieBuilder = OidcCookieHandler.builder().encryptionEnabled(true).cookieName("HELIDON_TENANT");
        private final OidcCookieHandler.Builder tokenCookieBuilder = OidcCookieHandler.builder().cookieName("JSESSIONID");
        private final OidcCookieHandler.Builder idTokenCookieBuilder = OidcCookieHandler.builder().encryptionEnabled(true).cookieName("JSESSIONID_2");
        private final OidcCookieHandler.Builder refreshTokenCookieBuilder = OidcCookieHandler.builder().encryptionEnabled(true).cookieName("JSESSIONID_3");
        private final OidcCookieHandler.Builder stateCookieBuilder = OidcCookieHandler.builder().encryptionEnabled(true).cookieName("OIDC_STATE");
        private TokenHandler headerHandler = TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("bearer ").build();
        private boolean useCookie = true;
        private boolean cookieSameSiteDefault = true;
        private boolean relativeUris = false;
        private boolean tokenSignatureValidation = true;
        private boolean idTokenSignatureValidation = true;
        private boolean accessTokenIpCheck = true;
        private WebClientConfig.Builder webClientConfigBuilder = (WebClientConfig.Builder)((WebClientConfig.Builder)((WebClientConfig.Builder)((WebClientConfig.Builder)WebClientConfig.builder().addService(WebClientTracing.create())).servicesDiscoverServices(false)).addProtocolPreference("http/1.1")).mediaContext(((MediaContextConfig.Builder)((MediaContextConfig.Builder)MediaContext.builder().mediaSupportsDiscoverServices(false)).addMediaSupport(JsonpSupport.create((Config)Config.empty()))).build());

        protected Builder() {
        }

        public OidcConfig build() {
            this.buildConfiguration();
            Errors.Collector collector = Errors.collector();
            if (this.useCookie && this.logoutEnabled && this.postLogoutUri == null) {
                collector.fatal("post-logout-uri must be defined when logout is enabled.");
            }
            collector.collect().checkValid();
            if (this.cookieSameSiteDefault && this.useCookie && this.identityUri() != null) {
                String frontendHost;
                String identityHost = this.identityUri().getHost();
                if (this.frontendUri != null && identityHost.equals(frontendHost = URI.create(this.frontendUri).getHost())) {
                    LOGGER.log(System.Logger.Level.INFO, "As frontend host and identity host are equal, setting Same-Site policy to Strict this can be overridden using configuration option of OIDC: \"cookie-same-site\"");
                    this.tenantCookieBuilder.sameSite(SetCookie.SameSite.STRICT);
                    this.tokenCookieBuilder.sameSite(SetCookie.SameSite.STRICT);
                    this.idTokenCookieBuilder.sameSite(SetCookie.SameSite.STRICT);
                }
            }
            this.webClientBuilderSupplier = () -> this.webClientBaseBuilder(this.proxyProtocol, this.proxyHost, this.proxyPort);
            this.webClient = this.webClientBuilderSupplier.get().build();
            if (!this.tokenSignatureValidation) {
                LOGGER.log(System.Logger.Level.WARNING, "You have disabled access token signature validation. This option should never be disabled for production environment since it could cause security issues");
            }
            if (!this.idTokenSignatureValidation) {
                LOGGER.log(System.Logger.Level.WARNING, "You have disabled id token signature validation. This option should never be disabled for production environment since it could cause security issues");
            }
            return new OidcConfig(this);
        }

        private WebClientConfig.Builder webClientBaseBuilder(String proxyProtocol, String proxyHost, int proxyPort) {
            WebClientConfig.Builder toReturn = (WebClientConfig.Builder)WebClientConfig.builder().from((WebClientConfig.BuilderBase)this.webClientConfigBuilder);
            if (proxyHost != null && toReturn.proxy().isEmpty()) {
                Proxy.ProxyType proxyType = Proxy.ProxyType.valueOf((String)proxyProtocol.toUpperCase());
                toReturn.proxy(Proxy.builder().type(proxyType).host(proxyHost).port(proxyPort).build());
            }
            return toReturn;
        }

        @Override
        @ConfiguredOption(key="webclient", type=WebClient.class, description="WebClient configuration used for outbound requests to the identity server. This configuration sets the values to the OIDC WebClient default configuration.")
        public Builder config(Config config) {
            super.config(config);
            config.get("frontend-uri").asString().ifPresent(this::frontendUri);
            config.get("proxy-protocol").asString().ifPresent(this::proxyProtocol);
            config.get("proxy-host").asString().ifPresent(this::proxyHost);
            config.get("proxy-port").asInt().ifPresent(this::proxyPort);
            config.get("relative-uris").asBoolean().ifPresent(this::relativeUris);
            config.get("query-param-use").asBoolean().ifPresent(this::useParam);
            config.get("query-param-name").asString().ifPresent(this::paramName);
            config.get("query-param-tenant-name").asString().ifPresent(this::paramTenantName);
            config.get("header-use").asBoolean().ifPresent(this::useHeader);
            config.get("header-token").as(TokenHandler.class).ifPresent(this::headerTokenHandler);
            config.get("cookie-use").asBoolean().ifPresent(this::useCookie);
            config.get("cookie-name").asString().ifPresent(this::cookieName);
            config.get("cookie-name-id-token").asString().ifPresent(this::cookieNameIdToken);
            config.get("cookie-name-tenant").asString().ifPresent(this::cookieTenantName);
            config.get("cookie-name-refresh-token").asString().ifPresent(this::cookieNameRefreshToken);
            config.get("cookie-name-state").asString().ifPresent(this::cookieNameState);
            config.get("cookie-domain").asString().ifPresent(this::cookieDomain);
            config.get("cookie-path").asString().ifPresent(this::cookiePath);
            config.get("cookie-max-age-seconds").asLong().ifPresent(this::cookieMaxAgeSeconds);
            config.get("cookie-http-only").asBoolean().ifPresent(this::cookieHttpOnly);
            config.get("cookie-secure").asBoolean().ifPresent(this::cookieSecure);
            config.get("cookie-same-site").asString().ifPresent(this::cookieSameSite);
            config.get("cookie-encryption-enabled").asBoolean().ifPresent(this::cookieEncryptionEnabled);
            config.get("cookie-encryption-id-enabled").asBoolean().ifPresent(this::cookieEncryptionEnabledIdToken);
            config.get("cookie-encryption-tenant-enabled").asBoolean().ifPresent(this::cookieEncryptionEnabledTenantName);
            config.get("cookie-encryption-refresh-enabled").asBoolean().ifPresent(this::cookieEncryptionEnabledRefreshToken);
            config.get("cookie-encryption-state-enabled").asBoolean().ifPresent(this::cookieEncryptionEnabledState);
            config.get("cookie-encryption-password").as(String.class).map(String::toCharArray).ifPresent(this::cookieEncryptionPassword);
            config.get("cookie-encryption-name").asString().ifPresent(this::cookieEncryptionName);
            config.get("redirect-uri").asString().ifPresent(this::redirectUri);
            config.get("logout-uri").asString().ifPresent(this::logoutUri);
            config.get("post-logout-uri").as(URI.class).ifPresent(this::postLogoutUri);
            config.get("logout-enabled").asBoolean().ifPresent(this::logoutEnabled);
            config.get("redirect").asBoolean().ifPresent(this::redirect);
            config.get("redirect-attempt-param").asString().ifPresent(this::redirectAttemptParam);
            config.get("max-redirects").asInt().ifPresent(this::maxRedirects);
            config.get("force-https-redirects").asBoolean().ifPresent(this::forceHttpsRedirects);
            config.get("cors").map(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            config.get("token-refresh-before-expiration").as(Duration.class).ifPresent(this::tokenRefreshSkew);
            config.get("token-signature-validation").asBoolean().ifPresent(this::tokenSignatureValidation);
            config.get("id-token-signature-validation").asBoolean().ifPresent(this::idTokenSignatureValidation);
            config.get("access-token-ip-check").asBoolean().ifPresent(this::accessTokenIpCheck);
            config.get("tenants").asList(Config.class).ifPresent(confList -> confList.forEach(tenantConfig -> this.tenantFromConfig(config, (Config)tenantConfig)));
            this.webClientConfigBuilder.config(config.get("webclient"));
            return this;
        }

        private void tenantFromConfig(Config defaultConfig, Config tenantConfig) {
            this.addTenantConfig(TenantConfig.tenantBuilder().config(defaultConfig).config(tenantConfig).build());
        }

        public Builder tokenRefreshSkew(Duration tokenRefreshSkew) {
            this.tokenRefreshSkew = tokenRefreshSkew;
            return this;
        }

        @ConfiguredOption(key="cors")
        public Builder crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            this.crossOriginConfig = crossOriginConfig;
            return this;
        }

        public Builder logoutEnabled(Boolean logoutEnabled) {
            this.logoutEnabled = logoutEnabled;
            return this;
        }

        @ConfiguredOption(value="false")
        public Builder redirect(boolean redirect) {
            this.redirect = redirect;
            return this;
        }

        @ConfiguredOption
        public Builder frontendUri(String uri) {
            this.frontendUri = uri;
            return this;
        }

        @ConfiguredOption(value="false")
        public Builder forceHttpsRedirects(boolean forceHttpsRedirects) {
            this.forceHttpsRedirects = forceHttpsRedirects;
            return this;
        }

        @Deprecated(since="4.2.1", forRemoval=true)
        @ConfiguredOption(value="false", deprecated=true)
        public Builder relativeUris(boolean relativeUris) {
            this.webClientConfigBuilder.relativeUris(relativeUris);
            this.relativeUris = relativeUris;
            return this;
        }

        @ConfiguredOption(value="/oidc/redirect")
        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder logoutUri(String logoutUri) {
            this.logoutUri = logoutUri;
            return this;
        }

        public Builder postLogoutUri(URI uri) {
            this.postLogoutUri = uri;
            return this;
        }

        @ConfiguredOption(value="h_ra")
        public Builder redirectAttemptParam(String paramName) {
            this.redirectAttemptParam = paramName;
            return this;
        }

        @ConfiguredOption(value="5")
        public Builder maxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        @Deprecated(since="4.2.1", forRemoval=true)
        @ConfiguredOption(value="http", deprecated=true)
        public Builder proxyProtocol(String protocol) {
            this.proxyProtocol = protocol;
            return this;
        }

        @Deprecated(since="4.2.1", forRemoval=true)
        @ConfiguredOption(deprecated=true)
        public Builder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost == null || proxyHost.isEmpty() ? null : proxyHost;
            return this;
        }

        @Deprecated(since="4.2.1", forRemoval=true)
        @ConfiguredOption(value="80")
        public Builder proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        @ConfiguredOption(key="header-token")
        public Builder headerTokenHandler(TokenHandler tokenHandler) {
            this.headerHandler = tokenHandler;
            return this;
        }

        @ConfiguredOption(key="header-use", value="true")
        public Builder useHeader(Boolean useHeader) {
            this.useHeader = useHeader;
            return this;
        }

        @ConfiguredOption(key="query-param-name", value="accessToken")
        public Builder paramName(String paramName) {
            this.paramName = paramName;
            return this;
        }

        @ConfiguredOption(key="query-id-token-param-name", value="id_token")
        public Builder idTokenParamName(String idTokenParamName) {
            this.idTokenParamName = idTokenParamName;
            return this;
        }

        @ConfiguredOption(key="query-param-tenant-name", value="h_tenant")
        public Builder paramTenantName(String paramName) {
            this.tenantParamName = paramName;
            return this;
        }

        @ConfiguredOption(key="query-param-use", value="false")
        public Builder useParam(Boolean useParam) {
            this.useParam = useParam;
            return this;
        }

        @ConfiguredOption
        public Builder cookieEncryptionName(String cookieEncryptionName) {
            this.tokenCookieBuilder.encryptionName(cookieEncryptionName);
            this.idTokenCookieBuilder.encryptionName(cookieEncryptionName);
            this.tenantCookieBuilder.encryptionName(cookieEncryptionName);
            this.refreshTokenCookieBuilder.encryptionName(cookieEncryptionName);
            this.stateCookieBuilder.encryptionName(cookieEncryptionName);
            return this;
        }

        @ConfiguredOption
        public Builder cookieEncryptionPassword(char[] cookieEncryptionPassword) {
            this.tokenCookieBuilder.encryptionPassword(cookieEncryptionPassword);
            this.idTokenCookieBuilder.encryptionPassword(cookieEncryptionPassword);
            this.tenantCookieBuilder.encryptionPassword(cookieEncryptionPassword);
            this.refreshTokenCookieBuilder.encryptionPassword(cookieEncryptionPassword);
            this.stateCookieBuilder.encryptionPassword(cookieEncryptionPassword);
            return this;
        }

        @ConfiguredOption(value="false")
        public Builder cookieEncryptionEnabled(boolean cookieEncryptionEnabled) {
            this.tokenCookieBuilder.encryptionEnabled(cookieEncryptionEnabled);
            return this;
        }

        @ConfiguredOption(key="cookie-encryption-id-enabled", value="true")
        public Builder cookieEncryptionEnabledIdToken(boolean cookieEncryptionEnabled) {
            this.idTokenCookieBuilder.encryptionEnabled(cookieEncryptionEnabled);
            return this;
        }

        @ConfiguredOption(key="cookie-encryption-tenant-enabled", value="true")
        public Builder cookieEncryptionEnabledTenantName(boolean cookieEncryptionEnabled) {
            this.tenantCookieBuilder.encryptionEnabled(cookieEncryptionEnabled);
            return this;
        }

        @ConfiguredOption(key="cookie-encryption-refresh-enabled", value="true")
        public Builder cookieEncryptionEnabledRefreshToken(boolean cookieEncryptionEnabled) {
            this.refreshTokenCookieBuilder.encryptionEnabled(cookieEncryptionEnabled);
            return this;
        }

        @ConfiguredOption(key="cookie-encryption-state-enabled", value="true")
        public Builder cookieEncryptionEnabledState(boolean cookieEncryptionEnabled) {
            this.stateCookieBuilder.encryptionEnabled(cookieEncryptionEnabled);
            return this;
        }

        public Builder cookieSameSite(String sameSite) {
            return this.cookieSameSite(SetCookie.SameSite.valueOf((String)sameSite.toUpperCase(Locale.ROOT)));
        }

        @ConfiguredOption(value="LAX")
        public Builder cookieSameSite(SetCookie.SameSite sameSite) {
            this.tokenCookieBuilder.sameSite(sameSite);
            this.idTokenCookieBuilder.sameSite(sameSite);
            this.tenantCookieBuilder.sameSite(sameSite);
            this.refreshTokenCookieBuilder.sameSite(sameSite);
            this.stateCookieBuilder.sameSite(sameSite);
            this.cookieSameSiteDefault = false;
            return this;
        }

        @ConfiguredOption(value="false")
        public Builder cookieSecure(Boolean secure) {
            this.tokenCookieBuilder.secure(secure);
            this.idTokenCookieBuilder.secure(secure);
            this.tenantCookieBuilder.secure(secure);
            this.refreshTokenCookieBuilder.secure(secure);
            this.stateCookieBuilder.secure(secure);
            return this;
        }

        @ConfiguredOption(value="true")
        public Builder cookieHttpOnly(Boolean httpOnly) {
            this.tokenCookieBuilder.httpOnly(httpOnly);
            this.idTokenCookieBuilder.httpOnly(httpOnly);
            this.tenantCookieBuilder.httpOnly(httpOnly);
            this.refreshTokenCookieBuilder.httpOnly(httpOnly);
            this.stateCookieBuilder.httpOnly(httpOnly);
            return this;
        }

        @ConfiguredOption
        public Builder cookieMaxAgeSeconds(long age) {
            this.tokenCookieBuilder.maxAge(age);
            this.idTokenCookieBuilder.maxAge(age);
            this.tenantCookieBuilder.maxAge(age);
            this.refreshTokenCookieBuilder.maxAge(age);
            this.stateCookieBuilder.maxAge(age);
            return this;
        }

        @ConfiguredOption(value="/")
        public Builder cookiePath(String path) {
            this.tokenCookieBuilder.path(path);
            this.idTokenCookieBuilder.path(path);
            this.tenantCookieBuilder.path(path);
            this.refreshTokenCookieBuilder.path(path);
            this.stateCookieBuilder.path(path);
            return this;
        }

        @ConfiguredOption
        public Builder cookieDomain(String domain) {
            this.tokenCookieBuilder.domain(domain);
            this.idTokenCookieBuilder.domain(domain);
            this.tenantCookieBuilder.domain(domain);
            this.refreshTokenCookieBuilder.domain(domain);
            this.stateCookieBuilder.domain(domain);
            return this;
        }

        @ConfiguredOption(value="JSESSIONID")
        public Builder cookieName(String cookieName) {
            this.tokenCookieBuilder.cookieName(cookieName);
            return this;
        }

        @ConfiguredOption(value="JSESSIONID_2")
        public Builder cookieNameIdToken(String cookieName) {
            this.idTokenCookieBuilder.cookieName(cookieName);
            return this;
        }

        @ConfiguredOption(key="cookie-name-tenant", value="HELIDON_TENANT")
        public Builder cookieTenantName(String cookieName) {
            this.tenantCookieBuilder.cookieName(cookieName);
            return this;
        }

        @ConfiguredOption(value="JSESSIONID_3")
        public Builder cookieNameRefreshToken(String cookieName) {
            this.refreshTokenCookieBuilder.cookieName(cookieName);
            return this;
        }

        @ConfiguredOption(value="JSESSIONID_3")
        public Builder cookieNameState(String cookieName) {
            this.stateCookieBuilder.cookieName(cookieName);
            return this;
        }

        @ConfiguredOption(key="cookie-use", value="true")
        public Builder useCookie(Boolean useCookie) {
            this.useCookie = useCookie;
            return this;
        }

        @ConfiguredOption(key="tenants", type=TenantConfig.class, description="Configurations of the tenants")
        public Builder addTenantConfig(TenantConfig tenantConfig) {
            this.tenantConfigurations.put(tenantConfig.name(), tenantConfig);
            return this;
        }

        @ConfiguredOption(value="true")
        public Builder tokenSignatureValidation(boolean enabled) {
            this.tokenSignatureValidation = enabled;
            return this;
        }

        @ConfiguredOption(value="true")
        public Builder idTokenSignatureValidation(boolean enabled) {
            this.idTokenSignatureValidation = enabled;
            return this;
        }

        @ConfiguredOption(value="true")
        public Builder accessTokenIpCheck(boolean enabled) {
            this.accessTokenIpCheck = enabled;
            return this;
        }

        public Builder webclient(Consumer<WebClientConfig.Builder> builderConsumer) {
            builderConsumer.accept(this.webClientConfigBuilder);
            return this;
        }

        @Override
        public Builder clientTimeout(Duration duration) {
            super.clientTimeout(duration);
            SocketOptions.Builder newSocketBuilder = (SocketOptions.Builder)((SocketOptions.Builder)this.webClientConfigBuilder.socketOptions().map(so -> (SocketOptions.Builder)SocketOptions.builder().from(so)).orElse(SocketOptions.builder()).connectTimeout(duration)).readTimeout(duration);
            this.webClientConfigBuilder.socketOptions((Supplier)newSocketBuilder);
            return this;
        }
    }

    public static enum ClientAuthentication {
        CLIENT_SECRET_BASIC,
        CLIENT_SECRET_POST,
        CLIENT_SECRET_JWT,
        PRIVATE_KEY_JWT,
        CLIENT_CERTIFICATE,
        NONE;

    }

    public static enum RequestType {
        CODE_TO_TOKEN,
        INTROSPECT_JWT;

    }
}

