/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.Base64Value;
import io.helidon.common.context.Contexts;
import io.helidon.common.crypto.SymmetricCipher;
import io.helidon.security.Security;
import io.helidon.security.spi.EncryptionProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.UUID;

final class OidcEncryption {
    private static final System.Logger LOGGER = System.getLogger(OidcEncryption.class.getName());

    private OidcEncryption() {
    }

    static EncryptionProvider.EncryptionSupport create(String type, String encryptionConfigurationName, char[] encryptionPassword) {
        EncryptionProvider.EncryptionSupport found = null;
        if (encryptionConfigurationName != null) {
            found = OidcEncryption.nameBasedCipher(encryptionConfigurationName);
        }
        char[] masterPassword = encryptionPassword;
        if (encryptionPassword == null && found == null) {
            masterPassword = OidcEncryption.generateMasterPassword();
        }
        if (found != null && masterPassword != null) {
            throw new SecurityException("Cannot define both name based encryption and password based encryption for " + type);
        }
        return OidcEncryption.symmetricCipher(masterPassword);
    }

    private static EncryptionProvider.EncryptionSupport symmetricCipher(char[] masterPassword) {
        SymmetricCipher cipher = SymmetricCipher.create((char[])masterPassword);
        return EncryptionProvider.EncryptionSupport.create(bytes -> cipher.encrypt(Base64Value.create((byte[])bytes)).toBase64(), cipherText -> cipher.decrypt(Base64Value.createFromEncoded((String)cipherText)).toBytes());
    }

    private static EncryptionProvider.EncryptionSupport nameBasedCipher(String encryptionConfigurationName) {
        return EncryptionProvider.EncryptionSupport.create(bytes -> OidcEncryption.securityFromContext().encrypt(encryptionConfigurationName, bytes), cipherText -> OidcEncryption.securityFromContext().decrypt(encryptionConfigurationName, cipherText));
    }

    private static char[] generateMasterPassword() {
        Path path = Paths.get(".helidon-oidc-secret", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            String password = UUID.randomUUID().toString();
            try {
                Files.writeString(path, (CharSequence)password, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
                if (path.getFileSystem().supportedFileAttributeViews().contains("posix")) {
                    Files.setPosixFilePermissions(path, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
                }
            }
            catch (IOException e) {
                throw new SecurityException("Failed to create OIDC secret " + String.valueOf(path.toAbsolutePath()), e);
            }
            LOGGER.log(System.Logger.Level.WARNING, "OIDC requires encryption configuration which was not provided. We will generate a password that will only work for the current service instance. To disable encryption, use cookie-encryption-enabled: false configuration, to configure master password, use cookie-encryption-password: my-master-password (must be configured to same value on all instances that share the cookie), to configure encryption using security (support for vaults), use cookie-encryption-name: name (must have corresponding encryption provider and configuration with the provided name in security), this also requires Security to be registered with current or global Context (this works automatically in Helidon MP). This message is logged just once, before generating the master password");
        }
        try {
            return Files.readString(path, StandardCharsets.UTF_8).toCharArray();
        }
        catch (IOException e) {
            throw new SecurityException("Cannot read OIDC secret file: " + String.valueOf(path.toAbsolutePath()), e);
        }
    }

    private static Security securityFromContext() {
        return (Security)Contexts.context().orElseGet(Contexts::globalContext).get(Security.class).orElseThrow(() -> new SecurityException("When using encryption configuration name for OIDC, Security must be registered with current or global context"));
    }
}

