/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.Errors;

final class OidcUtil {
    private static final System.Logger LOGGER = System.getLogger(OidcUtil.class.getName());

    private OidcUtil() {
    }

    static String fixServerType(String serverType) {
        if (serverType != null) {
            if (!"idcs".equals(serverType) && !"@default".equals(serverType)) {
                LOGGER.log(System.Logger.Level.WARNING, "OIDC server-type is configured to " + serverType + ", currently only \"idcs\", and \"@default\" are supported");
                return "@default";
            }
        } else {
            return "@default";
        }
        return serverType;
    }

    static void validateExists(Errors.Collector collector, Object value, String name, String configKey) {
        if (value == null) {
            collector.fatal(name + " must be configured (\"" + configKey + "\" key in config)");
        }
    }
}

