/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.Errors;
import io.helidon.security.Security;
import io.helidon.security.SecurityException;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.providers.httpauth.HttpBasicAuthProvider;
import io.helidon.security.providers.httpauth.HttpBasicOutboundConfig;
import io.helidon.security.providers.oidc.common.IdcsSupport;
import io.helidon.security.providers.oidc.common.OidcConfig;
import io.helidon.security.providers.oidc.common.OidcMetadata;
import io.helidon.security.providers.oidc.common.TenantConfig;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import io.helidon.webclient.security.WebClientSecurity;
import io.helidon.webclient.spi.WebClientService;
import jakarta.json.JsonObject;
import java.net.URI;

public class Tenant {
    private final TenantConfig tenantConfig;
    private final URI tokenEndpointUri;
    private final String authorizationEndpointUri;
    private final URI logoutEndpointUri;
    private final String issuer;
    private final WebClient appWebClient;
    private final JwkKeys signJwk;
    private final URI introspectUri;

    private Tenant(TenantConfig tenantConfig, URI tokenEndpointUri, URI authorizationEndpointUri, URI logoutEndpointUri, String issuer, WebClient appWebClient, JwkKeys signJwk, URI introspectUri) {
        this.tenantConfig = tenantConfig;
        this.tokenEndpointUri = tokenEndpointUri;
        this.authorizationEndpointUri = authorizationEndpointUri.toString();
        this.logoutEndpointUri = logoutEndpointUri;
        this.issuer = issuer;
        this.appWebClient = appWebClient;
        this.signJwk = signJwk;
        this.introspectUri = introspectUri;
    }

    public static Tenant create(OidcConfig oidcConfig, TenantConfig tenantConfig) {
        WebClient webClient = oidcConfig.generalWebClient();
        Errors.Collector collector = Errors.collector();
        URI identityUri = tenantConfig.identityUri();
        OidcMetadata oidcMetadata = OidcMetadata.builder().remoteEnabled(tenantConfig.useWellKnown()).json(tenantConfig.oidcMetadata()).webClient(webClient).identityUri(identityUri).collector(collector).build();
        String serverType = tenantConfig.serverType();
        String metaKey = Tenant.resolveMetaKey("token_endpoint", serverType, identityUri);
        URI tokenEndpointUri = oidcMetadata.getOidcEndpoint(collector, tenantConfig.tenantTokenEndpointUri().orElse(null), metaKey, "/oauth2/v1/token");
        URI authorizationEndpointUri = oidcMetadata.getOidcEndpoint(collector, tenantConfig.authorizationEndpoint().orElse(null), "authorization_endpoint", "/oauth2/v1/authorize");
        metaKey = Tenant.resolveMetaKey("end_session_endpoint", serverType, identityUri);
        URI logoutEndpointUri = oidcMetadata.getOidcEndpoint(collector, tenantConfig.tenantLogoutEndpointUri().orElse(null), metaKey, "oauth2/v1/userlogout");
        String issuer = tenantConfig.tenantIssuer().or(() -> oidcMetadata.getString("issuer")).orElse(null);
        collector.collect().checkValid();
        WebClientConfig.Builder webClientBuilder = oidcConfig.webClientBuilderSupplier().get();
        if (tenantConfig.tokenEndpointAuthentication() == OidcConfig.ClientAuthentication.CLIENT_SECRET_BASIC) {
            HttpBasicAuthProvider httpBasicAuth = HttpBasicAuthProvider.builder().addOutboundTarget(OutboundTarget.builder((String)"oidc").addHost("*").customObject(HttpBasicOutboundConfig.class, (Object)HttpBasicOutboundConfig.create((String)tenantConfig.clientId(), (String)tenantConfig.clientSecret())).build()).build();
            Security tokenOutboundSecurity = Security.builder().addOutboundSecurityProvider((OutboundSecurityProvider)httpBasicAuth).build();
            webClientBuilder.addService((WebClientService)WebClientSecurity.create((Security)tokenOutboundSecurity));
        }
        WebClient appWebClient = webClientBuilder.build();
        JwkKeys signJwk = tenantConfig.tenantSignJwk().orElseGet(() -> {
            String jwksMetaKey;
            URI jwkUri;
            if (tenantConfig.validateJwtWithJwk() && (jwkUri = oidcMetadata.getOidcEndpoint(collector, null, jwksMetaKey = Tenant.resolveMetaKey("jwks_uri", serverType, identityUri), null)) != null) {
                if ("idcs".equals(serverType)) {
                    return IdcsSupport.signJwk(appWebClient, webClient, tokenEndpointUri, jwkUri, tenantConfig.clientTimeout(), tenantConfig);
                }
                return JwkKeys.builder().json((JsonObject)((HttpClientRequest)((HttpClientRequest)webClient.get()).uri(jwkUri)).requestEntity(JsonObject.class)).build();
            }
            return JwkKeys.builder().build();
        });
        URI introspectUri = tenantConfig.tenantIntrospectUri().orElse(null);
        if (!tenantConfig.validateJwtWithJwk()) {
            metaKey = Tenant.resolveMetaKey("introspection_endpoint", serverType, identityUri);
            introspectUri = oidcMetadata.getOidcEndpoint(collector, introspectUri, metaKey, "/oauth2/v1/introspect");
        }
        return new Tenant(tenantConfig, tokenEndpointUri, authorizationEndpointUri, logoutEndpointUri, issuer, appWebClient, signJwk, introspectUri);
    }

    private static String resolveMetaKey(String metaKey, String serverType, URI identityUri) {
        if ("idcs".equals(serverType) && identityUri.toString().contains(".secure.")) {
            return "secure_" + metaKey;
        }
        return metaKey;
    }

    public TenantConfig tenantConfig() {
        return this.tenantConfig;
    }

    public URI tokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public String authorizationEndpointUri() {
        return this.authorizationEndpointUri;
    }

    public URI logoutEndpointUri() {
        return this.logoutEndpointUri;
    }

    public String issuer() {
        return this.issuer;
    }

    public WebClient appWebClient() {
        return this.appWebClient;
    }

    public JwkKeys signJwk() {
        return this.signJwk;
    }

    public URI introspectUri() {
        if (this.introspectUri == null) {
            throw new SecurityException("Introspect URI is not configured when using validate with JWK.");
        }
        return this.introspectUri;
    }
}

