/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc;

import io.helidon.common.Errors;
import io.helidon.common.http.FormParams;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.config.DeprecatedConfig;
import io.helidon.config.metadata.Configured;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Grant;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Role;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityLevel;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.abac.scope.ScopeValidator;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.SignedJwt;
import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.providers.common.OutboundConfig;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.providers.common.TokenCredential;
import io.helidon.security.providers.oidc.common.OidcConfig;
import io.helidon.security.providers.oidc.common.OidcCookieHandler;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.SecurityProvider;
import io.helidon.security.util.TokenHandler;
import io.helidon.webclient.WebClientRequestBuilder;
import jakarta.json.JsonValue;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class OidcProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    private static final Logger LOGGER = Logger.getLogger(OidcProvider.class.getName());
    private final boolean optional;
    private final OidcConfig oidcConfig;
    private final TokenHandler paramHeaderHandler;
    private final BiFunction<SignedJwt, Errors.Collector, Single<Errors.Collector>> jwtValidator;
    private final Pattern attemptPattern;
    private final boolean propagate;
    private final OidcOutboundConfig outboundConfig;
    private final boolean useJwtGroups;
    private final BiConsumer<StringBuilder, String> scopeAppender;
    private final OidcCookieHandler cookieHandler;

    private OidcProvider(Builder builder, OidcOutboundConfig oidcOutboundConfig) {
        this.optional = builder.optional;
        this.oidcConfig = builder.oidcConfig;
        this.propagate = builder.propagate != false && oidcOutboundConfig.hasOutbound();
        this.useJwtGroups = builder.useJwtGroups;
        this.outboundConfig = oidcOutboundConfig;
        this.cookieHandler = this.oidcConfig.tokenCookieHandler();
        this.attemptPattern = Pattern.compile(".*?" + this.oidcConfig.redirectAttemptParam() + "=(\\d+).*");
        this.paramHeaderHandler = this.oidcConfig.useParam() ? TokenHandler.forHeader((String)"X_OIDC_TOKEN_HEADER") : null;
        String configuredScopeAudience = this.oidcConfig.scopeAudience();
        this.scopeAppender = null == configuredScopeAudience || configuredScopeAudience.isEmpty() ? StringBuilder::append : (configuredScopeAudience.endsWith("/") ? (stringBuilder, scope) -> stringBuilder.append(configuredScopeAudience).append((String)scope) : (stringBuilder, scope) -> stringBuilder.append(configuredScopeAudience).append("/").append((String)scope));
        this.jwtValidator = this.oidcConfig.validateJwtWithJwk() ? (signedJwt, collector) -> {
            JwkKeys jwk = this.oidcConfig.signJwk();
            Errors errors = signedJwt.verifySignature(jwk);
            errors.forEach(errorMessage -> {
                switch (errorMessage.getSeverity()) {
                    case FATAL: {
                        collector.fatal(errorMessage.getSource(), errorMessage.getMessage());
                        break;
                    }
                    case WARN: {
                        collector.warn(errorMessage.getSource(), errorMessage.getMessage());
                        break;
                    }
                    default: {
                        collector.hint(errorMessage.getSource(), errorMessage.getMessage());
                    }
                }
            });
            return Single.just((Object)collector);
        } : (signedJwt, collector) -> {
            FormParams.Builder form = FormParams.builder().add("token", new String[]{signedJwt.tokenContent()});
            WebClientRequestBuilder post = this.oidcConfig.appWebClient().post().uri(this.oidcConfig.introspectUri()).accept(new MediaType[]{MediaType.APPLICATION_JSON}).headers(it -> {
                it.add("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"});
                return it;
            });
            this.oidcConfig.updateRequest(OidcConfig.RequestType.INTROSPECT_JWT, post, form);
            return OidcConfig.postJsonResponse((WebClientRequestBuilder)post, (Object)form.build(), json -> {
                if (!json.getBoolean("active")) {
                    collector.fatal(json, "Token is not active");
                }
                return collector;
            }, (status, message) -> Optional.of(collector.fatal(status, "Failed to validate token, response status: " + status + ", entity: " + message)), (t, message) -> Optional.of(collector.fatal(t, "Failed to validate token, request failed: " + message)));
        };
    }

    public static OidcProvider create(Config config) {
        return OidcProvider.builder().config(config).build();
    }

    public static OidcProvider create(OidcConfig config) {
        return OidcProvider.builder().oidcConfig(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        return Set.of(ScopeValidator.Scope.class, ScopeValidator.Scopes.class);
    }

    public CompletionStage<AuthenticationResponse> authenticate(ProviderRequest providerRequest) {
        Optional token;
        LinkedList<String> missingLocations;
        block6: {
            missingLocations = new LinkedList<String>();
            token = Optional.empty();
            try {
                if (this.oidcConfig.useHeader() && (token = token.or(() -> this.oidcConfig.headerHandler().extractToken(providerRequest.env().headers()))).isEmpty()) {
                    missingLocations.add("header");
                }
                if (this.oidcConfig.useParam() && (token = token.or(() -> this.paramHeaderHandler.extractToken(providerRequest.env().headers()))).isEmpty()) {
                    missingLocations.add("query-param");
                }
                if (!this.oidcConfig.useCookie() || !token.isEmpty()) break block6;
                Optional cookie = this.cookieHandler.findCookie(providerRequest.env().headers());
                if (cookie.isEmpty()) {
                    missingLocations.add("cookie");
                    break block6;
                }
                return ((Single)cookie.get()).flatMapSingle(it -> this.validateToken(providerRequest, (String)it)).onErrorResumeWithSingle(throwable -> {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Invalid token in cookie", (Throwable)throwable);
                    }
                    return Single.just((Object)this.errorResponse(providerRequest, Http.Status.UNAUTHORIZED_401, null, "Invalid token"));
                });
            }
            catch (SecurityException e) {
                LOGGER.log(Level.FINEST, "Failed to extract token from one of the configured locations", e);
                return this.failOrAbstain("Failed to extract one of the configured tokens" + e);
            }
        }
        if (token.isPresent()) {
            return this.validateToken(providerRequest, (String)token.get());
        }
        LOGGER.finest(() -> "Missing token, could not find in either of: " + missingLocations);
        return CompletableFuture.completedFuture(this.errorResponse(providerRequest, Http.Status.UNAUTHORIZED_401, null, "Missing token, could not find in either of: " + missingLocations));
    }

    private Set<String> expectedScopes(ProviderRequest request) {
        HashSet<String> result = new HashSet<String>();
        for (SecurityLevel securityLevel : request.endpointConfig().securityLevels()) {
            List expectedScopes = securityLevel.combineAnnotations(ScopeValidator.Scopes.class, EndpointConfig.AnnotationScope.values());
            expectedScopes.stream().map(ScopeValidator.Scopes::value).map(Arrays::asList).map(Collection::stream).forEach(stream -> stream.map(ScopeValidator.Scope::value).forEach(result::add));
            List expectedScopeAnnotations = securityLevel.combineAnnotations(ScopeValidator.Scope.class, EndpointConfig.AnnotationScope.values());
            expectedScopeAnnotations.stream().map(ScopeValidator.Scope::value).forEach(result::add);
        }
        return result;
    }

    private AuthenticationResponse errorResponse(ProviderRequest providerRequest, Http.Status status, String code, String description) {
        if (this.oidcConfig.shouldRedirect()) {
            String state = this.origUri(providerRequest);
            int redirectAttempt = this.redirectAttempt(state);
            if (redirectAttempt >= this.oidcConfig.maxRedirects()) {
                return this.errorResponseNoRedirect(code, description, status);
            }
            Set<String> expectedScopes = this.expectedScopes(providerRequest);
            StringBuilder scopes = new StringBuilder(this.oidcConfig.baseScopes());
            for (String expectedScope : expectedScopes) {
                String scope;
                if (scopes.length() > 0) {
                    scopes.append(' ');
                }
                if ((scope = expectedScope).startsWith("/")) {
                    scope = scope.substring(1);
                }
                this.scopeAppender.accept(scopes, scope);
            }
            String scopeString = URLEncoder.encode(scopes.toString(), StandardCharsets.UTF_8);
            String authorizationEndpoint = this.oidcConfig.authorizationEndpointUri();
            String nonce = UUID.randomUUID().toString();
            String redirectUri = this.redirectUri(providerRequest.env());
            StringBuilder queryString = new StringBuilder("?");
            queryString.append("client_id=").append(this.oidcConfig.clientId()).append("&");
            queryString.append("response_type=code&");
            queryString.append("redirect_uri=").append(redirectUri).append("&");
            queryString.append("scope=").append(scopeString).append("&");
            queryString.append("nonce=").append(nonce).append("&");
            queryString.append("state=").append(this.encodeState(state));
            return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.FAILURE_FINISH)).statusCode(Http.Status.TEMPORARY_REDIRECT_307.code())).description("Redirecting to identity server: " + description)).responseHeader("Location", authorizationEndpoint + queryString)).build();
        }
        return this.errorResponseNoRedirect(code, description, status);
    }

    private String redirectUri(SecurityEnvironment env) {
        for (Map.Entry entry : env.headers().entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase("host") || ((List)entry.getValue()).isEmpty()) continue;
            String firstHost = (String)((List)entry.getValue()).get(0);
            return this.oidcConfig.redirectUriWithHost((String)(this.oidcConfig.forceHttpsRedirects() ? "https" : env.transport() + "://" + firstHost));
        }
        return this.oidcConfig.redirectUriWithHost();
    }

    private CompletionStage<AuthenticationResponse> failOrAbstain(String message) {
        if (this.optional) {
            return CompletableFuture.completedFuture(((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.ABSTAIN)).description(message)).build());
        }
        return CompletableFuture.completedFuture(((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.FAILURE)).description(message)).build());
    }

    private AuthenticationResponse errorResponseNoRedirect(String code, String description, Http.Status status) {
        if (this.optional) {
            return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.ABSTAIN)).description(description)).build();
        }
        if (null == code) {
            return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.FAILURE)).statusCode(Http.Status.UNAUTHORIZED_401.code())).responseHeader("WWW-Authenticate", "Bearer realm=\"" + this.oidcConfig.realm() + "\"")).description(description)).build();
        }
        return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.FAILURE)).statusCode(status.code())).responseHeader("WWW-Authenticate", this.errorHeader(code, description))).description(description)).build();
    }

    private int redirectAttempt(String state) {
        Matcher matcher;
        if (state.contains("?") && (matcher = this.attemptPattern.matcher(state)).matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 1;
    }

    private String errorHeader(String code, String description) {
        return "Bearer realm=\"" + this.oidcConfig.realm() + "\", error=\"" + code + "\", error_description=\"" + description + "\"";
    }

    private String origUri(ProviderRequest providerRequest) {
        List<Object> origUri = providerRequest.env().headers().getOrDefault("X_ORIG_URI_HEADER", List.of());
        if (origUri.isEmpty()) {
            origUri = List.of(providerRequest.env().targetUri().getPath());
        }
        return (String)origUri.get(0);
    }

    private String encodeState(String state) {
        return URLEncoder.encode(state, StandardCharsets.UTF_8);
    }

    private Single<AuthenticationResponse> validateToken(ProviderRequest providerRequest, String token) {
        SignedJwt signedJwt;
        try {
            signedJwt = SignedJwt.parseToken((String)token);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Could not parse inbound token", e);
            return Single.just((Object)AuthenticationResponse.failed((String)"Invalid token", (Throwable)e));
        }
        return this.jwtValidator.apply(signedJwt, Errors.collector()).map(it -> this.processValidationResult(providerRequest, signedJwt, (Errors.Collector)it)).onErrorResume(t -> {
            LOGGER.log(Level.FINEST, "Failed to validate request", (Throwable)t);
            return AuthenticationResponse.failed((String)"Failed to validate JWT", (Throwable)t);
        });
    }

    private AuthenticationResponse processValidationResult(ProviderRequest providerRequest, SignedJwt signedJwt, Errors.Collector collector) {
        Jwt jwt = signedJwt.getJwt();
        Errors errors = collector.collect();
        Errors validationErrors = jwt.validate(this.oidcConfig.issuer(), this.oidcConfig.audience());
        if (errors.isValid() && validationErrors.isValid()) {
            errors.log(LOGGER);
            Subject subject = this.buildSubject(jwt, signedJwt);
            Set scopes = subject.grantsByType("scope").stream().map(Grant::getName).collect(Collectors.toSet());
            Set<String> expectedScopes = this.expectedScopes(providerRequest);
            LinkedList<String> missingScopes = new LinkedList<String>();
            for (String expectedScope : expectedScopes) {
                if (scopes.contains(expectedScope)) continue;
                missingScopes.add(expectedScope);
            }
            if (missingScopes.isEmpty()) {
                return AuthenticationResponse.success((Subject)subject);
            }
            return this.errorResponse(providerRequest, Http.Status.FORBIDDEN_403, "insufficient_scope", "Scopes " + missingScopes + " are missing");
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            errors.log(LOGGER);
            validationErrors.log(LOGGER);
        }
        return this.errorResponse(providerRequest, Http.Status.UNAUTHORIZED_401, "invalid_token", "Token not valid");
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        if (!this.propagate) {
            return false;
        }
        return this.outboundConfig.findTarget((SecurityEnvironment)outboundEnv).propagate;
    }

    public CompletionStage<OutboundSecurityResponse> outboundSecurity(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundEndpointConfig) {
        Subject subject;
        Optional tokenCredential;
        Optional user = providerRequest.securityContext().user();
        if (user.isPresent() && (tokenCredential = (subject = (Subject)user.get()).publicCredential(TokenCredential.class)).isPresent()) {
            String tokenContent = ((TokenCredential)tokenCredential.get()).token();
            OidcOutboundTarget target = this.outboundConfig.findTarget(outboundEnv);
            boolean enabled = target.propagate;
            if (enabled) {
                HashMap headers = new HashMap(outboundEnv.headers());
                target.tokenHandler.header(headers, tokenContent);
                return CompletableFuture.completedFuture(OutboundSecurityResponse.withHeaders(headers));
            }
        }
        return CompletableFuture.completedFuture(OutboundSecurityResponse.empty());
    }

    private Subject buildSubject(Jwt jwt, SignedJwt signedJwt) {
        Principal principal = this.buildPrincipal(jwt);
        TokenCredential.Builder builder = TokenCredential.builder();
        jwt.issueTime().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).issueTime(arg_0));
        jwt.expirationTime().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).expTime(arg_0));
        jwt.issuer().ifPresent(arg_0 -> ((TokenCredential.Builder)builder).issuer(arg_0));
        builder.token(signedJwt.tokenContent());
        builder.addToken(Jwt.class, (Object)jwt);
        builder.addToken(SignedJwt.class, (Object)signedJwt);
        Subject.Builder subjectBuilder = Subject.builder().principal(principal).addPublicCredential(TokenCredential.class, (Object)builder.build());
        if (this.useJwtGroups) {
            Optional userGroups = jwt.userGroups();
            userGroups.ifPresent(groups -> groups.forEach(group -> subjectBuilder.addGrant((Grant)Role.create((String)group))));
        }
        Optional scopes = jwt.scopes();
        scopes.ifPresent(scopeList -> scopeList.forEach(scope -> subjectBuilder.addGrant(Grant.builder().name(scope).type("scope").build())));
        return subjectBuilder.build();
    }

    private Principal buildPrincipal(Jwt jwt) {
        String subject = (String)jwt.subject().orElseThrow(() -> new JwtException("JWT does not contain subject claim, cannot create principal."));
        String name = jwt.preferredUsername().orElse(subject);
        Principal.Builder builder = Principal.builder();
        builder.name(name).id(subject);
        jwt.payloadClaims().forEach((key, jsonValue) -> builder.addAttribute(key, JwtUtil.toObject((JsonValue)jsonValue)));
        jwt.email().ifPresent(value -> builder.addAttribute("email", value));
        jwt.emailVerified().ifPresent(value -> builder.addAttribute("email_verified", value));
        jwt.locale().ifPresent(value -> builder.addAttribute("locale", value));
        jwt.familyName().ifPresent(value -> builder.addAttribute("family_name", value));
        jwt.givenName().ifPresent(value -> builder.addAttribute("given_name", value));
        jwt.fullName().ifPresent(value -> builder.addAttribute("full_name", value));
        return builder.build();
    }

    @Configured(prefix="oidc", description="Open ID Connect security provider", provides={AuthenticationProvider.class, SecurityProvider.class})
    public static final class Builder
    implements io.helidon.common.Builder<Builder, OidcProvider> {
        private boolean optional = false;
        private OidcConfig oidcConfig;
        private Boolean propagate;
        private boolean useJwtGroups = true;
        private OutboundConfig outboundConfig;
        private TokenHandler defaultOutboundHandler = TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("Bearer ").build();

        public OidcProvider build() {
            if (null == this.oidcConfig) {
                throw new IllegalArgumentException("OidcConfig must be configured");
            }
            if (this.outboundConfig == null) {
                this.outboundConfig = OutboundConfig.builder().build();
            }
            if (this.propagate == null) {
                this.propagate = this.outboundConfig.targets().size() > 0;
            }
            return new OidcProvider(this, new OidcOutboundConfig(this.outboundConfig, this.defaultOutboundHandler));
        }

        public Builder config(Config config) {
            config.get("optional").asBoolean().ifPresent(this::optional);
            if (null == this.oidcConfig && config.get("identity-uri").exists()) {
                this.oidcConfig = OidcConfig.create((Config)config);
            }
            config.get("propagate").asBoolean().ifPresent(this::propagate);
            if (null == this.outboundConfig) {
                config.get("outbound").ifExists(outbound -> this.outboundConfig(OutboundConfig.create((Config)config)));
            }
            config.get("use-jwt-groups").asBoolean().ifPresent(this::useJwtGroups);
            return this;
        }

        public Builder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        public Builder outboundConfig(OutboundConfig config) {
            this.outboundConfig = config;
            return this;
        }

        public Builder oidcConfig(OidcConfig config) {
            this.oidcConfig = config;
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder useJwtGroups(boolean useJwtGroups) {
            this.useJwtGroups = useJwtGroups;
            return this;
        }
    }

    private static final class OidcOutboundConfig {
        private final Map<OutboundTarget, OidcOutboundTarget> targetCache = new HashMap<OutboundTarget, OidcOutboundTarget>();
        private final OutboundConfig outboundConfig;
        private final TokenHandler defaultTokenHandler;
        private final OidcOutboundTarget defaultTarget;

        private OidcOutboundConfig(OutboundConfig outboundConfig, TokenHandler defaultTokenHandler) {
            this.outboundConfig = outboundConfig;
            this.defaultTokenHandler = defaultTokenHandler;
            this.defaultTarget = new OidcOutboundTarget(true, defaultTokenHandler);
        }

        private boolean hasOutbound() {
            return this.outboundConfig.targets().size() > 0;
        }

        private OidcOutboundTarget findTarget(SecurityEnvironment env) {
            return this.outboundConfig.findTarget(env).map(value -> this.targetCache.computeIfAbsent((OutboundTarget)value, outboundTarget -> {
                boolean propagate = outboundTarget.getConfig().flatMap(cfg -> cfg.get("propagate").asBoolean().asOptional()).orElse(true);
                TokenHandler handler = outboundTarget.getConfig().flatMap(cfg -> DeprecatedConfig.get((Config)cfg, (String)"outbound-token", (String)"token").as(TokenHandler::create).asOptional()).orElse(this.defaultTokenHandler);
                return new OidcOutboundTarget(propagate, handler);
            })).orElse(this.defaultTarget);
        }
    }

    private static final class OidcOutboundTarget {
        private final boolean propagate;
        private final TokenHandler tokenHandler;

        private OidcOutboundTarget(boolean propagate, TokenHandler handler) {
            this.propagate = propagate;
            this.tokenHandler = handler;
        }
    }
}

