/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.reactive.Single;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.config.DeprecatedConfig;
import io.helidon.config.metadata.Configured;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.Subject;
import io.helidon.security.abac.scope.ScopeValidator;
import io.helidon.security.providers.common.OutboundConfig;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.providers.common.TokenCredential;
import io.helidon.security.providers.oidc.DefaultTenantIdProvider;
import io.helidon.security.providers.oidc.TenantAuthenticationHandler;
import io.helidon.security.providers.oidc.common.OidcConfig;
import io.helidon.security.providers.oidc.common.Tenant;
import io.helidon.security.providers.oidc.common.TenantConfig;
import io.helidon.security.providers.oidc.common.spi.TenantConfigFinder;
import io.helidon.security.providers.oidc.common.spi.TenantConfigProvider;
import io.helidon.security.providers.oidc.common.spi.TenantIdFinder;
import io.helidon.security.providers.oidc.common.spi.TenantIdProvider;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.SecurityProvider;
import io.helidon.security.util.TokenHandler;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class OidcProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    private static final Logger LOGGER = Logger.getLogger(OidcProvider.class.getName());
    private final boolean optional;
    private final OidcConfig oidcConfig;
    private final List<TenantIdFinder> tenantIdFinders;
    private final List<TenantConfigFinder> tenantConfigFinders;
    private final boolean propagate;
    private final OidcOutboundConfig outboundConfig;
    private final boolean useJwtGroups;
    private final LruCache<String, TenantAuthenticationHandler> tenantAuthHandlers = LruCache.create();

    private OidcProvider(Builder builder, OidcOutboundConfig oidcOutboundConfig) {
        this.optional = builder.optional;
        this.oidcConfig = builder.oidcConfig;
        this.propagate = builder.propagate != false && oidcOutboundConfig.hasOutbound();
        this.useJwtGroups = builder.useJwtGroups;
        this.outboundConfig = oidcOutboundConfig;
        this.tenantConfigFinders = List.copyOf(builder.tenantConfigFinders);
        this.tenantIdFinders = List.copyOf(builder.tenantIdFinders);
        this.tenantConfigFinders.forEach(tenantConfigFinder -> tenantConfigFinder.onChange(arg_0 -> this.tenantAuthHandlers.remove(arg_0)));
    }

    public static OidcProvider create(Config config) {
        return OidcProvider.builder().config(config).build();
    }

    public static OidcProvider create(OidcConfig config) {
        return OidcProvider.builder().oidcConfig(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        return Set.of(ScopeValidator.Scope.class, ScopeValidator.Scopes.class);
    }

    public CompletionStage<AuthenticationResponse> authenticate(ProviderRequest providerRequest) {
        Single tenantIdSingle = this.tenantIdFinders.stream().map(tenantIdFinder -> tenantIdFinder.tenantId(providerRequest)).flatMap(Optional::stream).findFirst().map(Single::just).orElseGet(() -> this.findTenantIdFromRedirects(providerRequest));
        return tenantIdSingle.flatMapCompletionStage(tenantId -> this.authenticateWithTenant((String)tenantId, providerRequest));
    }

    private CompletionStage<AuthenticationResponse> authenticateWithTenant(String tenantId, ProviderRequest providerRequest) {
        Optional tenantHandler = this.tenantAuthHandlers.get((Object)tenantId);
        if (tenantHandler.isPresent()) {
            return ((TenantAuthenticationHandler)tenantHandler.get()).authenticate(tenantId, providerRequest);
        }
        return CompletableFuture.supplyAsync(() -> {
            TenantConfig possibleConfig = this.tenantConfigFinders.stream().map(tenantConfigFinder -> tenantConfigFinder.config(tenantId)).flatMap(Optional::stream).findFirst().orElse(this.oidcConfig.tenantConfig(tenantId));
            Tenant tenant = Tenant.create((OidcConfig)this.oidcConfig, (TenantConfig)possibleConfig);
            TenantAuthenticationHandler handler = new TenantAuthenticationHandler(this.oidcConfig, tenant, this.useJwtGroups, this.optional);
            return (TenantAuthenticationHandler)this.tenantAuthHandlers.computeValue((Object)tenantId, () -> Optional.of(handler)).get();
        }, providerRequest.securityContext().executorService()).thenCompose(handler -> handler.authenticate(tenantId, providerRequest));
    }

    private Single<String> findTenantIdFromRedirects(ProviderRequest providerRequest) {
        LinkedList<String> missingLocations = new LinkedList<String>();
        Optional tenantId = Optional.empty();
        missingLocations.add("tenant-id-finder");
        if (this.oidcConfig.useParam() && (tenantId = providerRequest.env().queryParams().first(this.oidcConfig.tenantParamName())).isEmpty()) {
            missingLocations.add("query-param");
        }
        if (this.oidcConfig.useCookie() && tenantId.isEmpty()) {
            Optional cookie = this.oidcConfig.tenantCookieHandler().findCookie(providerRequest.env().headers());
            if (cookie.isPresent()) {
                return (Single)cookie.get();
            }
            missingLocations.add("cookie");
        }
        if (tenantId.isPresent()) {
            return Single.just((Object)((String)tenantId.get()));
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Missing tenant id, could not find in either of: " + missingLocations + "Falling back to the default tenant id: @default");
        }
        return Single.just((Object)"@default");
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        if (!this.propagate) {
            return false;
        }
        return this.outboundConfig.findTarget((SecurityEnvironment)outboundEnv).propagate;
    }

    public CompletionStage<OutboundSecurityResponse> outboundSecurity(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundEndpointConfig) {
        Subject subject;
        Optional tokenCredential;
        Optional user = providerRequest.securityContext().user();
        if (user.isPresent() && (tokenCredential = (subject = (Subject)user.get()).publicCredential(TokenCredential.class)).isPresent()) {
            String tokenContent = ((TokenCredential)tokenCredential.get()).token();
            OidcOutboundTarget target = this.outboundConfig.findTarget(outboundEnv);
            boolean enabled = target.propagate;
            if (enabled) {
                HashMap headers = new HashMap(outboundEnv.headers());
                target.tokenHandler.header(headers, tokenContent);
                return CompletableFuture.completedFuture(OutboundSecurityResponse.withHeaders(headers));
            }
        }
        return CompletableFuture.completedFuture(OutboundSecurityResponse.empty());
    }

    @Configured(prefix="oidc", description="Open ID Connect security provider", provides={AuthenticationProvider.class, SecurityProvider.class})
    public static final class Builder
    implements io.helidon.common.Builder<Builder, OidcProvider> {
        private static final int BUILDER_PRIORITY = 50000;
        private static final int DEFAULT_PRIORITY = 100000;
        private final HelidonServiceLoader.Builder<TenantConfigProvider> tenantConfigProviders = HelidonServiceLoader.builder(ServiceLoader.load(TenantConfigProvider.class)).defaultPriority(100000);
        private final HelidonServiceLoader.Builder<TenantIdProvider> tenantIdProviders = HelidonServiceLoader.builder(ServiceLoader.load(TenantIdProvider.class)).defaultPriority(100000);
        private boolean optional = false;
        private OidcConfig oidcConfig;
        private List<TenantIdFinder> tenantIdFinders;
        private List<TenantConfigFinder> tenantConfigFinders;
        private Boolean propagate;
        private boolean useJwtGroups = true;
        private OutboundConfig outboundConfig;
        private Config config = Config.empty();
        private TokenHandler defaultOutboundHandler = TokenHandler.builder().tokenHeader("Authorization").tokenPrefix("Bearer ").build();

        public OidcProvider build() {
            if (null == this.oidcConfig) {
                throw new IllegalArgumentException("OidcConfig must be configured");
            }
            this.tenantIdProviders.addService((Object)new DefaultTenantIdProvider());
            this.tenantConfigFinders = this.tenantConfigProviders.build().asList().stream().map(provider -> provider.createTenantConfigFinder(this.config)).collect(Collectors.toList());
            this.tenantIdFinders = this.tenantIdProviders.build().asList().stream().map(provider -> provider.createTenantIdFinder(this.config)).collect(Collectors.toList());
            if (this.outboundConfig == null) {
                this.outboundConfig = OutboundConfig.builder().build();
            }
            if (this.propagate == null) {
                this.propagate = this.outboundConfig.targets().size() > 0;
            }
            return new OidcProvider(this, new OidcOutboundConfig(this.outboundConfig, this.defaultOutboundHandler));
        }

        public Builder config(Config config) {
            this.config = config;
            config.get("optional").asBoolean().ifPresent(this::optional);
            if (null == this.oidcConfig && config.get("identity-uri").exists()) {
                this.oidcConfig = OidcConfig.create((Config)config);
            }
            config.get("propagate").asBoolean().ifPresent(this::propagate);
            if (null == this.outboundConfig) {
                config.get("outbound").ifExists(outbound -> this.outboundConfig(OutboundConfig.create((Config)config)));
            }
            config.get("use-jwt-groups").asBoolean().ifPresent(this::useJwtGroups);
            config.get("discover-tenant-config-providers").asBoolean().ifPresent(this::discoverTenantConfigProviders);
            config.get("discover-tenant-id-providers").asBoolean().ifPresent(this::discoverTenantIdProviders);
            return this;
        }

        public Builder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        public Builder outboundConfig(OutboundConfig config) {
            this.outboundConfig = config;
            return this;
        }

        public Builder oidcConfig(OidcConfig config) {
            this.oidcConfig = config;
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder useJwtGroups(boolean useJwtGroups) {
            this.useJwtGroups = useJwtGroups;
            return this;
        }

        public Builder discoverTenantConfigProviders(boolean discoverConfigProviders) {
            this.tenantConfigProviders.useSystemServiceLoader(discoverConfigProviders);
            return this;
        }

        public Builder discoverTenantIdProviders(boolean discoverIdProviders) {
            this.tenantIdProviders.useSystemServiceLoader(discoverIdProviders);
            return this;
        }

        public Builder addTenantConfigFinder(TenantConfigFinder configFinder) {
            return this.addTenantConfigFinder(configFinder, 50000);
        }

        public Builder addTenantConfigFinder(TenantConfigFinder configFinder, int priority) {
            this.tenantConfigProviders.addService(config -> configFinder, priority);
            return this;
        }

        public Builder addTenantConfigFinder(TenantIdFinder idFinder) {
            return this.addTenantConfigFinder(idFinder, 50000);
        }

        public Builder addTenantConfigFinder(TenantIdFinder idFinder, int priority) {
            this.tenantIdProviders.addService(config -> idFinder, priority);
            return this;
        }
    }

    private static final class OidcOutboundConfig {
        private final Map<OutboundTarget, OidcOutboundTarget> targetCache = new HashMap<OutboundTarget, OidcOutboundTarget>();
        private final OutboundConfig outboundConfig;
        private final TokenHandler defaultTokenHandler;
        private final OidcOutboundTarget defaultTarget;

        private OidcOutboundConfig(OutboundConfig outboundConfig, TokenHandler defaultTokenHandler) {
            this.outboundConfig = outboundConfig;
            this.defaultTokenHandler = defaultTokenHandler;
            this.defaultTarget = new OidcOutboundTarget(true, defaultTokenHandler);
        }

        private boolean hasOutbound() {
            return this.outboundConfig.targets().size() > 0;
        }

        private OidcOutboundTarget findTarget(SecurityEnvironment env) {
            return this.outboundConfig.findTarget(env).map(value -> this.targetCache.computeIfAbsent((OutboundTarget)value, outboundTarget -> {
                boolean propagate = outboundTarget.getConfig().flatMap(cfg -> cfg.get("propagate").asBoolean().asOptional()).orElse(true);
                TokenHandler handler = outboundTarget.getConfig().flatMap(cfg -> DeprecatedConfig.get((Config)cfg, (String)"outbound-token", (String)"token").as(TokenHandler::create).asOptional()).orElse(this.defaultTokenHandler);
                return new OidcOutboundTarget(propagate, handler);
            })).orElse(this.defaultTarget);
        }
    }

    private static final class OidcOutboundTarget {
        private final boolean propagate;
        private final TokenHandler tokenHandler;

        private OidcOutboundTarget(boolean propagate, TokenHandler handler) {
            this.propagate = propagate;
            this.tokenHandler = handler;
        }
    }
}

