/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.common.http.FormParams;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Single;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.security.providers.oidc.OidcUtil;
import io.helidon.security.providers.oidc.common.OidcConfig;
import io.helidon.security.providers.oidc.common.OidcCookieHandler;
import io.helidon.security.providers.oidc.common.Tenant;
import io.helidon.security.providers.oidc.common.TenantConfig;
import io.helidon.security.providers.oidc.common.spi.TenantConfigFinder;
import io.helidon.security.providers.oidc.common.spi.TenantConfigProvider;
import io.helidon.webclient.WebClient;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webserver.Handler;
import io.helidon.webserver.ResponseHeaders;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.cors.CorsSupport;
import io.helidon.webserver.cors.CrossOriginConfig;
import jakarta.json.JsonObject;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class OidcSupport
implements Service {
    private static final Logger LOGGER = Logger.getLogger(OidcSupport.class.getName());
    private static final Supplier<ExecutorService> OIDC_SUPPORT_SERVICE = ThreadPoolSupplier.create((String)"oidc-support");
    private static final String CODE_PARAM_NAME = "code";
    private static final String STATE_PARAM_NAME = "state";
    private static final String DEFAULT_REDIRECT = "/index.html";
    private final List<TenantConfigFinder> oidcConfigFinders;
    private final LruCache<String, Tenant> tenants = LruCache.create();
    private final OidcConfig oidcConfig;
    private final boolean enabled;
    private final CorsSupport corsSupport;

    private OidcSupport(Builder builder) {
        this.oidcConfig = builder.oidcConfig;
        this.enabled = builder.enabled;
        if (this.enabled) {
            this.corsSupport = this.prepareCrossOriginSupport(this.oidcConfig.redirectUri(), this.oidcConfig.crossOriginConfig());
            this.oidcConfigFinders = List.copyOf(builder.tenantConfigFinders);
            this.oidcConfigFinders.forEach(tenantConfigFinder -> tenantConfigFinder.onChange(arg_0 -> this.tenants.remove(arg_0)));
        } else {
            this.corsSupport = null;
            this.oidcConfigFinders = List.of();
        }
    }

    public static OidcSupport create(Config config, String providerName) {
        return OidcSupport.builder().config(config, providerName).build();
    }

    public static OidcSupport create(Config config) {
        return OidcSupport.builder().config(config, "oidc").build();
    }

    public static OidcSupport create(OidcConfig oidcConfig) {
        return OidcSupport.builder().config(oidcConfig).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void update(Routing.Rules rules) {
        if (this.enabled) {
            if (this.corsSupport != null) {
                rules.any(this.oidcConfig.redirectUri(), new Handler[]{this.corsSupport});
            }
            rules.get(this.oidcConfig.redirectUri(), new Handler[]{this::processOidcRedirect});
            if (this.oidcConfig.logoutEnabled()) {
                if (this.corsSupport != null) {
                    rules.any(this.oidcConfig.logoutUri(), new Handler[]{this.corsSupport});
                }
                rules.get(this.oidcConfig.logoutUri(), new Handler[]{this::processLogout});
            }
            rules.any(new Handler[]{this::addRequestAsHeader});
        }
    }

    private void processLogout(ServerRequest req, ServerResponse res) {
        this.findTenantName(req).forSingle(tenantName -> this.processTenantLogout(req, res, (String)tenantName));
    }

    private void processTenantLogout(ServerRequest req, ServerResponse res, String tenantName) {
        this.obtainCurrentTenant(tenantName).forSingle(tenant -> this.logoutWithTenant(req, res, (Tenant)tenant));
    }

    private void logoutWithTenant(ServerRequest req, ServerResponse res, Tenant tenant) {
        OidcCookieHandler idTokenCookieHandler = this.oidcConfig.idTokenCookieHandler();
        OidcCookieHandler tokenCookieHandler = this.oidcConfig.tokenCookieHandler();
        OidcCookieHandler tenantCookieHandler = this.oidcConfig.tenantCookieHandler();
        Optional idTokenCookie = req.headers().cookies().first(idTokenCookieHandler.cookieName());
        if (idTokenCookie.isEmpty()) {
            LOGGER.finest("Logout request invoked without ID Token cookie");
            res.status((Http.ResponseStatus)Http.Status.FORBIDDEN_403).send();
            return;
        }
        String encryptedIdToken = (String)idTokenCookie.get();
        idTokenCookieHandler.decrypt(encryptedIdToken).forSingle(idToken -> {
            StringBuilder sb = new StringBuilder(tenant.logoutEndpointUri() + "?id_token_hint=" + idToken + "&post_logout_redirect_uri=" + this.postLogoutUri(req));
            req.queryParams().first(STATE_PARAM_NAME).ifPresent(it -> sb.append("&state=").append((String)it));
            ResponseHeaders headers = res.headers();
            headers.addCookie(tokenCookieHandler.removeCookie().build());
            headers.addCookie(idTokenCookieHandler.removeCookie().build());
            headers.addCookie(tenantCookieHandler.removeCookie().build());
            res.status((Http.ResponseStatus)Http.Status.TEMPORARY_REDIRECT_307).addHeader("Location", new String[]{sb.toString()}).send();
        }).exceptionallyAccept(t -> this.sendError(res, (Throwable)t));
    }

    private Single<String> findTenantName(ServerRequest request) {
        LinkedList<String> missingLocations = new LinkedList<String>();
        Optional tenantId = Optional.empty();
        if (this.oidcConfig.useParam() && (tenantId = request.queryParams().first(this.oidcConfig.tenantParamName())).isEmpty()) {
            missingLocations.add("query-param");
        }
        if (this.oidcConfig.useCookie() && tenantId.isEmpty()) {
            Optional cookie = this.oidcConfig.tenantCookieHandler().findCookie(request.headers().toMap());
            if (cookie.isPresent()) {
                return (Single)cookie.get();
            }
            missingLocations.add("cookie");
        }
        if (tenantId.isPresent()) {
            return Single.just((Object)((String)tenantId.get()));
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Missing tenant id, could not find in either of: " + missingLocations + "Falling back to the default tenant id: @default");
        }
        return Single.just((Object)"@default");
    }

    private Single<Tenant> obtainCurrentTenant(String tenantName) {
        Optional maybeTenant = this.tenants.get((Object)tenantName);
        if (maybeTenant.isPresent()) {
            return Single.just((Object)((Tenant)maybeTenant.get()));
        }
        CompletableFuture<Tenant> tenantCompletableFuture = CompletableFuture.supplyAsync(() -> {
            Tenant tenant = this.oidcConfigFinders.stream().map(finder -> finder.config(tenantName)).flatMap(Optional::stream).map(tenantConfig -> Tenant.create((OidcConfig)this.oidcConfig, (TenantConfig)tenantConfig)).findFirst().orElseGet(() -> Tenant.create((OidcConfig)this.oidcConfig, (TenantConfig)this.oidcConfig.tenantConfig(tenantName)));
            return (Tenant)this.tenants.computeValue((Object)tenantName, () -> Optional.of(tenant)).get();
        }, OIDC_SUPPORT_SERVICE.get());
        return Single.create(tenantCompletableFuture);
    }

    private void addRequestAsHeader(ServerRequest req, ServerResponse res) {
        Map newHeaders = req.context().get((Object)"security.addHeaders", Map.class).map(theMap -> theMap).orElseGet(() -> {
            HashMap newMap = new HashMap();
            req.context().register((Object)"security.addHeaders", newMap);
            return newMap;
        });
        String query = req.query();
        if (null == query || query.isEmpty()) {
            newHeaders.put("X_ORIG_URI_HEADER", List.of(req.uri().getPath()));
        } else {
            newHeaders.put("X_ORIG_URI_HEADER", List.of(req.uri().getPath() + "?" + query));
        }
        req.next();
    }

    private void processOidcRedirect(ServerRequest req, ServerResponse res) {
        Optional codeParam = req.queryParams().first(CODE_PARAM_NAME);
        codeParam.ifPresentOrElse(code -> this.processCode((String)code, req, res), () -> this.processError(req, res));
    }

    private void processCode(String code, ServerRequest req, ServerResponse res) {
        String tenantName = req.queryParams().first(this.oidcConfig.tenantParamName()).orElse("@default");
        this.obtainCurrentTenant(tenantName).forSingle(tenant -> this.processCodeWithTenant(code, req, res, tenantName, (Tenant)tenant));
    }

    private void processCodeWithTenant(String code, ServerRequest req, ServerResponse res, String tenantName, Tenant tenant) {
        TenantConfig tenantConfig = tenant.tenantConfig();
        WebClient webClient = tenant.appWebClient();
        FormParams.Builder form = FormParams.builder().add("grant_type", new String[]{"authorization_code"}).add(CODE_PARAM_NAME, new String[]{code}).add("redirect_uri", new String[]{this.redirectUri(req, tenantName)});
        WebClientRequestBuilder post = webClient.post().uri(tenant.tokenEndpointUri()).accept(new MediaType[]{MediaType.APPLICATION_JSON});
        OidcUtil.updateRequest(OidcConfig.RequestType.CODE_TO_TOKEN, tenantConfig, form);
        OidcConfig.postJsonResponse((WebClientRequestBuilder)post, (Object)form.build(), json -> this.processJsonResponse(req, res, (JsonObject)json, tenantName), (status, errorEntity) -> this.processError(res, (Http.ResponseStatus)status, (String)errorEntity), (t, message) -> this.processError(res, (Throwable)t, (String)message)).ignoreElement();
    }

    private Object postLogoutUri(ServerRequest req) {
        URI uri = this.oidcConfig.postLogoutUri();
        if (uri.getHost() != null) {
            return uri.toString();
        }
        Object path = uri.getPath();
        path = ((String)path).startsWith("/") ? path : "/" + (String)path;
        Optional host = req.headers().first("host");
        if (host.isPresent()) {
            String scheme = this.oidcConfig.forceHttpsRedirects() || req.isSecure() ? "https" : "http";
            return scheme + "://" + (String)host.get() + (String)path;
        }
        LOGGER.warning("Request without Host header received, yet post logout URI does not define a host");
        return this.oidcConfig.toString();
    }

    private String redirectUri(ServerRequest req, String tenantName) {
        String uri;
        Optional host = req.headers().first("host");
        if (host.isPresent()) {
            String scheme = req.isSecure() ? "https" : "http";
            uri = this.oidcConfig.redirectUriWithHost(scheme + "://" + (String)host.get());
        } else {
            uri = this.oidcConfig.redirectUriWithHost();
        }
        if (!"@default".equals(tenantName)) {
            return uri + (uri.contains("?") ? "&" : "?") + this.encode(this.oidcConfig.tenantParamName()) + "=" + this.encode(tenantName);
        }
        return uri;
    }

    private String processJsonResponse(ServerRequest req, ServerResponse res, JsonObject json, String tenantName) {
        String tokenValue = json.getString("access_token");
        String idToken = json.getString("id_token", null);
        Object state = req.queryParams().first(STATE_PARAM_NAME).orElse(DEFAULT_REDIRECT);
        res.status((Http.ResponseStatus)Http.Status.TEMPORARY_REDIRECT_307);
        if (this.oidcConfig.useParam()) {
            state = (String)state + (((String)state).contains("?") ? "&" : "?") + this.encode(this.oidcConfig.paramName()) + "=" + tokenValue;
            if (!"@default".equals(tenantName)) {
                state = (String)state + "&" + this.encode(this.oidcConfig.tenantParamName()) + "=" + this.encode(tenantName);
            }
        }
        state = this.increaseRedirectCounter((String)state);
        res.headers().add("Location", new String[]{state});
        if (this.oidcConfig.useCookie()) {
            ResponseHeaders headers = res.headers();
            OidcCookieHandler tenantCookieHandler = this.oidcConfig.tenantCookieHandler();
            tenantCookieHandler.createCookie(tenantName).forSingle(builder -> headers.addCookie(builder.build())).exceptionallyAccept(t -> this.sendError(res, (Throwable)t));
            OidcCookieHandler tokenCookieHandler = this.oidcConfig.tokenCookieHandler();
            tokenCookieHandler.createCookie(tokenValue).forSingle(builder -> {
                headers.addCookie(builder.build());
                if (idToken != null && this.oidcConfig.logoutEnabled()) {
                    this.oidcConfig.idTokenCookieHandler().createCookie(idToken).forSingle(it -> {
                        headers.addCookie(it.build());
                        res.send();
                    }).exceptionallyAccept(t -> this.sendError(res, (Throwable)t));
                } else {
                    res.send();
                }
            }).exceptionallyAccept(t -> this.sendError(res, (Throwable)t));
        } else {
            res.send();
        }
        return "done";
    }

    private String encode(String toEncode) {
        return URLEncoder.encode(toEncode, StandardCharsets.UTF_8);
    }

    private void sendError(ServerResponse response, Throwable t) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Failed to process OIDC request", t);
        }
        response.status((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500).send();
    }

    private Optional<String> processError(ServerResponse serverResponse, Http.ResponseStatus status, String entity) {
        LOGGER.log(Level.FINE, "Invalid token or failed request when connecting to OIDC Token Endpoint. Response: " + entity + ", response status: " + status);
        this.sendErrorResponse(serverResponse);
        return Optional.empty();
    }

    private Optional<String> processError(ServerResponse res, Throwable t, String message) {
        LOGGER.log(Level.FINE, message, t);
        this.sendErrorResponse(res);
        return Optional.empty();
    }

    private void sendErrorResponse(ServerResponse serverResponse) {
        serverResponse.status((Http.ResponseStatus)Http.Status.UNAUTHORIZED_401);
        serverResponse.send((Object)"Not a valid authorization code");
    }

    String increaseRedirectCounter(String state) {
        if (state.contains("?")) {
            Pattern attemptPattern = Pattern.compile(".*?(" + this.oidcConfig.redirectAttemptParam() + "=\\d+).*");
            Matcher matcher = attemptPattern.matcher(state);
            if (matcher.matches()) {
                String attempts = matcher.group(1);
                int equals = attempts.lastIndexOf(61);
                String count = attempts.substring(equals + 1);
                int countNumber = Integer.parseInt(count);
                return state.replace(attempts, this.oidcConfig.redirectAttemptParam() + "=" + ++countNumber);
            }
            return state + "&" + this.oidcConfig.redirectAttemptParam() + "=1";
        }
        return state + "?" + this.oidcConfig.redirectAttemptParam() + "=1";
    }

    private void processError(ServerRequest req, ServerResponse res) {
        String error = req.queryParams().first("error").orElse("invalid_request");
        String errorDescription = req.queryParams().first("error_description").orElseGet(() -> "Failed to process authorization request. Expected redirect from OIDC server with code parameter, but got: " + req.query());
        LOGGER.log(Level.WARNING, () -> "Received request on OIDC endpoint with no code. Error: " + error + " Error description: " + errorDescription);
        res.status((Http.ResponseStatus)Http.Status.BAD_REQUEST_400);
        res.send((Object)("{\"error\": \"" + error + "\", \"error_description\": \"" + errorDescription + "\"}"));
    }

    private CorsSupport prepareCrossOriginSupport(String path, CrossOriginConfig crossOriginConfig) {
        return crossOriginConfig == null ? null : ((CorsSupport.Builder)CorsSupport.builder().addCrossOrigin(path, crossOriginConfig)).build();
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, OidcSupport> {
        private static final int BUILDER_PRIORITY = 50000;
        private static final int DEFAULT_PRIORITY = 100000;
        private final HelidonServiceLoader.Builder<TenantConfigProvider> tenantConfigProviders = HelidonServiceLoader.builder(ServiceLoader.load(TenantConfigProvider.class)).defaultPriority(50000);
        private boolean enabled = true;
        private Config config = Config.empty();
        private OidcConfig oidcConfig;
        private List<TenantConfigFinder> tenantConfigFinders;

        private Builder() {
        }

        private static Optional<Config> findMyKey(Config rootConfig, String providerName) {
            if (rootConfig.key().name().equals(providerName)) {
                return Optional.of(rootConfig);
            }
            return ((List)rootConfig.get("security.providers").asNodeList().orElseGet(List::of)).stream().filter(it -> it.get(providerName).exists()).findFirst().map(it -> it.get(providerName));
        }

        public OidcSupport build() {
            if (this.enabled && this.oidcConfig == null) {
                throw new IllegalStateException("When OIDC and security is enabled, OIDC configuration must be provided");
            }
            this.tenantConfigFinders = this.tenantConfigProviders.build().asList().stream().map(provider -> provider.createTenantConfigFinder(this.config)).collect(Collectors.toList());
            return new OidcSupport(this);
        }

        public Builder config(Config config) {
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            if (this.enabled) {
                this.oidcConfig = OidcConfig.create((Config)config);
                this.config = config;
            }
            config.get("discover-tenant-config-providers").asBoolean().ifPresent(this::discoverTenantConfigProviders);
            return this;
        }

        public Builder config(OidcConfig config) {
            this.oidcConfig = config;
            return this;
        }

        public Builder config(Config config, String providerName) {
            config.get("security.enabled").asBoolean().ifPresent(this::enabled);
            Builder.findMyKey(config, providerName).ifPresentOrElse(this::config, () -> this.enabled(false));
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder discoverTenantConfigProviders(boolean discoverConfigProviders) {
            this.tenantConfigProviders.useSystemServiceLoader(discoverConfigProviders);
            return this;
        }

        public Builder addTenantConfigFinder(TenantConfigFinder configFinder) {
            return this.addTenantConfigFinder(configFinder, 50000);
        }

        public Builder addTenantConfigFinder(TenantConfigFinder configFinder, int priority) {
            this.tenantConfigProviders.addService(config -> configFinder, priority);
            return this;
        }
    }
}

