/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.Weight;
import io.helidon.common.configurable.LruCache;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.mapper.OptionalValue;
import io.helidon.common.parameters.Parameters;
import io.helidon.config.Config;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.Status;
import io.helidon.security.SecurityException;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.SignedJwt;
import io.helidon.security.providers.oidc.OidcUtil;
import io.helidon.security.providers.oidc.common.OidcConfig;
import io.helidon.security.providers.oidc.common.OidcCookieHandler;
import io.helidon.security.providers.oidc.common.Tenant;
import io.helidon.security.providers.oidc.common.TenantConfig;
import io.helidon.security.providers.oidc.common.spi.TenantConfigFinder;
import io.helidon.security.providers.oidc.common.spi.TenantConfigProvider;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.WebClient;
import io.helidon.webserver.cors.CorsSupport;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Weight(value=800.0)
public final class OidcFeature
implements HttpFeature {
    static final JsonReaderFactory JSON_READER_FACTORY = Json.createReaderFactory(Map.of());
    static final JsonBuilderFactory JSON_BUILDER_FACTORY = Json.createBuilderFactory(Map.of());
    private static final System.Logger LOGGER = System.getLogger(OidcFeature.class.getName());
    private static final String CODE_PARAM_NAME = "code";
    private static final String STATE_PARAM_NAME = "state";
    private static final String DEFAULT_REDIRECT = "/index.html";
    private final List<TenantConfigFinder> oidcConfigFinders;
    private final LruCache<String, Tenant> tenants = LruCache.create();
    private final OidcConfig oidcConfig;
    private final OidcCookieHandler tokenCookieHandler;
    private final OidcCookieHandler idTokenCookieHandler;
    private final OidcCookieHandler refreshTokenCookieHandler;
    private final OidcCookieHandler tenantCookieHandler;
    private final OidcCookieHandler stateCookieHandler;
    private final boolean enabled;
    private final CorsSupport corsSupport;

    private OidcFeature(Builder builder) {
        this.oidcConfig = builder.oidcConfig;
        this.enabled = builder.enabled;
        if (this.enabled) {
            this.tokenCookieHandler = this.oidcConfig.tokenCookieHandler();
            this.idTokenCookieHandler = this.oidcConfig.idTokenCookieHandler();
            this.refreshTokenCookieHandler = this.oidcConfig.refreshTokenCookieHandler();
            this.tenantCookieHandler = this.oidcConfig.tenantCookieHandler();
            this.stateCookieHandler = this.oidcConfig.stateCookieHandler();
            this.corsSupport = this.prepareCrossOriginSupport(this.oidcConfig.redirectUri(), this.oidcConfig.crossOriginConfig());
            this.oidcConfigFinders = List.copyOf(builder.tenantConfigFinders);
            this.oidcConfigFinders.forEach(tenantConfigFinder -> tenantConfigFinder.onChange(arg_0 -> this.tenants.remove(arg_0)));
        } else {
            this.tokenCookieHandler = null;
            this.idTokenCookieHandler = null;
            this.refreshTokenCookieHandler = null;
            this.tenantCookieHandler = null;
            this.stateCookieHandler = null;
            this.corsSupport = null;
            this.oidcConfigFinders = List.of();
        }
    }

    public static OidcFeature create(Config config, String providerName) {
        return OidcFeature.builder().config(config, providerName).build();
    }

    public static OidcFeature create(Config config) {
        return OidcFeature.builder().config(config, "oidc").build();
    }

    public static OidcFeature create(OidcConfig oidcConfig) {
        return OidcFeature.builder().config(oidcConfig).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void setup(HttpRouting.Builder routing) {
        if (this.enabled) {
            if (this.corsSupport != null) {
                routing.any(this.oidcConfig.redirectUri(), new Handler[]{this.corsSupport});
            }
            routing.get(this.oidcConfig.redirectUri(), new Handler[]{this::processOidcRedirect});
            if (this.oidcConfig.logoutEnabled()) {
                if (this.corsSupport != null) {
                    routing.any(this.oidcConfig.logoutUri(), new Handler[]{this.corsSupport});
                }
                routing.get(this.oidcConfig.logoutUri(), new Handler[]{this::processLogout});
            }
            routing.any(new Handler[]{this::addRequestAsHeader});
        }
    }

    private void processLogout(ServerRequest req, ServerResponse res) {
        String tenantName = this.findTenantName(req);
        this.processTenantLogout(req, res, tenantName);
    }

    private String findTenantName(ServerRequest request) {
        LinkedList<String> missingLocations = new LinkedList<String>();
        OptionalValue tenantId = null;
        if (this.oidcConfig.useParam() && (tenantId = request.query().first(this.oidcConfig.tenantParamName())).isEmpty()) {
            missingLocations.add("query-param");
        }
        if (this.oidcConfig.useCookie() && tenantId == null) {
            Optional cookie = this.oidcConfig.tenantCookieHandler().findCookie(request.headers().toMap());
            if (cookie.isPresent()) {
                return (String)cookie.get();
            }
            missingLocations.add("cookie");
        }
        if (tenantId != null) {
            return (String)tenantId.get();
        }
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Missing tenant id, could not find in either of: " + String.valueOf(missingLocations) + "Falling back to the default tenant id: @default");
        }
        return "@default";
    }

    private void processTenantLogout(ServerRequest req, ServerResponse res, String tenantName) {
        Tenant tenant = this.obtainCurrentTenant(tenantName);
        this.logoutWithTenant(req, res, tenant);
    }

    private Tenant obtainCurrentTenant(String tenantName) {
        Optional maybeTenant = this.tenants.get((Object)tenantName);
        if (maybeTenant.isPresent()) {
            return (Tenant)maybeTenant.get();
        }
        Tenant tenant = this.oidcConfigFinders.stream().map(finder -> finder.config(tenantName)).flatMap(Optional::stream).map(tenantConfig -> Tenant.create((OidcConfig)this.oidcConfig, (TenantConfig)tenantConfig)).findFirst().orElseGet(() -> Tenant.create((OidcConfig)this.oidcConfig, (TenantConfig)this.oidcConfig.tenantConfig(tenantName)));
        return (Tenant)this.tenants.computeValue((Object)tenantName, () -> Optional.of(tenant)).get();
    }

    private void logoutWithTenant(ServerRequest req, ServerResponse res, Tenant tenant) {
        OptionalValue idTokenCookie = req.headers().cookies().first(this.idTokenCookieHandler.cookieName());
        if (idTokenCookie.isEmpty()) {
            LOGGER.log(System.Logger.Level.TRACE, "Logout request invoked without ID Token cookie");
            res.status(Status.FORBIDDEN_403).send();
            return;
        }
        String encryptedIdToken = (String)idTokenCookie.get();
        try {
            String idToken = this.idTokenCookieHandler.decrypt(encryptedIdToken);
            StringBuilder sb = new StringBuilder(String.valueOf(tenant.logoutEndpointUri()) + "?id_token_hint=" + idToken + "&post_logout_redirect_uri=" + String.valueOf(this.postLogoutUri(req)));
            req.query().first(STATE_PARAM_NAME).ifPresent(it -> sb.append("&state=").append((String)it));
            ServerResponseHeaders headers = res.headers();
            headers.addCookie(this.tokenCookieHandler.removeCookie().build());
            headers.addCookie(this.idTokenCookieHandler.removeCookie().build());
            headers.addCookie(this.tenantCookieHandler.removeCookie().build());
            headers.addCookie(this.refreshTokenCookieHandler.removeCookie().build());
            res.status(Status.TEMPORARY_REDIRECT_307).header(HeaderNames.LOCATION, new String[]{sb.toString()}).send();
        }
        catch (Exception e) {
            this.sendError(res, e);
        }
    }

    private void addRequestAsHeader(ServerRequest req, ServerResponse res) {
        Context context = (Context)Contexts.context().orElseThrow(() -> new SecurityException("Context must be available"));
        Map newHeaders = context.get((Object)"security.addHeaders", Map.class).map(theMap -> theMap).orElseGet(() -> {
            HashMap newMap = new HashMap();
            context.register((Object)"security.addHeaders", newMap);
            return newMap;
        });
        String query = req.query().rawValue();
        if (query.isEmpty()) {
            newHeaders.put("X_ORIG_URI_HEADER", List.of(req.path().rawPath()));
        } else {
            newHeaders.put("X_ORIG_URI_HEADER", List.of(req.path().rawPath() + "?" + query));
        }
        res.next();
    }

    private void processOidcRedirect(ServerRequest req, ServerResponse res) {
        OptionalValue codeParam = req.query().first(CODE_PARAM_NAME);
        codeParam.ifPresentOrElse(code -> this.processCode((String)code, req, res), () -> this.processError(req, res));
    }

    private void processCode(String code, ServerRequest req, ServerResponse res) {
        String tenantName = (String)req.query().first(this.oidcConfig.tenantParamName()).orElse((Object)"@default");
        Tenant tenant = this.obtainCurrentTenant(tenantName);
        this.processCodeWithTenant(code, req, res, tenantName, tenant);
    }

    private void processCodeWithTenant(String code, ServerRequest req, ServerResponse res, String tenantName, Tenant tenant) {
        block19: {
            Optional maybeStateCookie = this.stateCookieHandler.findCookie(req.headers().toMap());
            if (maybeStateCookie.isEmpty()) {
                this.processError(res, Status.UNAUTHORIZED_401, "State cookie needs to be provided upon redirect");
                return;
            }
            String stateBase64 = new String(Base64.getDecoder().decode((String)maybeStateCookie.get()), StandardCharsets.UTF_8);
            JsonObject stateCookie = JSON_READER_FACTORY.createReader((Reader)new StringReader(stateBase64)).readObject();
            res.headers().addCookie(this.stateCookieHandler.removeCookie().build());
            String state = stateCookie.getString(STATE_PARAM_NAME);
            String queryState = req.query().get(STATE_PARAM_NAME);
            if (!state.equals(queryState)) {
                this.processError(res, Status.UNAUTHORIZED_401, "State of the original request and obtained from identity server does not match");
                return;
            }
            TenantConfig tenantConfig = tenant.tenantConfig();
            WebClient webClient = tenant.appWebClient();
            Parameters.Builder form = Parameters.builder((String)"oidc-form-params").add("grant_type", new String[]{"authorization_code"}).add(CODE_PARAM_NAME, new String[]{code}).add("redirect_uri", new String[]{this.redirectUri(req, tenantName)});
            HttpClientRequest post = (HttpClientRequest)((HttpClientRequest)((HttpClientRequest)webClient.post()).uri(tenant.tokenEndpointUri())).header(HeaderValues.ACCEPT_JSON);
            OidcUtil.updateRequest(OidcConfig.RequestType.CODE_TO_TOKEN, tenantConfig, form, post);
            try (HttpClientResponse response = post.submit((Object)form.build());){
                String message;
                if (response.status().family() == Status.Family.SUCCESSFUL) {
                    try {
                        JsonObject jsonObject = (JsonObject)response.as(JsonObject.class);
                        this.processJsonResponse(req, res, jsonObject, tenantName, stateCookie);
                    }
                    catch (Exception e) {
                        this.processError(res, e, "Failed to read JSON from response");
                    }
                    break block19;
                }
                try {
                    message = (String)response.as(String.class);
                }
                catch (Exception e) {
                    this.processError(res, e, "Failed to process error entity");
                    if (response != null) {
                        response.close();
                    }
                    return;
                }
                try {
                    this.processError(res, response.status(), message);
                }
                catch (Exception e) {
                    throw new SecurityException("Failed to process request: " + message);
                }
            }
            catch (Exception e) {
                this.processError(res, e, "Failed to invoke request");
            }
        }
    }

    private Object postLogoutUri(ServerRequest req) {
        URI uri = this.oidcConfig.postLogoutUri();
        if (uri.getHost() != null) {
            return uri.toString();
        }
        Object path = uri.getPath();
        path = ((String)path).startsWith("/") ? path : "/" + (String)path;
        ServerRequestHeaders headers = req.headers();
        if (headers.contains(HeaderNames.HOST)) {
            String scheme = this.oidcConfig.forceHttpsRedirects() || req.isSecure() ? "https" : "http";
            return scheme + "://" + (String)headers.get(HeaderNames.HOST).get() + (String)path;
        }
        LOGGER.log(System.Logger.Level.WARNING, "Request without Host header received, yet post logout URI does not define a host");
        return this.oidcConfig.toString();
    }

    private String redirectUri(ServerRequest req, String tenantName) {
        String uri;
        Optional host = req.headers().first(HeaderNames.HOST);
        if (host.isPresent()) {
            String scheme = req.isSecure() ? "https" : "http";
            uri = this.oidcConfig.redirectUriWithHost(scheme + "://" + (String)host.get());
        } else {
            uri = this.oidcConfig.redirectUriWithHost();
        }
        if (!"@default".equals(tenantName)) {
            return uri + (uri.contains("?") ? "&" : "?") + this.encode(this.oidcConfig.tenantParamName()) + "=" + this.encode(tenantName);
        }
        return uri;
    }

    private String processJsonResponse(ServerRequest req, ServerResponse res, JsonObject json, String tenantName, JsonObject stateCookie) {
        String accessToken = json.getString("access_token");
        String idToken = json.getString("id_token", null);
        String refreshToken = json.getString("refresh_token", null);
        Jwt idTokenJwt = SignedJwt.parseToken((String)idToken).getJwt();
        String nonceOriginal = stateCookie.getString("nonce");
        String nonceAccess = (String)idTokenJwt.nonce().orElseThrow(() -> new IllegalStateException("Nonce is required to be present in the id token"));
        if (!nonceAccess.equals(nonceOriginal)) {
            throw new IllegalStateException("Original nonce and the one obtained from id token does not match");
        }
        Object originalUri = stateCookie.getString("originalUri", DEFAULT_REDIRECT);
        res.status(Status.TEMPORARY_REDIRECT_307);
        if (this.oidcConfig.useParam()) {
            originalUri = (String)originalUri + (((String)originalUri).contains("?") ? "&" : "?") + this.encode(this.oidcConfig.paramName()) + "=" + accessToken;
            if (idToken != null) {
                originalUri = (String)originalUri + "&" + this.encode(this.oidcConfig.idTokenParamName()) + "=" + idToken;
            }
            if (!"@default".equals(tenantName)) {
                originalUri = (String)originalUri + "&" + this.encode(this.oidcConfig.tenantParamName()) + "=" + this.encode(tenantName);
            }
        }
        originalUri = this.increaseRedirectCounter((String)originalUri);
        res.headers().add(HeaderNames.LOCATION, new String[]{originalUri});
        if (this.oidcConfig.useCookie()) {
            try {
                JsonObject accessTokenJson = JSON_BUILDER_FACTORY.createObjectBuilder().add("accessToken", accessToken).add("remotePeer", req.remotePeer().host()).build();
                String encodedAccessToken = Base64.getEncoder().encodeToString(accessTokenJson.toString().getBytes(StandardCharsets.UTF_8));
                ServerResponseHeaders headers = res.headers();
                OidcCookieHandler tenantCookieHandler = this.oidcConfig.tenantCookieHandler();
                headers.addCookie(tenantCookieHandler.createCookie(tenantName).build());
                headers.addCookie(this.tokenCookieHandler.createCookie(encodedAccessToken).build());
                if (refreshToken != null) {
                    headers.addCookie(this.refreshTokenCookieHandler.createCookie(refreshToken).build());
                }
                if (idToken != null) {
                    headers.addCookie(this.idTokenCookieHandler.createCookie(idToken).build());
                }
                res.send();
            }
            catch (Exception e) {
                this.sendError(res, e);
            }
        } else {
            res.send();
        }
        return "done";
    }

    private String encode(String toEncode) {
        return URLEncoder.encode(toEncode, StandardCharsets.UTF_8);
    }

    private void sendError(ServerResponse response, Throwable t) {
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Failed to process OIDC request", t);
        }
        response.status(Status.INTERNAL_SERVER_ERROR_500).send();
    }

    private Optional<String> processError(ServerResponse serverResponse, Status status, String entity) {
        LOGGER.log(System.Logger.Level.DEBUG, "Invalid token or failed request when connecting to OIDC Token Endpoint. Response: " + entity + ", response status: " + String.valueOf(status));
        this.sendErrorResponse(serverResponse);
        return Optional.empty();
    }

    private Optional<String> processError(ServerResponse res, Throwable t, String message) {
        LOGGER.log(System.Logger.Level.DEBUG, message, t);
        this.sendErrorResponse(res);
        return Optional.empty();
    }

    private void sendErrorResponse(ServerResponse serverResponse) {
        serverResponse.status(Status.UNAUTHORIZED_401);
        serverResponse.send((Object)"Not a valid authorization code");
    }

    String increaseRedirectCounter(String state) {
        if (state.contains("?")) {
            Pattern attemptPattern = Pattern.compile(".*?(" + this.oidcConfig.redirectAttemptParam() + "=\\d+).*");
            Matcher matcher = attemptPattern.matcher(state);
            if (matcher.matches()) {
                String attempts = matcher.group(1);
                int equals = attempts.lastIndexOf(61);
                String count = attempts.substring(equals + 1);
                int countNumber = Integer.parseInt(count);
                return state.replace(attempts, this.oidcConfig.redirectAttemptParam() + "=" + ++countNumber);
            }
            return state + "&" + this.oidcConfig.redirectAttemptParam() + "=1";
        }
        return state + "?" + this.oidcConfig.redirectAttemptParam() + "=1";
    }

    private void processError(ServerRequest req, ServerResponse res) {
        String error = (String)req.query().first("error").orElse((Object)"invalid_request");
        String errorDescription = (String)req.query().first("error_description").orElseGet(() -> "Failed to process authorization request. Expected redirect from OIDC server with code parameter, but got: " + String.valueOf(req.query()));
        LOGGER.log(System.Logger.Level.WARNING, () -> "Received request on OIDC endpoint with no code. Error: " + error + " Error description: " + errorDescription);
        res.status(Status.BAD_REQUEST_400);
        res.send((Object)("{\"error\": \"" + error + "\", \"error_description\": \"" + errorDescription + "\"}"));
    }

    private CorsSupport prepareCrossOriginSupport(String path, CrossOriginConfig crossOriginConfig) {
        return crossOriginConfig == null ? null : ((CorsSupport.Builder)CorsSupport.builder().addCrossOrigin(path, crossOriginConfig)).build();
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, OidcFeature> {
        private static final int BUILDER_WEIGHT = 50000;
        private static final int DEFAULT_WEIGHT = 100000;
        private final HelidonServiceLoader.Builder<TenantConfigProvider> tenantConfigProviders = HelidonServiceLoader.builder(ServiceLoader.load(TenantConfigProvider.class)).defaultWeight(100000.0);
        private boolean enabled = true;
        private Config config = Config.empty();
        private OidcConfig oidcConfig;
        private List<TenantConfigFinder> tenantConfigFinders;

        private Builder() {
        }

        private static Optional<Config> findMyKey(Config rootConfig, String providerName) {
            if (rootConfig.key().name().equals(providerName)) {
                return Optional.of(rootConfig);
            }
            return ((List)rootConfig.get("security.providers").asNodeList().orElseGet(List::of)).stream().filter(it -> it.get(providerName).exists()).findFirst().map(it -> it.get(providerName));
        }

        public OidcFeature build() {
            if (this.enabled && this.oidcConfig == null) {
                throw new IllegalStateException("When OIDC and security is enabled, OIDC configuration must be provided");
            }
            this.tenantConfigFinders = this.tenantConfigProviders.build().asList().stream().map(provider -> provider.createTenantConfigFinder((io.helidon.common.config.Config)this.config)).collect(Collectors.toList());
            return new OidcFeature(this);
        }

        public Builder config(Config config) {
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            if (this.enabled) {
                this.oidcConfig = OidcConfig.create((io.helidon.common.config.Config)config);
            }
            return this;
        }

        public Builder config(OidcConfig config) {
            this.oidcConfig = config;
            return this;
        }

        public Builder config(Config config, String providerName) {
            config.get("security.enabled").asBoolean().ifPresent(this::enabled);
            Builder.findMyKey(config, providerName).ifPresentOrElse(this::config, () -> this.enabled(false));
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder discoverTenantConfigProviders(boolean discoverConfigProviders) {
            this.tenantConfigProviders.useSystemServiceLoader(discoverConfigProviders);
            return this;
        }

        public Builder addTenantConfigFinder(TenantConfigFinder configFinder) {
            return this.addTenantConfigFinder(configFinder, 50000);
        }

        public Builder addTenantConfigFinder(TenantConfigFinder configFinder, int priority) {
            this.tenantConfigProviders.addService(config -> configFinder, (double)priority);
            return this;
        }
    }
}

