/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc;

import io.helidon.common.parameters.Parameters;
import io.helidon.http.HeaderNames;
import io.helidon.security.providers.oidc.common.OidcConfig;
import io.helidon.security.providers.oidc.common.TenantConfig;
import io.helidon.webclient.api.HttpClientRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

class OidcUtil {
    private OidcUtil() {
    }

    static void updateRequest(OidcConfig.RequestType type, TenantConfig tenantConfig, Parameters.Builder form, HttpClientRequest request) {
        if (type == OidcConfig.RequestType.CODE_TO_TOKEN) {
            if (tenantConfig.tokenEndpointAuthentication() == OidcConfig.ClientAuthentication.CLIENT_SECRET_POST) {
                form.add("client_id", new String[]{tenantConfig.clientId()});
                form.add("client_secret", new String[]{tenantConfig.clientSecret()});
            } else if (tenantConfig.tokenEndpointAuthentication() == OidcConfig.ClientAuthentication.CLIENT_CERTIFICATE) {
                if (tenantConfig.serverType().equals("idcs")) {
                    String toEncode = tenantConfig.clientId() + ":" + tenantConfig.clientSecret();
                    String encoded = Base64.getEncoder().encodeToString(toEncode.getBytes(StandardCharsets.UTF_8));
                    request.header(HeaderNames.AUTHORIZATION, new String[]{"Basic " + encoded});
                } else {
                    form.add("client_id", new String[]{tenantConfig.clientId()});
                }
            }
        }
    }
}

