/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.servicecommon.restcdi;

import io.helidon.servicecommon.restcdi.InterceptionRunnerImpl;
import java.lang.reflect.Executable;
import javax.enterprise.context.Dependent;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

public interface HelidonInterceptor<W> {
    default public Object aroundConstruction(InvocationContext context) throws Exception {
        return InterceptionRunnerImpl.create(context.getConstructor()).run(context, this.workItems(context.getConstructor()), this::preInvocation);
    }

    public Object aroundConstruct(InvocationContext var1) throws Exception;

    default public Object aroundInvocation(InvocationContext context) throws Exception {
        return InterceptionRunnerImpl.create(context.getMethod()).run(context, this.workItems(context.getMethod()), this::preInvocation);
    }

    public Object aroundInvoke(InvocationContext var1) throws Exception;

    public Iterable<W> workItems(Executable var1);

    public void preInvocation(InvocationContext var1, W var2);

    public static interface WithPostCompletion<W>
    extends HelidonInterceptor<W> {
        @Override
        default public Object aroundConstruction(InvocationContext context) throws Exception {
            return InterceptionRunnerImpl.create(context.getConstructor()).run(context, this.workItems(context.getConstructor()), this::preInvocation, this::postCompletion);
        }

        @Override
        default public Object aroundInvocation(InvocationContext context) throws Exception {
            return InterceptionRunnerImpl.create(context.getMethod()).run(context, this.workItems(context.getMethod()), this::preInvocation, this::postCompletion);
        }

        public void postCompletion(InvocationContext var1, Throwable var2, W var3);
    }

    @Dependent
    public static abstract class Base<W>
    implements HelidonInterceptor<W> {
        @Override
        @AroundConstruct
        public Object aroundConstruct(InvocationContext context) throws Exception {
            return this.aroundConstruction(context);
        }

        @Override
        @AroundInvoke
        public Object aroundInvoke(InvocationContext context) throws Exception {
            return this.aroundInvocation(context);
        }
    }
}

